/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.tools.swing.impl;

import java.awt.Component;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Utils {
    private static final Logger LOGGER = LoggerFactory.getLogger(Utils.class);

    private Utils() {
    }

    public static void fireFocusEvent(Component c, int eventId) {
        Object[] focusListeners = (FocusListener[])c.getListeners(FocusListener.class);
        if (!ArrayUtils.isEmpty((Object[])focusListeners)) {
            for (Object focusListener : focusListeners) {
                if (focusListener == null) continue;
                try {
                    FocusEvent e = new FocusEvent(c, eventId);
                    switch (eventId) {
                        case 1004: {
                            focusListener.focusGained(e);
                            break;
                        }
                        case 1005: {
                            focusListener.focusLost(e);
                        }
                    }
                }
                catch (Throwable t) {
                    LOGGER.warn("Can't fire eveny focusGained on DropDownLabel (" + focusListener.getClass().getName() + ").", t);
                }
            }
        }
    }

    public static void propagateFocusEvent(Component source, final Component target) {
        source.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                Utils.fireFocusEvent(target, 1004);
            }

            @Override
            public void focusLost(FocusEvent e) {
                Utils.fireFocusEvent(target, 1005);
            }
        });
    }
}

