/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.tools.swing.impl.hexeditor;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import javax.swing.JComponent;
import org.gvsig.tools.swing.api.viewer.AbstractJViewer;
import org.gvsig.tools.swing.api.viewer.ViewerFactory;
import org.gvsig.tools.swing.impl.hexeditor.swing.HexEditorComponent;

public class HexEditor<T>
extends AbstractJViewer<T> {
    private final HexEditorComponent component = new HexEditorComponent();

    public HexEditor(ViewerFactory factory) {
        super(factory);
    }

    public void clean() {
    }

    public JComponent asJComponent() {
        return this.component;
    }

    public void setContents(T data) {
        try {
            if (data instanceof byte[]) {
                ByteArrayInputStream bos = new ByteArrayInputStream((byte[])data);
                this.component.open(bos);
                return;
            }
            if (data instanceof String) {
                ByteArrayInputStream bos = new ByteArrayInputStream(((String)data).getBytes(StandardCharsets.UTF_8));
                this.component.open(bos);
                return;
            }
            if (data instanceof InputStream) {
                this.component.open((InputStream)data);
                return;
            }
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("Can't load hex editor", ex);
        }
        super.setContents(data);
    }
}

