/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.timesupport.impl.animation;

import java.util.Date;
import org.gvsig.timesupport.AbsoluteInterval;
import org.gvsig.timesupport.Duration;
import org.gvsig.timesupport.Interval;
import org.gvsig.timesupport.RelativeInstant;
import org.gvsig.timesupport.RelativeInterval;
import org.gvsig.timesupport.TimeSupportLocator;
import org.gvsig.timesupport.TimeSupportManager;
import org.gvsig.timesupport.animation.TimeAnimation;
import org.gvsig.tools.logger.FilteredLogger;
import org.gvsig.tools.observer.Observable;
import org.gvsig.tools.observer.ObservableHelper;
import org.gvsig.tools.observer.Observer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimeAnimationImpl
implements TimeAnimation,
Runnable {
    private static final Logger logger = LoggerFactory.getLogger(TimeAnimationImpl.class);
    private int status = 0;
    private RelativeInterval interval = null;
    private long stepInMillis;
    private int currentPosition;
    private int currentIteration;
    private int iterationCount;
    private Thread thread;
    private final TimeAnimation.TimeAnimationRenderer renderer;
    private final ObservableHelper observers = new ObservableHelper();
    private double framesPerSecond;
    private long pauseTime;
    private int stepScale;

    public TimeAnimationImpl(TimeAnimation.TimeAnimationRenderer renderer) {
        this.renderer = renderer;
        this.pauseTime = 10L;
        this.iterationCount = 1;
        this.framesPerSecond = 0.3;
        this.stepScale = 7;
    }

    public void addObserver(Observer obsrvr) {
        this.observers.addObserver(obsrvr);
    }

    public void deleteObserver(Observer obsrvr) {
        this.observers.deleteObserver(obsrvr);
    }

    public void deleteObservers() {
        this.observers.deleteObservers();
    }

    public RelativeInterval getInterval() {
        return this.interval;
    }

    public void setInterval(RelativeInterval interval) {
        if (this.status != 0) {
            if (interval == null) {
                throw new IllegalArgumentException("Can't set interval (null), Illegal state (" + this.getStatusLabel() + ").");
            }
            throw new IllegalArgumentException("Can't set interval (" + interval.toString() + "), Illegal state (" + this.getStatusLabel() + ").");
        }
        this.interval = interval;
        this.inferStepScale();
        this.notifyObservers();
    }

    public long getStep() {
        return this.stepInMillis;
    }

    public void setStep(long step) {
        if (this.status != 0) {
            throw new IllegalArgumentException("Can't set step (" + step + "), Illegal state (" + this.getStatusLabel() + ").");
        }
        this.stepScale = 7;
        this.stepInMillis = step;
        this.notifyObservers();
    }

    public long getStep(int scale) {
        switch (scale) {
            case 7: {
                return this.stepInMillis;
            }
            case 6: {
                return this.stepInMillis / 1000L;
            }
            case 5: {
                return this.stepInMillis / 60000L;
            }
            case 4: {
                return this.stepInMillis / 3600000L;
            }
            case 3: {
                return this.stepInMillis / 86400000L;
            }
            case 2: {
                return this.stepInMillis / 604800000L;
            }
            case 1: {
                return this.stepInMillis / -1702967296L;
            }
        }
        return this.stepInMillis * 1471228928L;
    }

    public int getStepScale() {
        return this.stepScale;
    }

    public void setStep(long step, int scale) {
        if (this.status != 0) {
            throw new IllegalArgumentException("Can't set step (" + step + "," + this.getScaleLabel(scale) + "), Illegal state (" + this.getStatusLabel() + ").");
        }
        this.stepScale = scale;
        switch (scale) {
            case 7: {
                this.stepInMillis = step;
                break;
            }
            case 6: {
                this.stepInMillis = step * 1000L;
                break;
            }
            case 5: {
                this.stepInMillis = step * 60L * 1000L;
                break;
            }
            case 4: {
                this.stepInMillis = step * 60L * 60L * 1000L;
                break;
            }
            case 3: {
                this.stepInMillis = step * 24L * 60L * 60L * 1000L;
                break;
            }
            case 2: {
                this.stepInMillis = step * 7L * 24L * 60L * 60L * 1000L;
                break;
            }
            case 1: {
                this.stepInMillis = step * 30L * 24L * 60L * 60L * 1000L;
                break;
            }
            default: {
                this.stepInMillis = step * 365L * 24L * 60L * 60L * 1000L;
            }
        }
        this.notifyObservers();
    }

    public void setFramesPerSecond(double fps) {
        this.framesPerSecond = fps;
        this.notifyObservers();
    }

    public double getFramesPerSecond() {
        return this.framesPerSecond;
    }

    public void setPauseTime(long time) {
        this.pauseTime = time;
    }

    public long getPauseTime() {
        return this.pauseTime;
    }

    public int getIterations() {
        return this.iterationCount;
    }

    public void setIterations(int iterations) {
        if (this.status != 0) {
            throw new IllegalArgumentException("Can't set num iterations (" + iterations + "), Illegal state (" + this.getStatusLabel() + ").");
        }
        this.iterationCount = iterations;
        this.notifyObservers();
    }

    public int getCurrentPosition() {
        return this.currentPosition;
    }

    public void setCurrentPosition(int position) {
        int stepCount = this.getStepCount();
        if (position < 0 || position > stepCount) {
            throw new IllegalArgumentException("Can't set position " + position + ", out of range (0," + stepCount + ").");
        }
        this.currentPosition = position;
        RelativeInterval currentTime = this.getCurrentTime();
        this.renderer.render((Interval)currentTime);
        this.notifyObservers();
    }

    public int getCurrentIteration() {
        return this.currentIteration;
    }

    public int getStepCount() {
        Duration duration = this.interval.toStandardDuration();
        long stepCount = duration.getMillis() / this.stepInMillis;
        return (int)stepCount;
    }

    public RelativeInterval getCurrentTime() {
        TimeSupportManager manager = TimeSupportLocator.getManager();
        if (this.interval instanceof RelativeInterval) {
            RelativeInterval interval = this.interval;
            RelativeInterval time = manager.createRelativeInterval(interval.getStart().toMillis() + (long)this.currentPosition * this.stepInMillis, interval.getStart().toMillis() + (long)this.currentPosition * this.stepInMillis + this.stepInMillis);
            return time;
        }
        AbsoluteInterval interval = (AbsoluteInterval)this.interval;
        RelativeInterval time = manager.createRelativeInterval((long)interval.getStart().getMillis() + (long)this.currentPosition * this.stepInMillis, (long)interval.getStart().getMillis() + (long)this.currentPosition * this.stepInMillis + this.stepInMillis);
        return time;
    }

    public int getStatus() {
        return this.status;
    }

    public boolean isPlaying() {
        return this.status == 1;
    }

    public synchronized void stop() {
        if (this.status != 0) {
            try {
                this.renderer.end();
            }
            catch (Throwable th) {
                logger.warn("Problems do render.end", th);
            }
        }
        this.status = 0;
        this.currentIteration = 0;
        this.currentPosition = 0;
        this.notifyObservers();
    }

    public synchronized void pause() {
        this.status = 2;
        this.notifyObservers();
    }

    public synchronized void play() {
        switch (this.status) {
            case 1: {
                return;
            }
            case 0: {
                try {
                    this.renderer.begin();
                }
                catch (Throwable th) {
                    logger.warn("Problems do render.begin", th);
                }
                break;
            }
        }
        this.status = 1;
        if (this.thread == null || !this.thread.isAlive()) {
            this.thread = new Thread((Runnable)this, "TimeAnimation" + Integer.toHexString(this.hashCode()));
            this.thread.start();
        }
        this.notifyObservers();
    }

    @Override
    public void run() {
        int stepCount = this.getStepCount();
        int frameDuration = (int)(1000.0 / this.framesPerSecond);
        FilteredLogger logger = new FilteredLogger(TimeAnimationImpl.logger, "TimeAnimation", 10);
        while (this.currentIteration < this.iterationCount) {
            while (this.currentPosition < stepCount) {
                while (this.status == 2) {
                    try {
                        Thread.sleep(this.pauseTime);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                if (this.status == 0) {
                    return;
                }
                long renderStartTime = new Date().getTime();
                this.setCurrentPosition(this.currentPosition);
                long timeRemaining = (long)frameDuration - (new Date().getTime() - renderStartTime);
                if (timeRemaining > 0L) {
                    try {
                        Thread.sleep(timeRemaining);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                ++this.currentPosition;
            }
            ++this.currentIteration;
        }
        this.stop();
    }

    private void notifyObservers() {
        Thread th = new Thread(new Runnable(){

            @Override
            public void run() {
                TimeAnimationImpl.this.observers.notifyObservers((Observable)TimeAnimationImpl.this, null);
            }
        }, "TimeAnimationNotify" + Integer.toHexString(this.hashCode()));
        th.start();
    }

    public void inferStepScale() {
        RelativeInstant start = this.interval.getStart();
        RelativeInstant end = this.interval.getEnd();
        int years = end.getYear() - start.getYear();
        int scale = 0;
        if (years == 1) {
            scale = 1;
        }
        if (years < 1) {
            int months = end.getMonthOfYear() - start.getMonthOfYear();
            scale = 1;
            if (months == 1) {
                scale = 3;
            }
            if (months < 1) {
                int day = end.getDayOfMonth() - start.getDayOfMonth();
                scale = 3;
                if (day == 1) {
                    scale = 4;
                }
                if (day < 1) {
                    int hour = end.getHourOfDay() - start.getHourOfDay();
                    scale = 4;
                    if (hour == 1) {
                        scale = 6;
                    }
                    if (hour < 1) {
                        int second = end.getSecondOfDay() - start.getSecondOfDay();
                        scale = 6;
                        if (second == 1) {
                            scale = 7;
                        }
                        if (second < 1) {
                            scale = 7;
                        }
                    }
                }
            }
        }
        this.setStep(1L, scale);
    }

    private String getStatusLabel() {
        return this.getStatusLabel(this.status);
    }

    public String getStatusLabel(int status) {
        switch (status) {
            case 1: {
                return "Playing";
            }
            case 2: {
                return "Paused";
            }
            case 0: {
                return "Stoped";
            }
        }
        return "Unknow(" + this.status + ")";
    }

    public String getScaleLabel(int scale) {
        switch (scale) {
            case 7: {
                return "Milliseconds";
            }
            case 6: {
                return "Seconds";
            }
            case 5: {
                return "Minutes";
            }
            case 4: {
                return "Hours";
            }
            case 3: {
                return "Days";
            }
            case 2: {
                return "Weeks";
            }
            case 1: {
                return "Months";
            }
            case 0: {
                return "Years";
            }
        }
        return "Unknow(" + scale + ")";
    }
}

