/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.timesupport.impl.coercion;

import java.text.DateFormat;
import java.text.ParseException;
import java.util.Date;
import org.apache.commons.lang3.math.NumberUtils;
import org.gvsig.timesupport.RelativeInstant;
import org.gvsig.timesupport.TimeSupportLocator;
import org.gvsig.timesupport.TimeSupportManager;
import org.gvsig.tools.dataTypes.AbstractCoercion;
import org.gvsig.tools.dataTypes.CoercionContext;
import org.gvsig.tools.dataTypes.CoercionContextLocale;
import org.gvsig.tools.dataTypes.CoercionException;
import org.gvsig.tools.dataTypes.DataTypeUtils;

public class CoerceToInstant
extends AbstractCoercion {
    public Object coerce(Object value, CoercionContext context) throws CoercionException {
        if (value == null || value instanceof RelativeInstant) {
            return value;
        }
        TimeSupportManager manager = TimeSupportLocator.getManager();
        if (value instanceof Date) {
            RelativeInstant instant = manager.createRelativeInstant((Date)value);
            return instant;
        }
        if (value instanceof Number) {
            RelativeInstant instant = manager.createRelativeInstant(((Number)value).longValue());
            return instant;
        }
        if (value instanceof String) {
            long milis_l = NumberUtils.toLong((String)((String)value), (long)Long.MIN_VALUE);
            if (milis_l != Long.MIN_VALUE) {
                RelativeInstant instant = manager.createRelativeInstant(milis_l);
                return instant;
            }
            double milis_d = NumberUtils.toDouble((String)((String)value), (double)Double.NaN);
            if (milis_d != Double.NaN) {
                RelativeInstant instant = manager.createRelativeInstant((long)milis_d);
                return instant;
            }
            CoercionContextLocale theContext = context instanceof CoercionContextLocale ? (CoercionContextLocale)context : DataTypeUtils.coerceContextDefaultLocale();
            DateFormat df = DateFormat.getDateTimeInstance(2, 2, theContext.locale());
            try {
                Date date = df.parse((String)value);
                RelativeInstant instant = manager.createRelativeInstant(date);
                return instant;
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        throw new CoercionException("Can't coerce (" + value.getClass().getSimpleName() + ") '" + value.toString() + "' to Instant.");
    }
}

