/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.timesupport.impl.coercion;

import java.text.DateFormat;
import java.text.ParseException;
import java.util.Date;
import org.apache.commons.lang3.math.NumberUtils;
import org.gvsig.timesupport.RelativeInstant;
import org.gvsig.timesupport.RelativeInterval;
import org.gvsig.timesupport.TimeSupportLocator;
import org.gvsig.timesupport.TimeSupportManager;
import org.gvsig.tools.dataTypes.AbstractCoercion;
import org.gvsig.tools.dataTypes.CoercionContext;
import org.gvsig.tools.dataTypes.CoercionContextLocale;
import org.gvsig.tools.dataTypes.CoercionException;
import org.gvsig.tools.dataTypes.DataTypeUtils;

public class CoerceToInterval
extends AbstractCoercion {
    public Object coerce(Object value, CoercionContext context) throws CoercionException {
        if (value == null || value instanceof RelativeInterval) {
            return value;
        }
        TimeSupportManager manager = TimeSupportLocator.getManager();
        if (value instanceof RelativeInstant) {
            RelativeInterval interval = manager.createRelativeInterval((RelativeInstant)value, (RelativeInstant)value);
            return interval;
        }
        if (value instanceof Date) {
            RelativeInterval interval = manager.createRelativeInterval(((Date)value).getTime(), ((Date)value).getTime());
            return interval;
        }
        if (value instanceof Number) {
            RelativeInterval interval = manager.createRelativeInterval(((Number)value).longValue(), ((Number)value).longValue());
            return interval;
        }
        if (value instanceof String) {
            long milis_l = NumberUtils.toLong((String)((String)value), (long)Long.MIN_VALUE);
            if (milis_l != Long.MIN_VALUE) {
                RelativeInterval interval = manager.createRelativeInterval(milis_l, milis_l);
                return interval;
            }
            double milis_d = NumberUtils.toDouble((String)((String)value), (double)Double.NaN);
            if (milis_d != Double.NaN) {
                RelativeInterval interval = manager.createRelativeInterval((long)milis_d, (long)milis_d);
                return interval;
            }
            CoercionContextLocale theContext = context instanceof CoercionContextLocale ? (CoercionContextLocale)context : DataTypeUtils.coerceContextDefaultLocale();
            DateFormat df = DateFormat.getDateTimeInstance(2, 2, theContext.locale());
            try {
                Date date = df.parse((String)value);
                RelativeInterval interval = manager.createRelativeInterval(date.getTime(), date.getTime());
                return interval;
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        throw new CoercionException("Can't coerce (" + value.getClass().getSimpleName() + ") '" + value.toString() + "' to Interval.");
    }
}

