/*
 * Decompiled with CFR 0.152.
 */
package gishur.awt;

import gishur.awt.Symbolbar;
import gishur.awt.SymbolbarElement;
import java.awt.Graphics;
import java.awt.event.MouseEvent;

public class SymbolSplitElement
extends SymbolbarElement {
    private SymbolbarElement upper;
    private SymbolbarElement lower;
    public int element_space = 1;
    private SymbolbarElement active_element = null;
    private int _last_split;

    public void mouseClicked(MouseEvent mouseEvent) {
        if (this.active_element == null) {
            return;
        }
        this.active_element.mouseClicked(mouseEvent);
        this._needs_repaint |= this.active_element._needs_repaint;
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (this.active_element == null) {
            return;
        }
        this.active_element.mousePressed(mouseEvent);
        this._needs_repaint |= this.active_element._needs_repaint;
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (this.active_element == null) {
            return;
        }
        this.active_element.mouseDragged(mouseEvent);
        this._needs_repaint |= this.active_element._needs_repaint;
    }

    public SymbolSplitElement(String string, SymbolbarElement symbolbarElement, SymbolbarElement symbolbarElement2) {
        this.upper = symbolbarElement;
        this.lower = symbolbarElement2;
        this.upper.width = this.lower.width = (this.width = Math.max(this.upper.width, this.lower.width));
        this.label = string;
    }

    protected void setParent(Symbolbar symbolbar) {
        super.setParent(symbolbar);
        this.upper.setParent(symbolbar);
        this.lower.setParent(symbolbar);
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.active_element == null) {
            return;
        }
        this.active_element.mouseReleased(mouseEvent);
        this._needs_repaint |= this.active_element._needs_repaint;
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        SymbolbarElement symbolbarElement = null;
        if (mouseEvent.getY() < this._last_split) {
            symbolbarElement = this.upper;
        } else if (mouseEvent.getY() >= this._last_split + this.element_space) {
            symbolbarElement = this.lower;
        }
        if (this.active_element == symbolbarElement) {
            if (this.active_element != null) {
                this.active_element.mouseMoved(mouseEvent);
                this._needs_repaint |= this.active_element._needs_repaint;
                return;
            }
        } else {
            if (this.active_element != null) {
                this.active_element.mouseExited(mouseEvent);
                this._needs_repaint |= this.active_element._needs_repaint;
            }
            this.active_element = symbolbarElement;
            if (this.active_element != null) {
                this.active_element.mouseEntered(mouseEvent);
                this._needs_repaint |= this.active_element._needs_repaint;
            }
        }
    }

    public SymbolbarElement lower() {
        return this.lower;
    }

    public void update(Graphics graphics, int n) {
        Graphics graphics2 = graphics;
        graphics = graphics2.create();
        this._last_split = (n - this.element_space) / 2;
        graphics.setClip(0, 0, this.width, this._last_split);
        this.upper.update(graphics, this._last_split);
        this.upper._needs_repaint = false;
        graphics = graphics2.create();
        graphics.translate(0, this._last_split + this.element_space);
        graphics.setClip(0, 0, this.width, this._last_split);
        this.lower.update(graphics, this._last_split);
        this.lower._needs_repaint = false;
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        this.active_element = null;
        if (mouseEvent.getY() <= this._last_split) {
            this.active_element = this.upper;
        } else if (mouseEvent.getY() >= this._last_split + this.element_space) {
            this.active_element = this.lower;
        }
        if (this.active_element != null) {
            this.active_element.mouseEntered(mouseEvent);
            this._needs_repaint |= this.active_element._needs_repaint;
        }
    }

    public void mouseExited(MouseEvent mouseEvent) {
        if (this.active_element == null) {
            return;
        }
        this.active_element.mouseExited(mouseEvent);
        this._needs_repaint |= this.active_element._needs_repaint;
    }

    public void enable() {
        super.enable();
        this.upper.enable();
        this.lower.enable();
    }

    public void disable() {
        super.disable();
        this.upper.disable();
        this.lower.disable();
    }

    public int getPreferredHeight() {
        return this.upper.getPreferredHeight() + this.lower.getPreferredHeight() + this.element_space;
    }

    public SymbolbarElement upper() {
        return this.upper;
    }

    public void setActive(boolean bl) {
        super.setActive(bl);
        this.upper.setActive(bl);
        this.lower.setActive(bl);
    }
}

