/*
 * Decompiled with CFR 0.152.
 */
package gishur.awt;

import gishur.awt.Symbolbar;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Panel;
import java.awt.Rectangle;

public class SymbolbarArea
extends Panel {
    private Image _offscreen;
    private boolean _draw_upper_border_line = true;

    public void invalidate() {
        super.invalidate();
        this._offscreen = null;
    }

    public SymbolbarArea(boolean bl) {
        this.setBackground(Color.lightGray);
        this._draw_upper_border_line = bl;
    }

    public SymbolbarArea() {
        this(true);
    }

    public void paint(Graphics graphics) {
        if (this._offscreen == null) {
            this._offscreen = this.createImage(this.getSize().width, this.getSize().height);
        }
        Graphics graphics2 = this._offscreen.getGraphics();
        graphics2.setClip(0, 0, this.getSize().width, this.getSize().height);
        Dimension dimension = this.getSize();
        graphics2.setColor(this.getBackground());
        graphics2.fillRect(0, 0, dimension.width, dimension.height);
        if (this._draw_upper_border_line) {
            graphics2.setColor(this.getBackground().darker());
            graphics2.drawLine(0, 0, dimension.width, 0);
        }
        graphics2.setColor(this.getBackground());
        super.paint(graphics2);
        graphics.drawImage(this._offscreen, 0, 0, null);
        graphics2.dispose();
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    protected void testOverlap(Component component) {
        Component[] componentArray = this.getComponents();
        Rectangle rectangle = component.getBounds();
        int n = 0;
        n = 0;
        while (!(n >= componentArray.length || componentArray[n] != component && componentArray[n].getBounds().intersects(rectangle))) {
            ++n;
        }
        if (n >= componentArray.length) {
            return;
        }
        System.out.println(componentArray[n]);
        Rectangle rectangle2 = componentArray[n].getBounds();
        if (rectangle.x - rectangle2.x > 0 && rectangle.x - rectangle2.x < rectangle2.width / 2) {
            component.setLocation(rectangle2.x, rectangle.y);
            componentArray[n].setLocation(rectangle.x, rectangle2.y);
        } else if (rectangle.x > rectangle2.x) {
            component.setLocation(rectangle2.x + rectangle2.width, rectangle.y);
        }
        if (rectangle.x < rectangle2.x) {
            component.setLocation(rectangle2.x - rectangle.width, rectangle.y);
        }
    }

    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        dimension.width -= 10;
        dimension.height -= 9;
        return dimension;
    }

    public Dimension getMinimumSize() {
        return new Dimension(40, 40);
    }

    protected boolean intersectsOtherComponents(Component component) {
        Component[] componentArray = this.getComponents();
        Rectangle rectangle = component.getBounds();
        int n = 0;
        n = 0;
        while (!(n >= componentArray.length || componentArray[n] != component && componentArray[n].getBounds().intersects(rectangle))) {
            ++n;
        }
        return n < componentArray.length;
    }

    public void doLayout() {
        super.doLayout();
        Component[] componentArray = this.getComponents();
        Rectangle rectangle = this.getBounds();
        int n = 0;
        int n2 = 1;
        int n3 = 0;
        int n4 = rectangle.width;
        int n5 = 0;
        while (n5 < componentArray.length) {
            Rectangle rectangle2 = componentArray[n5].getBounds();
            if (n > 0 && n + rectangle2.width > n4) {
                n2 += n3;
                n = 0;
                n3 = rectangle2.height;
            }
            if (componentArray[n5] instanceof Symbolbar) {
                if (((Symbolbar)componentArray[n5]).alignment == 2) {
                    componentArray[n5].setLocation(n4 -= rectangle2.width, n2);
                } else {
                    componentArray[n5].setLocation(n, n2);
                    n += rectangle2.width;
                }
            }
            n3 = Math.max(n3, rectangle2.height);
            ++n5;
        }
    }
}

