/*
 * Decompiled with CFR 0.152.
 */
package gishur.awt;

import gishur.awt.SymbolButton;
import gishur.awt.SymbolImageButton;
import gishur.awt.Symbolbar;
import gishur.awt.images.ZoomSymbols;
import gishur.gui.DisplayManager;
import gishur.gui.Layer;
import gishur.gui.inputhandler.Selector;
import gishur.gui.inputhandler.TranslateHandler;
import gishur.gui.inputhandler.ZoomHandler;
import java.awt.Image;
import java.awt.Menu;
import java.awt.MenuItem;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;

public class ZoomBar
extends Symbolbar {
    public String in_label = "Zoom in";
    public String out_label = "Zoom out";
    public String orginal_label = "Zoom 1:1";
    public String objects_label = "Zoom Objects";
    public String selected_label = "Zoom Selected";
    public String zoom_label = "Zoom";
    public String translate_label = "Translate";
    public byte objectspace = (byte)16;
    private Layer[] _layer = null;
    private DisplayManager _display;
    private TranslateHandler _translate = null;
    private ZoomHandler _zoom = null;
    private Selector _selector = null;
    private SymbolImageButton _zoombutton;
    private SymbolImageButton _translatebutton;

    private void ensureHandlerSettings() {
        if (this._translate != null) {
            this._translate.setLayers(this._layer);
        }
        if (this._zoom != null) {
            this._zoom.setLayers(this._layer);
        }
    }

    public void translateModeOff() {
        if (this._translate != null) {
            this._translate.disable();
        }
    }

    public ZoomBar(String string, DisplayManager displayManager, int n) {
        super(string, 8);
        this._display = displayManager;
        if (n >= 0) {
            this._layer = new Layer[n];
        }
        this.setButtons(true, true, true, true, true, true, true);
    }

    public ZoomBar(String string, DisplayManager displayManager, int n, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, boolean bl7) {
        this(string, displayManager, n);
        this.setButtons(bl, bl2, bl3, bl4, bl5, bl6, bl7);
    }

    public void add(Layer layer) {
        int n = 0;
        while (n < this._layer.length && this._layer[n] != null) {
            ++n;
        }
        if (n >= this._layer.length) {
            return;
        }
        this._layer[n] = layer;
    }

    public void setZoomHandler(ZoomHandler zoomHandler) {
        this._zoom = zoomHandler;
        if (this._zoom != null) {
            this._zoom.disable();
        }
        this.ensureHandlerSettings();
    }

    private void stripStdImages() {
        Image image = ZoomSymbols.createImage();
        String[] stringArray = new String[]{this.in_label, this.out_label, this.orginal_label, this.objects_label, this.selected_label, this.zoom_label, this.translate_label};
        int n = 1;
        do {
            if (this.element(n) == null || !(this.element(n) instanceof SymbolImageButton)) continue;
            SymbolImageButton symbolImageButton = (SymbolImageButton)this.element(n);
            int n2 = this.getLabelIndex(symbolImageButton.label, stringArray);
            symbolImageButton.setEnabledImage(image, new Rectangle(n2 * 18, 0, 18, 18));
            symbolImageButton.setDisabledImage(image, new Rectangle(126 + n2 * 18, 0, 18, 18));
        } while (++n <= 7);
    }

    public void zoomModeOn() {
        if (this._translatebutton != null && this._translatebutton.pressed()) {
            this._translatebutton.setButton(false);
            this.translateModeOff();
        }
        if (this._zoom != null) {
            this._zoom.enable();
        }
    }

    public void zoomOut() {
        Rectangle rectangle = this._display.getViewPort();
        Point point = new Point(rectangle.x + rectangle.width / 2, rectangle.y + rectangle.height / 2);
        int n = 0;
        while (n < this._layer.length && this._layer[n] != null) {
            this._layer[n].getTransformation().scale(point, 0.8, 0.8);
            ++n;
        }
        this._display.repaint((byte)1);
    }

    public void processActionEvent(ActionEvent actionEvent) {
        super.processActionEvent(actionEvent);
        String string = actionEvent.getActionCommand();
        if (string == this.in_label) {
            this.zoomIn();
        }
        if (string == this.out_label) {
            this.zoomOut();
        }
        if (string == this.orginal_label) {
            this.zoomOrginal();
        }
        if (string == this.objects_label) {
            this.zoomObjects();
        }
        if (string == this.selected_label) {
            this.zoomSelected();
        }
        if (string == this.zoom_label) {
            if (actionEvent.getID() == 2201) {
                this.zoomModeOn();
            } else {
                this.zoomModeOff();
            }
        }
        if (string == this.translate_label) {
            if (actionEvent.getID() == 2201) {
                this.translateModeOn();
                return;
            }
            this.translateModeOff();
        }
    }

    public void setSelector(Selector selector) {
        this._selector = selector;
    }

    public void zoomOrginal() {
        int n = 0;
        while (n < this._layer.length && this._layer[n] != null) {
            this._layer[n].getTransformation().resetTransform();
            ++n;
        }
        this._display.repaint((byte)1);
    }

    public void setTranslateHandler(TranslateHandler translateHandler) {
        this._translate = translateHandler;
        if (this._translate != null) {
            this._translate.disable();
        }
        this.ensureHandlerSettings();
    }

    public void zoomModeOff() {
        if (this._zoom != null) {
            this._zoom.disable();
        }
    }

    public void setButtons(boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, boolean bl7) {
        this.clearAll();
        if (bl) {
            this.add(new SymbolImageButton(this.in_label, false));
        }
        if (bl2) {
            this.add(new SymbolImageButton(this.out_label, false));
        }
        if (bl3) {
            this.add(new SymbolImageButton(this.orginal_label, false));
        }
        if (bl4) {
            this.add(new SymbolImageButton(this.objects_label, false));
        }
        if (bl5) {
            this.add(new SymbolImageButton(this.selected_label, false));
        }
        if (bl6) {
            this._zoombutton = new SymbolImageButton(this.zoom_label, true);
            this.add(this._zoombutton);
        }
        if (bl7) {
            this._translatebutton = new SymbolImageButton(this.translate_label, true);
            this.add(this._translatebutton);
        }
        this.ensureHandlerSettings();
        this.stripStdImages();
    }

    public void zoomIn() {
        Rectangle rectangle = this._display.getViewPort();
        Point point = new Point(rectangle.x + rectangle.width / 2, rectangle.y + rectangle.height / 2);
        int n = 0;
        while (n < this._layer.length && this._layer[n] != null) {
            this._layer[n].getTransformation().scale(point, 1.25, 1.25);
            ++n;
        }
        this._display.repaint((byte)1);
    }

    public void zoomObjects() {
        Rectangle rectangle;
        Rectangle rectangle2 = null;
        int n = 0;
        while (n < this._layer.length && this._layer[n] != null) {
            rectangle = this._layer[n].getObjectArea();
            if (rectangle2 == null) {
                rectangle2 = rectangle;
            } else if (rectangle != null) {
                rectangle2 = rectangle2.union(rectangle);
            }
            ++n;
        }
        rectangle = this._display.getViewPort();
        if (rectangle2 == null || rectangle == null) {
            return;
        }
        rectangle2.x -= this.objectspace;
        rectangle2.y -= this.objectspace;
        rectangle2.width += 2 * this.objectspace;
        rectangle2.height += 2 * this.objectspace;
        if (this._zoom != null) {
            this._zoom.addStatusToZoomHistory();
        }
        n = 0;
        while (n < this._layer.length && this._layer[n] != null) {
            this._layer[n].getTransformation().zoomTo(rectangle, rectangle2, true);
            ++n;
        }
        this._display.repaint((byte)1);
    }

    public void translateModeOn() {
        if (this._zoombutton != null && this._zoombutton.pressed()) {
            this._zoombutton.setButton(false);
            this.zoomModeOff();
        }
        if (this._translate != null) {
            this._translate.enable();
        }
    }

    public void setLayers(Layer[] layerArray) {
        this._layer = layerArray;
        this.ensureHandlerSettings();
    }

    public Layer[] getLayers() {
        return this._layer;
    }

    public void zoomSelected() {
        if (this._selector == null) {
            return;
        }
        Rectangle rectangle = this._selector.calculateBounds();
        Rectangle rectangle2 = this._display.getViewPort();
        if (rectangle == null || rectangle2 == null) {
            return;
        }
        if (this._zoom != null) {
            this._zoom.addStatusToZoomHistory();
        }
        int n = 0;
        while (n < this._layer.length && this._layer[n] != null) {
            this._layer[n].getTransformation().zoomTo(rectangle2, rectangle, true);
            ++n;
        }
        this._display.repaint((byte)1);
    }

    private int getLabelIndex(String string, String[] stringArray) {
        int n = 0;
        while (n < stringArray.length && !string.equals(stringArray[n])) {
            ++n;
        }
        if (n >= stringArray.length) {
            return -1;
        }
        return n;
    }

    public void generateMenu(Menu menu) {
        int n = 0;
        int n2 = 0;
        while (n2 < 8 && this.element(n2) != null) {
            String string = this.element((int)n2).label;
            if (string == this.in_label || string == this.out_label || string == this.orginal_label || string == this.selected_label) {
                menu.add(((SymbolButton)this.element(n2)).generateMenuItem());
                ++n;
            }
            if (string == this.zoom_label || string == this.translate_label) {
                if (n > 0) {
                    menu.add(new MenuItem("-"));
                    n = 0;
                }
                menu.add(((SymbolButton)this.element(n2)).generateMenuItem());
            }
            ++n2;
        }
    }

    public void remove(Layer layer) {
        int n = 0;
        while (n < this._layer.length && this._layer[n] != layer) {
            ++n;
        }
        if (n >= this._layer.length) {
            return;
        }
        try {
            if (this._layer.length > 0 && n < this._layer.length - 1) {
                System.arraycopy(this._layer, n + 1, this._layer, n, this._layer.length - n - 1);
            }
            this._layer[this._layer.length - 1] = null;
            return;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return;
        }
        catch (ArrayStoreException arrayStoreException) {
            return;
        }
    }
}

