/*
 * Decompiled with CFR 0.152.
 */
package gishur.core;

import gishur.core.ArrayEnumeration;
import gishur.core.Filter;
import gishur.core.ListItem;
import gishur.core.SimpleList;
import java.util.Enumeration;

public class ClassFilter
extends Filter {
    private Class[] _class;
    private boolean _allowed_mode = true;

    public String toString() {
        return this.getClass().getName() + "[" + (this._allowed_mode ? "allowed={" : "forbidden={") + ArrayEnumeration.toString(this._class) + "}]";
    }

    public ClassFilter(Class clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException();
        }
        this._class = new Class[]{clazz};
    }

    public synchronized void add(Class clazz) {
        if (clazz == null) {
            return;
        }
        Class[] classArray = new Class[this._class.length + 1];
        System.arraycopy(this._class, 0, classArray, 0, this._class.length);
        classArray[classArray.length - 1] = clazz;
        this._class = classArray;
    }

    public synchronized void add(Class[] classArray) {
        if (classArray == null || classArray.length < 1) {
            return;
        }
        Class[] classArray2 = new Class[this._class.length + classArray.length];
        System.arraycopy(this._class, 0, classArray2, 0, this._class.length);
        System.arraycopy(classArray, 0, classArray2, this._class.length, classArray.length);
        this._class = classArray2;
    }

    public synchronized void add(Enumeration enumeration) {
        if (enumeration == null || !enumeration.hasMoreElements()) {
            return;
        }
        SimpleList simpleList = new SimpleList();
        Object var3_3 = null;
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            var3_3 = e;
            if (!(e instanceof Class)) continue;
            simpleList.add((Object)var3_3);
        }
        if (simpleList.empty()) {
            return;
        }
        Class[] classArray = new Class[this._class.length + simpleList.length()];
        System.arraycopy(this._class, 0, classArray, 0, this._class.length);
        int n = this._class.length;
        ListItem listItem = simpleList.first();
        while (listItem != null) {
            classArray[n++] = (Class)listItem.key();
            listItem = listItem.next();
        }
        this._class = classArray;
    }

    public boolean acceptMode() {
        return this._allowed_mode;
    }

    public void setAcceptMode(boolean bl) {
        this._allowed_mode = bl;
    }

    protected boolean check(Object object) {
        int n = 0;
        while (n < this._class.length) {
            if (this._class[n].isInstance(object)) {
                return this._allowed_mode;
            }
            ++n;
        }
        return !this._allowed_mode;
    }
}

