/*
 * Decompiled with CFR 0.152.
 */
package gishur.core;

import gishur.core.BasicList;
import gishur.core.Comparitor;
import gishur.core.List;
import gishur.core.ListItem;
import gishur.core.SimpleList;
import gishur.core.SimpleListItem;
import gishur.core.StdComparitor;
import java.util.Enumeration;
import java.util.NoSuchElementException;

public class Sorter {
    protected Comparitor _comparitor;
    public static final byte ASCENDING = 1;
    public static final byte DESCENDING = 2;
    private byte _order = 1;
    private Object[] _data;
    private boolean _sorted;

    public float[] sort(float[] fArray) {
        this.clear();
        this.add(fArray);
        this.sort();
        return this.getFloatArray();
    }

    public float[] sort(float[] fArray, int n, int n2) {
        this.clear();
        this.add(fArray, n, n2);
        this.sort();
        return this.getFloatArray();
    }

    public double[] sort(double[] dArray) {
        this.clear();
        this.add(dArray);
        this.sort();
        return this.getDoubleArray();
    }

    public double[] sort(double[] dArray, int n, int n2) {
        this.clear();
        this.add(dArray, n, n2);
        this.sort();
        return this.getDoubleArray();
    }

    public char[] sort(char[] cArray) {
        this.clear();
        this.add(cArray);
        this.sort();
        return this.getCharArray();
    }

    public char[] sort(char[] cArray, int n, int n2) {
        this.clear();
        this.add(cArray, n, n2);
        this.sort();
        return this.getCharArray();
    }

    public List sort(BasicList basicList) {
        this.clear();
        this.add(basicList);
        this.sort();
        return this.getList();
    }

    public Enumeration sort(Enumeration enumeration) {
        this.clear();
        this.add(enumeration);
        this.sort();
        return this.getEnumeration();
    }

    public void storeInList(BasicList basicList) {
        int n = 0;
        while (n < this._data.length) {
            if (this._data[n] instanceof ListItem) {
                basicList.add(basicList.last(), (ListItem)this._data[n], null, 1);
            } else {
                basicList.add(basicList.last(), new SimpleListItem(this._data[n]), null, 1);
            }
            ++n;
        }
    }

    public List getList() {
        if (!this._sorted) {
            this.sort();
        }
        if (this._data == null) {
            return null;
        }
        List list = new List();
        this.storeInList(list);
        return list;
    }

    public Enumeration getEnumeration() {
        return new SortEnumerator(this.getArray());
    }

    public long[] getLongArray() {
        if (!this._sorted) {
            this.sort();
        }
        if (this._data == null) {
            return null;
        }
        long[] lArray = new long[this._data.length];
        int n = 0;
        while (n < this._data.length) {
            if (this._data[n] != null && this._data[n] instanceof Number) {
                lArray[n] = ((Number)this._data[n]).longValue();
            }
            ++n;
        }
        return lArray;
    }

    public float[] getFloatArray() {
        if (!this._sorted) {
            this.sort();
        }
        if (this._data == null) {
            return null;
        }
        float[] fArray = new float[this._data.length];
        int n = 0;
        while (n < this._data.length) {
            if (this._data[n] != null && this._data[n] instanceof Number) {
                fArray[n] = ((Number)this._data[n]).floatValue();
            }
            ++n;
        }
        return fArray;
    }

    public boolean[] getBooleanArray() {
        if (!this._sorted) {
            this.sort();
        }
        if (this._data == null) {
            return null;
        }
        boolean[] blArray = new boolean[this._data.length];
        int n = 0;
        while (n < this._data.length) {
            if (this._data[n] != null && this._data[n] instanceof Boolean) {
                blArray[n] = (Boolean)this._data[n];
            }
            ++n;
        }
        return blArray;
    }

    public int length() {
        return this._data.length;
    }

    public String toString() {
        String string = "order=";
        if (this._order == 1) {
            string = string + "ASCENDING";
        }
        if (this._order == 2) {
            string = string + "DESCENDING";
        }
        string = this._sorted ? string + "/SORTED,length=" : string + ",length=";
        string = string + this._data.length + ",data={";
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < this._data.length) {
            stringBuffer.append(this._data[n]);
            if (n < this._data.length - 1) {
                stringBuffer.append(",");
            }
            ++n;
        }
        return this.getClass().getName() + "[" + string + stringBuffer.toString() + "}]";
    }

    public int BinSearch(Object[] objectArray, int n, int n2, Object object) {
        int n3 = (n + n2) / 2;
        if (n3 == n) {
            return -1;
        }
        short s = this._comparitor.compare(object, objectArray[n3]);
        if (s == -1) {
            return this.BinSearch(objectArray, n, n3, object);
        }
        if (s == 1) {
            return this.BinSearch(objectArray, n3, n2, object);
        }
        return n3;
    }

    public int BinSearch(int n, int n2, Object object) {
        if (this._data.length <= 0) {
            return -1;
        }
        if (!this._sorted) {
            this.sort();
        }
        return this.BinSearch(this._data, n, n2, object);
    }

    public int BinSearch(Object object) {
        if (this._data.length <= 0) {
            return -1;
        }
        if (!this._sorted) {
            this.sort();
        }
        return this.BinSearch(this._data, 0, this._data.length - 1, object);
    }

    public synchronized void setAscendingOrder() {
        if (this._order != 1) {
            this._sorted = false;
        }
        this._order = 1;
    }

    public synchronized void setDescendingOrder() {
        if (this._order != 2) {
            this._sorted = false;
        }
        this._order = (byte)2;
    }

    public List getQueue() {
        if (!this._sorted) {
            this.sort();
        }
        if (this._data == null) {
            return null;
        }
        List list = new List();
        this.storeInList(list);
        return list;
    }

    public boolean isSorted() {
        return this._sorted;
    }

    public synchronized void add(Object object) {
        this._data[this.makeItBigger((int)1)] = object;
    }

    public synchronized void add(int n) {
        this._data[this.makeItBigger((int)1)] = new Integer(n);
    }

    public synchronized void add(long l) {
        this._data[this.makeItBigger((int)1)] = new Long(l);
    }

    public synchronized void add(float f) {
        this._data[this.makeItBigger((int)1)] = new Float(f);
    }

    public synchronized void add(double d) {
        this._data[this.makeItBigger((int)1)] = new Double(d);
    }

    public synchronized void add(char c) {
        this._data[this.makeItBigger((int)1)] = new Character(c);
    }

    public synchronized void add(boolean bl) {
        this._data[this.makeItBigger((int)1)] = new Boolean(bl);
    }

    public synchronized void add(Object[] objectArray, int n, int n2) {
        if (objectArray == null) {
            return;
        }
        int n3 = this.makeItBigger(n2 - n + 1);
        try {
            if (n2 - n + 1 > 0) {
                System.arraycopy(objectArray, n, this._data, n3, n2 - n + 1);
                return;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return;
        }
        catch (ArrayStoreException arrayStoreException) {}
    }

    public synchronized void add(Object[] objectArray) {
        if (objectArray == null) {
            return;
        }
        this.add(objectArray, 0, objectArray.length - 1);
    }

    public synchronized void add(int[] nArray, int n, int n2) {
        if (nArray == null) {
            return;
        }
        int n3 = this.makeItBigger(n2 - n + 1);
        int n4 = 0;
        while (n4 < n2 - n + 1) {
            this._data[n3 + n4] = new Integer(nArray[n + n4]);
            ++n4;
        }
    }

    public synchronized void add(int[] nArray) {
        if (nArray == null) {
            return;
        }
        this.add(nArray, 0, nArray.length - 1);
    }

    protected synchronized void setArray(Object[] objectArray) {
        this._data = objectArray;
        this._sorted = false;
    }

    public synchronized void add(long[] lArray, int n, int n2) {
        if (lArray == null) {
            return;
        }
        int n3 = this.makeItBigger(n2 - n + 1);
        int n4 = 0;
        while (n4 < n2 - n + 1) {
            this._data[n3 + n4] = new Long(lArray[n + n4]);
            ++n4;
        }
    }

    public synchronized void add(long[] lArray) {
        if (lArray == null) {
            return;
        }
        this.add(lArray, 0, lArray.length - 1);
    }

    public synchronized void add(float[] fArray, int n, int n2) {
        if (fArray == null) {
            return;
        }
        int n3 = this.makeItBigger(n2 - n + 1);
        int n4 = 0;
        while (n4 < n2 - n + 1) {
            this._data[n3 + n4] = new Float(fArray[n + n4]);
            ++n4;
        }
    }

    public synchronized void add(float[] fArray) {
        if (fArray == null) {
            return;
        }
        this.add(fArray, 0, fArray.length - 1);
    }

    public synchronized void add(double[] dArray, int n, int n2) {
        if (dArray == null) {
            return;
        }
        int n3 = this.makeItBigger(n2 - n + 1);
        int n4 = 0;
        while (n4 < n2 - n + 1) {
            this._data[n3 + n4] = new Double(dArray[n + n4]);
            ++n4;
        }
    }

    public synchronized void add(double[] dArray) {
        if (dArray == null) {
            return;
        }
        this.add(dArray, 0, dArray.length - 1);
    }

    public synchronized void add(char[] cArray, int n, int n2) {
        if (cArray == null) {
            return;
        }
        int n3 = this.makeItBigger(n2 - n + 1);
        int n4 = 0;
        while (n4 < n2 - n + 1) {
            this._data[n3 + n4] = new Character(cArray[n + n4]);
            ++n4;
        }
    }

    public synchronized void add(char[] cArray) {
        if (cArray == null) {
            return;
        }
        this.add(cArray, 0, cArray.length - 1);
    }

    public synchronized void add(boolean[] blArray, int n, int n2) {
        if (blArray == null) {
            return;
        }
        int n3 = this.makeItBigger(n2 - n + 1);
        int n4 = 0;
        while (n4 < n2 - n + 1) {
            this._data[n3 + n4] = new Boolean(blArray[n + n4]);
            ++n4;
        }
    }

    public synchronized void add(boolean[] blArray) {
        if (blArray == null) {
            return;
        }
        this.add(blArray, 0, blArray.length - 1);
    }

    public synchronized void add(BasicList basicList) {
        if (basicList == null || basicList.length() <= 0) {
            return;
        }
        int n = this.makeItBigger(basicList.length());
        basicList.storeInArray(this._data, n, basicList.length(), null, (byte)0, false);
    }

    public void setComparitor(Comparitor comparitor) {
        if (comparitor != null) {
            if (comparitor != this._comparitor) {
                this._sorted = false;
            }
            this._comparitor = comparitor;
        }
    }

    public Comparitor getComparitor() {
        return this._comparitor;
    }

    public synchronized void add(Enumeration enumeration) {
        SimpleList simpleList = new SimpleList();
        while (enumeration.hasMoreElements()) {
            simpleList.add(enumeration.nextElement());
        }
        if (simpleList.empty()) {
            return;
        }
        int n = this.makeItBigger(simpleList.length());
        simpleList.storeInArray(this._data, n, simpleList.length(), null, (byte)1, false);
    }

    public Object[] getArray() {
        if (!this._sorted) {
            this.sort();
        }
        if (this._data == null) {
            return null;
        }
        Object[] objectArray = new Object[this._data.length];
        try {
            if (this._data.length > 0) {
                System.arraycopy(this._data, 0, objectArray, 0, this._data.length);
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
        }
        catch (ArrayStoreException arrayStoreException) {}
        return objectArray;
    }

    protected Object[] getUnsortedArray() {
        return this._data;
    }

    public char[] getCharArray() {
        if (!this._sorted) {
            this.sort();
        }
        if (this._data == null) {
            return null;
        }
        char[] cArray = new char[this._data.length];
        int n = 0;
        while (n < this._data.length) {
            if (this._data[n] != null && this._data[n] instanceof Character) {
                cArray[n] = ((Character)this._data[n]).charValue();
            }
            ++n;
        }
        return cArray;
    }

    private void swap(int n, int n2) {
        Object object = this._data[n];
        this._data[n] = this._data[n2];
        this._data[n2] = object;
    }

    public synchronized void HeapSort() {
        if (this._sorted) {
            return;
        }
        short s = this._order == 1 ? (short)-1 : 1;
        int n = this._data.length / 2;
        while (n > 0) {
            this.sift(n - 1, this._data.length - 1, s);
            --n;
        }
        n = this._data.length - 1;
        while (n > 0) {
            this.swap(0, n);
            this.sift(0, n - 1, s);
            --n;
        }
        this._sorted = true;
    }

    public Object[] HeapSort(Object[] objectArray) {
        this.clear();
        this.add(objectArray);
        this.HeapSort();
        return this.getArray();
    }

    public SimpleList getSimpleList() {
        if (!this._sorted) {
            this.sort();
        }
        if (this._data == null) {
            return null;
        }
        SimpleList simpleList = new SimpleList();
        this.storeInList(simpleList);
        return simpleList;
    }

    public Object[] HeapSort(Object[] objectArray, int n, int n2) {
        this.clear();
        this.add(objectArray, n, n2);
        this.HeapSort();
        return this.getArray();
    }

    public int[] HeapSort(int[] nArray) {
        this.clear();
        this.add(nArray);
        this.HeapSort();
        return this.getIntArray();
    }

    public int[] HeapSort(int[] nArray, int n, int n2) {
        this.clear();
        this.add(nArray, n, n2);
        this.HeapSort();
        return this.getIntArray();
    }

    public long[] HeapSort(long[] lArray) {
        this.clear();
        this.add(lArray);
        this.HeapSort();
        return this.getLongArray();
    }

    public long[] HeapSort(long[] lArray, int n, int n2) {
        this.clear();
        this.add(lArray, n, n2);
        this.HeapSort();
        return this.getLongArray();
    }

    public float[] HeapSort(float[] fArray) {
        this.clear();
        this.add(fArray);
        this.HeapSort();
        return this.getFloatArray();
    }

    public float[] HeapSort(float[] fArray, int n, int n2) {
        this.clear();
        this.add(fArray, n, n2);
        this.HeapSort();
        return this.getFloatArray();
    }

    public double[] HeapSort(double[] dArray) {
        this.clear();
        this.add(dArray);
        this.HeapSort();
        return this.getDoubleArray();
    }

    public double[] HeapSort(double[] dArray, int n, int n2) {
        this.clear();
        this.add(dArray, n, n2);
        this.HeapSort();
        return this.getDoubleArray();
    }

    public char[] HeapSort(char[] cArray) {
        this.clear();
        this.add(cArray);
        this.HeapSort();
        return this.getCharArray();
    }

    public char[] HeapSort(char[] cArray, int n, int n2) {
        this.clear();
        this.add(cArray, n, n2);
        this.HeapSort();
        return this.getCharArray();
    }

    public List HeapSort(BasicList basicList) {
        this.clear();
        this.add(basicList);
        this.HeapSort();
        return this.getList();
    }

    public Enumeration HeapSort(Enumeration enumeration) {
        this.clear();
        this.add(enumeration);
        this.HeapSort();
        return this.getEnumeration();
    }

    public Sorter(Comparitor comparitor) {
        this.clear();
        if (comparitor == null) {
            comparitor = new StdComparitor();
        }
        this._comparitor = comparitor;
        this._order = 1;
    }

    public Sorter() {
        this(null);
    }

    public synchronized void sort() {
        if (this._sorted) {
            return;
        }
        if (this._data.length < 10) {
            this.BubbleSort();
            return;
        }
        this.HeapSort();
    }

    private void sift(int n, int n2, short s) {
        ++n;
        ++n2;
        while (2 * n <= n2) {
            int n3 = 2 * n;
            if (n3 < n2 && this._comparitor.compare(this._data[n3 - 1], this._data[n3]) == s) {
                ++n3;
            }
            if (this._comparitor.compare(this._data[n - 1], this._data[n3 - 1]) == s) {
                this.swap(n - 1, n3 - 1);
                n = n3;
                continue;
            }
            n = n2;
        }
    }

    public synchronized void QuickSort() {
        if (this._sorted) {
            return;
        }
        short s = this._order == 1 ? (short)-1 : 1;
        if (this._data.length > 1) {
            this.qsort(0, this._data.length - 1, s);
        }
        this._sorted = true;
    }

    public Object[] QuickSort(Object[] objectArray) {
        this.clear();
        this.add(objectArray);
        this.QuickSort();
        return this.getArray();
    }

    public Object[] QuickSort(Object[] objectArray, int n, int n2) {
        this.clear();
        this.add(objectArray, n, n2);
        this.QuickSort();
        return this.getArray();
    }

    public int[] QuickSort(int[] nArray) {
        this.clear();
        this.add(nArray);
        this.QuickSort();
        return this.getIntArray();
    }

    public int[] QuickSort(int[] nArray, int n, int n2) {
        this.clear();
        this.add(nArray, n, n2);
        this.QuickSort();
        return this.getIntArray();
    }

    public long[] QuickSort(long[] lArray) {
        this.clear();
        this.add(lArray);
        this.QuickSort();
        return this.getLongArray();
    }

    public long[] QuickSort(long[] lArray, int n, int n2) {
        this.clear();
        this.add(lArray, n, n2);
        this.QuickSort();
        return this.getLongArray();
    }

    public float[] QuickSort(float[] fArray) {
        this.clear();
        this.add(fArray);
        this.QuickSort();
        return this.getFloatArray();
    }

    public float[] QuickSort(float[] fArray, int n, int n2) {
        this.clear();
        this.add(fArray, n, n2);
        this.QuickSort();
        return this.getFloatArray();
    }

    public double[] QuickSort(double[] dArray) {
        this.clear();
        this.add(dArray);
        this.QuickSort();
        return this.getDoubleArray();
    }

    public double[] QuickSort(double[] dArray, int n, int n2) {
        this.clear();
        this.add(dArray, n, n2);
        this.QuickSort();
        return this.getDoubleArray();
    }

    public char[] QuickSort(char[] cArray) {
        this.clear();
        this.add(cArray);
        this.QuickSort();
        return this.getCharArray();
    }

    public char[] QuickSort(char[] cArray, int n, int n2) {
        this.clear();
        this.add(cArray, n, n2);
        this.QuickSort();
        return this.getCharArray();
    }

    public List QuickSort(BasicList basicList) {
        this.clear();
        this.add(basicList);
        this.QuickSort();
        return this.getList();
    }

    public Enumeration QuickSort(Enumeration enumeration) {
        this.clear();
        this.add(enumeration);
        this.QuickSort();
        return this.getEnumeration();
    }

    public Object[] sort(Object[] objectArray) {
        this.clear();
        this.add(objectArray);
        this.sort();
        return this.getArray();
    }

    public Object[] sort(Object[] objectArray, int n, int n2) {
        this.clear();
        this.add(objectArray, n, n2);
        this.sort();
        return this.getArray();
    }

    public int[] sort(int[] nArray) {
        this.clear();
        this.add(nArray);
        this.sort();
        return this.getIntArray();
    }

    public int[] sort(int[] nArray, int n, int n2) {
        this.clear();
        this.add(nArray, n, n2);
        this.sort();
        return this.getIntArray();
    }

    public synchronized void BubbleSort() {
        if (this._sorted) {
            return;
        }
        boolean bl = true;
        short s = this._order == 1 ? (short)1 : -1;
        int n = this._data.length - 1;
        while (n > 0 && bl) {
            bl = false;
            int n2 = 0;
            while (n2 < n) {
                if (this._comparitor.compare(this._data[n2], this._data[n2 + 1]) == s) {
                    this.swap(n2, n2 + 1);
                    bl = true;
                }
                ++n2;
            }
            --n;
        }
        this._sorted = true;
    }

    private void qsort(int n, int n2, short s) {
        boolean bl = false;
        if (n2 <= n) {
            return;
        }
        int n3 = n - 1;
        int n4 = n2;
        Object object = this._data[n2];
        while (!bl) {
            ++n3;
            while (n3 <= n2 && this._comparitor.compare(this._data[n3], object) == s) {
                ++n3;
            }
            --n4;
            while (n4 >= n && this._comparitor.compare(object, this._data[n4]) == s) {
                --n4;
            }
            if (n3 >= n4) {
                bl = true;
                continue;
            }
            this.swap(n3, n4);
        }
        this.swap(n3, n2);
        this.qsort(n, n3 - 1, s);
        this.qsort(n3 + 1, n2, s);
    }

    public Object[] BubbleSort(Object[] objectArray) {
        this.clear();
        this.add(objectArray);
        this.BubbleSort();
        return this.getArray();
    }

    public Object[] BubbleSort(Object[] objectArray, int n, int n2) {
        this.clear();
        this.add(objectArray, n, n2);
        this.BubbleSort();
        return this.getArray();
    }

    public int[] BubbleSort(int[] nArray) {
        this.clear();
        this.add(nArray);
        this.BubbleSort();
        return this.getIntArray();
    }

    public List getStack() {
        if (!this._sorted) {
            this.sort();
        }
        if (this._data == null) {
            return null;
        }
        List list = new List();
        this.storeInList(list);
        return list;
    }

    public int[] getIntArray() {
        if (!this._sorted) {
            this.sort();
        }
        if (this._data == null) {
            return null;
        }
        int[] nArray = new int[this._data.length];
        int n = 0;
        while (n < this._data.length) {
            if (this._data[n] != null && this._data[n] instanceof Number) {
                nArray[n] = ((Number)this._data[n]).intValue();
            }
            ++n;
        }
        return nArray;
    }

    public void clear() {
        this._data = new Object[0];
        this._sorted = true;
    }

    private int makeItBigger(int n) {
        Object[] objectArray = new Object[this._data.length + n];
        int n2 = this._data.length;
        try {
            if (this._data.length > 0) {
                System.arraycopy(this._data, 0, objectArray, 0, this._data.length);
            }
            this._data = objectArray;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
        }
        catch (ArrayStoreException arrayStoreException) {}
        this._sorted = false;
        return n2;
    }

    public double[] getDoubleArray() {
        if (!this._sorted) {
            this.sort();
        }
        if (this._data == null) {
            return null;
        }
        double[] dArray = new double[this._data.length];
        int n = 0;
        while (n < this._data.length) {
            if (this._data[n] != null && this._data[n] instanceof Number) {
                dArray[n] = ((Number)this._data[n]).doubleValue();
            }
            ++n;
        }
        return dArray;
    }

    public int[] BubbleSort(int[] nArray, int n, int n2) {
        this.clear();
        this.add(nArray, n, n2);
        this.BubbleSort();
        return this.getIntArray();
    }

    public long[] BubbleSort(long[] lArray) {
        this.clear();
        this.add(lArray);
        this.BubbleSort();
        return this.getLongArray();
    }

    public long[] BubbleSort(long[] lArray, int n, int n2) {
        this.clear();
        this.add(lArray, n, n2);
        this.BubbleSort();
        return this.getLongArray();
    }

    public float[] BubbleSort(float[] fArray) {
        this.clear();
        this.add(fArray);
        this.BubbleSort();
        return this.getFloatArray();
    }

    public float[] BubbleSort(float[] fArray, int n, int n2) {
        this.clear();
        this.add(fArray, n, n2);
        this.BubbleSort();
        return this.getFloatArray();
    }

    public double[] BubbleSort(double[] dArray) {
        this.clear();
        this.add(dArray);
        this.BubbleSort();
        return this.getDoubleArray();
    }

    public double[] BubbleSort(double[] dArray, int n, int n2) {
        this.clear();
        this.add(dArray, n, n2);
        this.BubbleSort();
        return this.getDoubleArray();
    }

    public char[] BubbleSort(char[] cArray) {
        this.clear();
        this.add(cArray);
        this.BubbleSort();
        return this.getCharArray();
    }

    public char[] BubbleSort(char[] cArray, int n, int n2) {
        this.clear();
        this.add(cArray, n, n2);
        this.BubbleSort();
        return this.getCharArray();
    }

    public List BubbleSort(BasicList basicList) {
        this.clear();
        this.add(basicList);
        this.BubbleSort();
        return this.getList();
    }

    public Enumeration BubbleSort(Enumeration enumeration) {
        this.clear();
        this.add(enumeration);
        this.BubbleSort();
        return this.getEnumeration();
    }

    public long[] sort(long[] lArray) {
        this.clear();
        this.add(lArray);
        this.sort();
        return this.getLongArray();
    }

    public long[] sort(long[] lArray, int n, int n2) {
        this.clear();
        this.add(lArray, n, n2);
        this.sort();
        return this.getLongArray();
    }

    private class SortEnumerator
    implements Enumeration {
        Object[] _objects;
        int _index;

        public Object nextElement() {
            if (this._index >= this._objects.length) {
                throw new NoSuchElementException();
            }
            return this._objects[this._index++];
        }

        SortEnumerator(Object[] objectArray) {
            Sorter.this.getClass();
            this._objects = objectArray;
            this._index = 0;
        }

        public boolean hasMoreElements() {
            return this._index < this._objects.length;
        }
    }
}

