/*
 * Decompiled with CFR 0.152.
 */
package gishur.core.algorithms;

import gishur.core.algorithms.Algorithm;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.Properties;

public abstract class AlgorithmManager {
    private static Properties _algorithms;

    public static void registerAlgorithm(String string, Algorithm algorithm) {
        ((Hashtable)_algorithms).put(string, algorithm.getClass().getName());
    }

    public static void load(InputStream inputStream) {
        try {
            _algorithms = new Properties();
            _algorithms.load(inputStream);
            return;
        }
        catch (Exception exception) {
            System.out.println(exception);
            return;
        }
    }

    static {
        try {
            AlgorithmManager.load(Class.forName("gishur.core.algorithms.AlgorithmManager").getResourceAsStream("algorithms.txt"));
        }
        catch (Exception exception) {
            _algorithms = new Properties();
        }
    }

    public static Algorithm getAlgorithm(String string) {
        Algorithm algorithm = null;
        String string2 = _algorithms.getProperty(string);
        try {
            Class<?> clazz = Class.forName(string2);
            algorithm = (Algorithm)clazz.newInstance();
        }
        catch (Exception exception) {
            System.out.println(exception);
        }
        return algorithm;
    }

    public static void saveToFile(String string, String string2) {
        try {
            _algorithms.save(new FileOutputStream(string2), string);
            return;
        }
        catch (Exception exception) {
            System.out.println(exception);
            return;
        }
    }
}

