/*
 * Decompiled with CFR 0.152.
 */
package gishur.core.geom;

public class GeomException
extends RuntimeException {
    public static final int UNKNOWN = 1;
    public static final int NULL_ARGUMENT = 2;
    public static final int ILLEGAL_ARGUMENT = 3;
    public static final int ILLEGAL_ARGUMENT_TYPE = 4;
    public static final int MODIFY_IMMUTABLE_OBJECT = 5;
    public static final int ARGUMENT_OUT_OF_RANGE = 6;
    public static final int PRECISION_ERROR = 7;
    public static final int POINT_ON_CURVE_REQUIRED = 8;
    public int errorcode = 1;

    public GeomException(int n) {
        super(GeomException.getErrorString(n));
        this.errorcode = n;
    }

    protected GeomException(int n, String string) {
        super(string);
        this.errorcode = n;
    }

    protected static String getErrorString(int n) {
        String string = "Unknown GeomException.";
        switch (n) {
            case 4: {
                string = "Illegal argument type.";
                break;
            }
            case 2: {
                string = "Illegal null argument.";
                break;
            }
            case 3: {
                string = "Illegal argument.";
                break;
            }
            case 5: {
                string = "Tried to modify an immutable object.";
                break;
            }
            case 6: {
                string = "Argument out of range.";
                break;
            }
            case 7: {
                string = "Precision tolerance is broken.";
                break;
            }
            case 8: {
                string = "The point does not lie on the curve as required.";
            }
        }
        return string;
    }
}

