/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.mapcontext.raster.impl;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import java.util.Set;
import java.util.TreeSet;
import org.cresques.cts.ICoordTrans;
import org.gvsig.compat.print.PrintAttributes;
import org.gvsig.fmap.dal.DataStore;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.exception.InitializeException;
import org.gvsig.fmap.dal.exception.ReadException;
import org.gvsig.fmap.dal.raster.BandAttributeDescriptor;
import org.gvsig.fmap.dal.raster.BandDescriptor;
import org.gvsig.fmap.dal.raster.RasterQuery;
import org.gvsig.fmap.dal.raster.RasterSet;
import org.gvsig.fmap.dal.raster.RasterStore;
import org.gvsig.fmap.dal.raster.RasterStoreNotification;
import org.gvsig.fmap.dal.serverexplorer.filesystem.FilesystemStoreParameters;
import org.gvsig.fmap.geom.GeometryLocator;
import org.gvsig.fmap.geom.GeometryManager;
import org.gvsig.fmap.geom.exception.CreateEnvelopeException;
import org.gvsig.fmap.geom.primitive.Envelope;
import org.gvsig.fmap.geom.primitive.Point;
import org.gvsig.fmap.mapcontext.MapContextLocator;
import org.gvsig.fmap.mapcontext.MapContextManager;
import org.gvsig.fmap.mapcontext.ViewPort;
import org.gvsig.fmap.mapcontext.events.FMapEvent;
import org.gvsig.fmap.mapcontext.exceptions.LoadLayerException;
import org.gvsig.fmap.mapcontext.layers.FLayer;
import org.gvsig.fmap.mapcontext.layers.FLyrDefault;
import org.gvsig.fmap.mapcontext.layers.LayerInformationBuilder;
import org.gvsig.fmap.mapcontext.raster.api.RasterLayer;
import org.gvsig.fmap.mapcontext.raster.api.legend.RasterLegendEvent;
import org.gvsig.fmap.mapcontext.raster.api.legend.listeners.RasterLegendChangedListener;
import org.gvsig.fmap.mapcontext.rendering.legend.ILegend;
import org.gvsig.fmap.mapcontext.rendering.legend.events.LegendChangedEvent;
import org.gvsig.fmap.mapcontext.rendering.legend.events.LegendClearEvent;
import org.gvsig.fmap.mapcontext.rendering.legend.events.LegendContentsChangedListener;
import org.gvsig.fmap.mapcontext.rendering.legend.events.SymbolLegendEvent;
import org.gvsig.metadata.exceptions.MetadataException;
import org.gvsig.raster.lib.buffer.api.Buffer;
import org.gvsig.raster.lib.buffer.api.BufferDimensions;
import org.gvsig.raster.lib.buffer.api.BufferLocator;
import org.gvsig.raster.lib.buffer.api.statistics.Statistics;
import org.gvsig.raster.lib.legend.api.RasterLegend;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dispose.Disposable;
import org.gvsig.tools.dispose.DisposeUtils;
import org.gvsig.tools.dynobject.DynObjectSet;
import org.gvsig.tools.dynobject.DynStruct;
import org.gvsig.tools.exception.BaseException;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.locator.LocatorException;
import org.gvsig.tools.persistence.PersistenceManager;
import org.gvsig.tools.persistence.Persistent;
import org.gvsig.tools.persistence.PersistentState;
import org.gvsig.tools.persistence.exception.PersistenceException;
import org.gvsig.tools.task.Cancellable;
import org.gvsig.tools.task.SimpleTaskStatus;
import org.gvsig.tools.task.TaskStatusManager;
import org.gvsig.tools.util.Callable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultRasterLayer
extends FLyrDefault
implements RasterLayer,
RasterLegendChangedListener,
Observer {
    private static final Logger logger = LoggerFactory.getLogger(DefaultRasterLayer.class);
    private RasterStore store;
    private RasterLegend legend;
    private RasterQuery baseQuery;
    private Statistics statistics;

    public DefaultRasterLayer() throws LoadLayerException {
    }

    public DefaultRasterLayer(RasterStore store, RasterLegend legend) {
        ToolsLocator.getDisposableManager().bind((Disposable)store);
        this.store = store;
        this.setLegend(legend);
    }

    public void saveToState(PersistentState state) throws PersistenceException {
        try {
            super.saveToState(state);
            state.set("store", (Persistent)this.store);
            state.set("legend", (Persistent)this.legend);
            state.set("baseQuery", (Persistent)this.baseQuery);
        }
        catch (RuntimeException | PersistenceException ex) {
            logger.warn("Can't save to persistent state the layer '" + this.getName() + "'.");
            throw ex;
        }
    }

    public void loadFromState(PersistentState state) throws PersistenceException {
        try {
            super.loadFromState(state);
            this.store = (RasterStore)state.get("store");
            this.legend = (RasterLegend)state.get("legend");
            this.baseQuery = (RasterQuery)state.get("baseQuery");
        }
        catch (RuntimeException | PersistenceException ex) {
            logger.warn("Can't load from persietent state the layer '" + this.getName() + "'.");
            throw ex;
        }
    }

    private void setLegend(RasterLegend legend) {
        if (this.legend == legend) {
            return;
        }
        if (this.legend != null && this.legend.equals(legend)) {
            return;
        }
        RasterLegend oldLegend = this.legend;
        if (oldLegend != null) {
            oldLegend.removeLegendListener((LegendContentsChangedListener)this);
        }
        this.legend = legend;
        this.legend.addLegendListener((LegendContentsChangedListener)this);
        LegendChangedEvent e = LegendChangedEvent.createLegendChangedEvent((ILegend)oldLegend, (ILegend)this.legend);
        this.updateDrawVersion();
        this.callLegendChanged(e);
    }

    public RasterLegend getLegend() {
        if (this.legend == null) {
            MapContextManager mapContextManager = MapContextLocator.getMapContextManager();
            RasterLegend theLegend = (RasterLegend)mapContextManager.getLegend((DataStore)this.store);
            this.setLegend(theLegend);
        }
        return this.legend;
    }

    public DataStore getDataStore() {
        return this.store;
    }

    public void setDataStore(DataStore dataStore) throws LoadLayerException {
        if (this.store != null) {
            DisposeUtils.disposeQuietly((Disposable)this.store);
        }
        this.store = (RasterStore)dataStore;
        ToolsLocator.getDisposableManager().bind((Disposable)dataStore);
        MapContextManager mapContextManager = MapContextLocator.getMapContextManager();
        RasterLegend theLegend = (RasterLegend)mapContextManager.getLegend((DataStore)this.store);
        this.setLegend(theLegend);
    }

    public Envelope getFullEnvelope() throws ReadException {
        ICoordTrans ct;
        Envelope rAux;
        try {
            rAux = this.getRasterStore().getEnvelope();
        }
        catch (BaseException e) {
            throw new ReadException(this.getName(), (Throwable)e);
        }
        if (rAux == null || rAux.isEmpty() || rAux.getMaximum(0) - rAux.getMinimum(0) == 0.0 && rAux.getMaximum(1) - rAux.getMinimum(1) == 0.0) {
            try {
                GeometryManager geomManager = GeometryLocator.getGeometryManager();
                rAux = geomManager.createEnvelope(0.0, 0.0, 90.0, 90.0, 0);
            }
            catch (CreateEnvelopeException e) {
                logger.warn("Error creating the envelope", (Throwable)e);
            }
        }
        if ((ct = this.getCoordTrans()) != null) {
            rAux = rAux.convert(ct);
        }
        return rAux;
    }

    public void draw(BufferedImage image, Graphics2D g, ViewPort viewPort, Cancellable cancel, double scale) throws ReadException {
        SimpleTaskStatus taskStatus;
        block14: {
            if (!this.isWithinScale(scale)) {
                return;
            }
            if (cancel.isCanceled()) {
                return;
            }
            RasterQuery rasterQuery = this.createRasterQuery();
            Envelope reprojectedViewPortEnvelope = viewPort.getAdjustedEnvelope();
            ICoordTrans ct = this.getCoordTrans();
            if (ct != null) {
                try {
                    reprojectedViewPortEnvelope = (Envelope)reprojectedViewPortEnvelope.clone();
                    reprojectedViewPortEnvelope = reprojectedViewPortEnvelope.convert(ct.getInverted());
                }
                catch (CloneNotSupportedException e) {
                    this.setAvailable(false);
                    this.setError(e);
                    throw new ReadException(this.getName(), (Throwable)e);
                }
            }
            double pixelSize = reprojectedViewPortEnvelope.getLength(0) / (double)viewPort.getImageWidth();
            rasterQuery.setPixelSize(pixelSize);
            rasterQuery.setClip(reprojectedViewPortEnvelope);
            RasterSet rasterSet = null;
            taskStatus = null;
            try {
                long tini = System.currentTimeMillis();
                TaskStatusManager manager = ToolsLocator.getTaskStatusManager();
                taskStatus = manager.createDefaultSimpleTaskStatus("Draw " + this.getDataStore().getName());
                taskStatus.setAutoremove(true);
                taskStatus.add();
                rasterSet = this.getRasterStore().getRasterSet(rasterQuery);
                if (!rasterSet.isEmpty()) {
                    this.getLegend().draw((Graphics)g, (Buffer)rasterSet, viewPort, taskStatus);
                    logger.debug("Layer " + this.getName() + " drawn in " + (System.currentTimeMillis() - tini) + " milliseconds.");
                }
                if (rasterSet == null) break block14;
            }
            catch (DataException e) {
                try {
                    if (taskStatus != null) {
                        taskStatus.abort();
                        taskStatus = null;
                    }
                    this.setAvailable(false);
                    this.setError(e);
                    throw new ReadException(this.getName(), (Throwable)e);
                }
                catch (Throwable throwable) {
                    if (rasterSet != null) {
                        DisposeUtils.dispose(rasterSet);
                        rasterSet = null;
                    }
                    if (taskStatus != null) {
                        taskStatus.terminate();
                        taskStatus = null;
                    }
                    throw throwable;
                }
            }
            DisposeUtils.dispose((Disposable)rasterSet);
            rasterSet = null;
        }
        if (taskStatus != null) {
            taskStatus.terminate();
            taskStatus = null;
        }
    }

    public void print(Graphics2D g, ViewPort viewPort, Cancellable cancel, double scale, PrintAttributes properties) throws ReadException {
        throw new UnsupportedOperationException();
    }

    public Set<RasterStore> getMetadataChildren() throws MetadataException {
        TreeSet<RasterStore> ret = new TreeSet<RasterStore>();
        ret.add(this.store);
        return ret;
    }

    public Object getMetadataID() throws MetadataException {
        return "Layer(" + this.getName() + "):" + this.store.getMetadataID();
    }

    @Override
    public void update(Observable observable, Object notification) {
        if (observable.equals(this.store) && notification instanceof RasterStoreNotification) {
            RasterStoreNotification event = (RasterStoreNotification)notification;
            if (event.getType() == "after_Refresh_DataStore" || event.getType() == "after_SelectionChange_DataStore") {
                this.updateDrawVersion();
            } else if (event.getType() == "resourceChange_DataStore") {
                this.setAvailable(false);
            }
        }
    }

    public RasterStore getRasterStore() {
        return this.store;
    }

    public void setBaseQuery(RasterQuery baseQuery) {
        this.baseQuery = baseQuery;
    }

    public RasterQuery getBaseQuery() {
        return this.baseQuery;
    }

    public RasterQuery createRasterQuery() {
        if (this.baseQuery == null) {
            return this.getRasterStore().createRasterQuery();
        }
        try {
            return this.baseQuery.clone();
        }
        catch (CloneNotSupportedException ex) {
            throw new RuntimeException(ex);
        }
    }

    protected void doDispose() throws BaseException {
        logger.debug("Dispose DefaultRasterLayer '" + (this.getDataStore() == null ? "NULL" : this.getDataStore().getFullName() + "'"));
        DisposeUtils.dispose((Disposable)this.store);
        this.layerListeners.clear();
        this.store = null;
        this.legend = null;
        this.baseQuery = null;
    }

    public DynObjectSet getInfo(java.awt.Point p, double tolerance, Cancellable cancel) throws LoadLayerException, DataException {
        return this.getInfo(p, tolerance, cancel, true);
    }

    public DynObjectSet getInfo(java.awt.Point p, double tolerance, Cancellable cancel, boolean fast) throws LoadLayerException, DataException {
        Point2D.Double infop = new Point2D.Double(p.x, p.y);
        Point pReal = this.getMapContext().getViewPort().convertToMapPoint((Point2D)infop);
        return null;
    }

    public DynObjectSet getInfo(Point p, double tolerance) throws LoadLayerException, DataException {
        return null;
    }

    public String getTocImageIcon() {
        return MapContextLocator.getMapContextManager().getIconLayer(this.getDataStore());
    }

    public void setLegend(ILegend legend) {
        if (!(legend instanceof RasterLegend)) {
            throw new IllegalArgumentException("The legend isn't a RasterLegend.");
        }
        this.setLegend((RasterLegend)legend);
    }

    public String getInfoString() {
        File f;
        RasterStore rasterStore = this.getRasterStore();
        Envelope envelope = null;
        try {
            envelope = rasterStore.getEnvelope();
        }
        catch (DataException | CreateEnvelopeException | LocatorException throwable) {
            // empty catch block
        }
        int bands = rasterStore.getBands();
        int rows = -1;
        int columns = -1;
        String pixelSize = "-/-";
        try {
            BufferDimensions dimensions = rasterStore.getDimensions();
            rows = dimensions.getRows();
            columns = dimensions.getColumns();
            pixelSize = String.format("%.3f/%.3f", dimensions.getPixelSizeX(), dimensions.getPixelSizeY());
        }
        catch (InitializeException dimensions) {
            // empty catch block
        }
        I18nManager i18nManager = ToolsLocator.getI18nManager();
        LayerInformationBuilder builder = MapContextLocator.getMapContextManager().createLayerInformationBuilder();
        builder.title().labelkey("Data_source");
        builder.property().labelkey("Source_type").value(this.store.getProviderName(), new Object[0]);
        builder.property().labelkey("origen").value(this.store.getFullName(), new Object[0]);
        if (this.store.getParameters() instanceof FilesystemStoreParameters && (f = ((FilesystemStoreParameters)this.store.getParameters()).getFile()) != null) {
            builder.property().labelkey("size").value("%d bytes", new Object[]{f.length()});
        }
        builder.property().labelkey("_bands").value("%d", new Object[]{bands});
        builder.property().labelkey("_rows").value("%d", new Object[]{rows});
        builder.property().labelkey("_columns").value("%d", new Object[]{columns});
        builder.property().labelkey("_pixel_size").value("%s", new Object[]{pixelSize});
        builder.property().labelkey("transparency").value("%d", new Object[]{this.getTransparency()});
        builder.title().labelkey("_Coordenadas_geograficas");
        builder.envelope().value(envelope);
        builder.title().labelkey("_Projection");
        builder.property().value(this.getProjection());
        builder.text().asWKT(this.getProjection());
        for (int i = 0; i < bands; ++i) {
            builder.title().labelkey(i18nManager.getTranslation("_band") + " " + i);
            BandDescriptor bandDescriptor = rasterStore.getBandDescriptor(i);
            builder.property().labelkey("_name").value(bandDescriptor.getName(), new Object[0]);
            builder.property().labelkey("_description").value(bandDescriptor.getDescription(), new Object[0]);
            builder.property().labelkey("_dataType").value(BufferLocator.getBufferManager().getTypeName(bandDescriptor.getDataType()), new Object[0]);
            if (bandDescriptor.getNoData() != null) {
                builder.property().labelkey("_noData").value(bandDescriptor.getNoData().toString(), new Object[0]);
            } else {
                builder.property().labelkey("_noData").value(i18nManager.getTranslation("_null"), new Object[0]);
            }
            for (BandAttributeDescriptor bandAttributeDescriptor : bandDescriptor) {
                builder.property().labelkey("_name").value(bandAttributeDescriptor.getName(), new Object[0]);
                builder.property().labelkey("_description").value(bandAttributeDescriptor.getDescription(), new Object[0]);
                builder.property().labelkey("_units").value(bandAttributeDescriptor.getUnits(), new Object[0]);
                builder.title().labelkey("_values");
                List attributeValues = bandAttributeDescriptor.getAvailableValues();
                for (Object value : attributeValues) {
                    if (value != null) {
                        builder.property().labelkey("_units").value(bandAttributeDescriptor.getUnits(), new Object[0]);
                        continue;
                    }
                    builder.property().labelkey("_units").value(bandAttributeDescriptor.getUnits(), new Object[0]);
                }
            }
        }
        return builder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Statistics getStatistics(SimpleTaskStatus status) {
        if (this.statistics == null) {
            RasterSet rasterSet = null;
            try {
                rasterSet = this.getRasterStore().getRasterSet();
                this.statistics = rasterSet.getStatistics(status);
            }
            catch (DataException e) {
                logger.warn("Can't get layer's statistics", (Throwable)e);
            }
            finally {
                DisposeUtils.dispose((Disposable)rasterSet);
            }
        }
        return this.statistics;
    }

    public void recalculateStatistics() {
        this.statistics = null;
    }

    public FLayer cloneLayer() throws Exception {
        RasterLegend clonedLegend = (RasterLegend)this.legend.cloneLegend();
        DefaultRasterLayer cloned = new DefaultRasterLayer(this.store, clonedLegend);
        cloned.setName(this.getName());
        cloned.setProjection(this.getProjection());
        return cloned;
    }

    public boolean symbolChanged(SymbolLegendEvent e) {
        throw new UnsupportedOperationException("There aren't any symbols in a raster legend.");
    }

    public void legendCleared(LegendClearEvent event) {
        throw new UnsupportedOperationException("Can't clear a raster legend.");
    }

    public boolean colorInterpretationChanged(RasterLegendEvent e) {
        this.updateDrawVersion();
        LegendChangedEvent ev = LegendChangedEvent.createLegendChangedEvent((ILegend)this.legend, (FMapEvent)e);
        this.callLegendChanged(ev);
        return true;
    }

    public boolean operationListChanged(RasterLegendEvent e) {
        this.updateDrawVersion();
        LegendChangedEvent ev = LegendChangedEvent.createLegendChangedEvent((ILegend)this.legend, (FMapEvent)e);
        this.callLegendChanged(ev);
        return true;
    }

    public static class RegisterPersistence
    implements Callable {
        public Object call() {
            PersistenceManager manager = ToolsLocator.getPersistenceManager();
            DynStruct definition = manager.addDefinition(DefaultRasterLayer.class, "DefaultRasterLayer", "DefaultRasterLayer Persistence definition", null, null);
            definition.extend("Persistence", "FLyrDefault");
            definition.addDynFieldObject("legend").setClassOfValue(RasterLegend.class).setMandatory(true);
            definition.addDynFieldObject("store").setClassOfValue(RasterStore.class).setMandatory(true);
            definition.addDynFieldObject("baseQuery").setClassOfValue(RasterQuery.class).setMandatory(false);
            return Boolean.TRUE;
        }
    }
}

