/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.mapcontext.raster.impl;

import org.gvsig.compat.CompatLibrary;
import org.gvsig.fmap.dal.DALLibrary;
import org.gvsig.fmap.dal.raster.RasterStore;
import org.gvsig.fmap.mapcontext.MapContextLibrary;
import org.gvsig.fmap.mapcontext.MapContextLocator;
import org.gvsig.fmap.mapcontext.MapContextManager;
import org.gvsig.fmap.mapcontext.raster.impl.DefaultRasterLayer;
import org.gvsig.raster.lib.buffer.api.BufferLocator;
import org.gvsig.raster.lib.buffer.api.OperationManager;
import org.gvsig.raster.lib.buffer.api.operations.OperationFactory;
import org.gvsig.raster.lib.legend.api.RasterLegendLocator;
import org.gvsig.raster.lib.legend.api.RasterLegendManager;
import org.gvsig.raster.lib.legend.api.colortable.ColorTableIOFactory;
import org.gvsig.raster.lib.legend.impl.DefaultColorInterpretation;
import org.gvsig.raster.lib.legend.impl.DefaultColorTable;
import org.gvsig.raster.lib.legend.impl.DefaultColorTableClass;
import org.gvsig.raster.lib.legend.impl.DefaultRasterLegend;
import org.gvsig.raster.lib.legend.impl.DefaultRasterLegendManager;
import org.gvsig.raster.lib.legend.impl.DefaultTransparency;
import org.gvsig.raster.lib.legend.impl.DefaultTransparencyRange;
import org.gvsig.raster.lib.legend.impl.io.GimpGradientColorTableIOFactory;
import org.gvsig.raster.lib.legend.impl.io.GimpPaletteColorTableIOFactory;
import org.gvsig.raster.lib.legend.impl.io.gvSIGColorTableIOFactory;
import org.gvsig.raster.lib.legend.impl.operations.brightness.BrightnessOperationFactory;
import org.gvsig.raster.lib.legend.impl.operations.cmyktorgb.CMYKToRGBOperationFactory;
import org.gvsig.raster.lib.legend.impl.operations.colorbalancecmy.ColorBalanceCMYOperationFactory;
import org.gvsig.raster.lib.legend.impl.operations.colorbalancehsl.ColorBalanceHSLOperationFactory;
import org.gvsig.raster.lib.legend.impl.operations.colorbalancergb.ColorBalanceRGBOperationFactory;
import org.gvsig.raster.lib.legend.impl.operations.colortable.ColorTableOperationFactory;
import org.gvsig.raster.lib.legend.impl.operations.contrast.ContrastOperationFactory;
import org.gvsig.raster.lib.legend.impl.operations.equalization.EqualizationOperationFactory;
import org.gvsig.raster.lib.legend.impl.operations.grayscale.GrayScaleOperationFactory;
import org.gvsig.raster.lib.legend.impl.operations.hsltorgb.HSLToRGBOperationFactory;
import org.gvsig.raster.lib.legend.impl.operations.rgbtocmyk.RGBToCMYKOperationFactory;
import org.gvsig.raster.lib.legend.impl.operations.rgbtohsl.RGBToHSLOperationFactory;
import org.gvsig.tools.library.AbstractLibrary;
import org.gvsig.tools.library.LibraryException;
import org.gvsig.tools.util.Callable;
import org.gvsig.tools.util.impl.DefaultCaller;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MapContextRasterLibrary
extends AbstractLibrary {
    private static final Logger LOG = LoggerFactory.getLogger(MapContextRasterLibrary.class);

    public void doRegistration() {
        this.registerAsAPI(MapContextRasterLibrary.class);
        this.require(DALLibrary.class);
        this.require(CompatLibrary.class);
    }

    protected void doInitialize() throws LibraryException {
        RasterLegendLocator.registerRasterLegendManager(DefaultRasterLegendManager.class);
    }

    protected void doPostInitialize() throws LibraryException {
        MapContextManager manager = MapContextLocator.getMapContextManager();
        manager.registerLayer(RasterStore.class, DefaultRasterLayer.class);
        DefaultCaller caller = new DefaultCaller();
        caller.add((Callable)new DefaultRasterLayer.RegisterPersistence());
        if (!caller.call()) {
            throw new LibraryException(MapContextLibrary.class, caller.getExceptions());
        }
        DefaultColorTableClass.registerPersistence();
        DefaultColorTable.registerPersistence();
        DefaultColorInterpretation.registerPersistence();
        DefaultRasterLegend.registerPersistence();
        DefaultTransparency.registerPersistence();
        DefaultTransparencyRange.registerPersistence();
        RasterLegendManager rasterLegendManager = RasterLegendLocator.getRasterLegendManager();
        rasterLegendManager.registerColorTableIOFactory("gvSIGColorTableIO", (ColorTableIOFactory)new gvSIGColorTableIOFactory());
        rasterLegendManager.registerColorTableIOFactory("GimpGradientColorTableIO", (ColorTableIOFactory)new GimpGradientColorTableIOFactory());
        rasterLegendManager.registerColorTableIOFactory("GimpPaletteColorTableIO", (ColorTableIOFactory)new GimpPaletteColorTableIOFactory());
        OperationManager operationManager = BufferLocator.getOperationManager();
        operationManager.registerOperationFactory((OperationFactory)new BrightnessOperationFactory());
        operationManager.registerOperationFactory((OperationFactory)new ContrastOperationFactory());
        operationManager.registerOperationFactory((OperationFactory)new GrayScaleOperationFactory());
        operationManager.registerOperationFactory((OperationFactory)new ColorBalanceRGBOperationFactory());
        operationManager.registerOperationFactory((OperationFactory)new ColorBalanceCMYOperationFactory());
        operationManager.registerOperationFactory((OperationFactory)new ColorBalanceHSLOperationFactory());
        operationManager.registerOperationFactory((OperationFactory)new RGBToCMYKOperationFactory());
        operationManager.registerOperationFactory((OperationFactory)new RGBToHSLOperationFactory());
        operationManager.registerOperationFactory((OperationFactory)new HSLToRGBOperationFactory());
        operationManager.registerOperationFactory((OperationFactory)new CMYKToRGBOperationFactory());
        operationManager.registerOperationFactory((OperationFactory)new EqualizationOperationFactory());
        operationManager.registerOperationFactory((OperationFactory)new ColorTableOperationFactory());
        MapContextManager mapContextManager = MapContextLocator.getMapContextManager();
        mapContextManager.registerLegend("BaseRasterLegend", DefaultRasterLegend.class);
        mapContextManager.setDefaultRasterLegend("BaseRasterLegend");
    }
}

