/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.lib.legend.impl;

public class ColorUtils {
    public static Number[] fromYCBCRtoRGB(float y, float cb, float cr) {
        Number[] rgbValues = new Number[3];
        int r = (int)((double)y + 1.402 * (double)(cr - 128.0f));
        int g = (int)((double)y - 0.34414 * (double)(cb - 128.0f) - 0.71414 * (double)(cr - 128.0f));
        int b = (int)((double)y + 1.772 * (double)(cb - 128.0f));
        rgbValues[0] = Math.max(0, Math.min(255, r));
        rgbValues[1] = Math.max(0, Math.min(255, g));
        rgbValues[2] = Math.max(0, Math.min(255, b));
        return rgbValues;
    }

    public static Number[] fromCMYKtoRGB(float cyan, float magenta, float yellow, float black) {
        Number[] rgbValues = new Number[3];
        float colors = 255.0f - black;
        rgbValues[0] = Float.valueOf(colors * (255.0f - cyan) / 255.0f);
        rgbValues[1] = Float.valueOf(colors * (255.0f - magenta) / 255.0f);
        rgbValues[2] = Float.valueOf(colors * (255.0f - yellow) / 255.0f);
        return rgbValues;
    }

    public static Number[] fromHSLtoRGBA(float h, float s, float l) {
        return ColorUtils.fromHSLtoRGBA(h, s, l, 1.0f);
    }

    public static Number[] fromHSLtoRGBA(float h, float s, float l, float alpha) {
        if (s < 0.0f || s > 100.0f) {
            String message = "Color parameter outside of expected range - Saturation";
            throw new IllegalArgumentException(message);
        }
        if (l < 0.0f || l > 100.0f) {
            String message = "Color parameter outside of expected range - Luminance";
            throw new IllegalArgumentException(message);
        }
        if (alpha < 0.0f || alpha > 1.0f) {
            String message = "Color parameter outside of expected range - Alpha";
            throw new IllegalArgumentException(message);
        }
        h %= 360.0f;
        float q = 0.0f;
        q = (double)l < 0.5 ? l * (1.0f + s) : (l /= 100.0f) + (s /= 100.0f) - s * l;
        float p = 2.0f * l - q;
        float r = Math.max(0.0f, ColorUtils.HueToRGB(p, q, (h /= 360.0f) + 0.33333334f));
        float g = Math.max(0.0f, ColorUtils.HueToRGB(p, q, h));
        float b = Math.max(0.0f, ColorUtils.HueToRGB(p, q, h - 0.33333334f));
        r = Math.min(r, 1.0f);
        g = Math.min(g, 1.0f);
        b = Math.min(b, 1.0f);
        Number[] rgbValues = new Number[]{Float.valueOf(r), Float.valueOf(g), Float.valueOf(b), Float.valueOf(alpha)};
        return rgbValues;
    }

    private static float HueToRGB(float p, float q, float h) {
        if (h < 0.0f) {
            h += 1.0f;
        }
        if (h > 1.0f) {
            h -= 1.0f;
        }
        if (6.0f * h < 1.0f) {
            return p + (q - p) * 6.0f * h;
        }
        if (2.0f * h < 1.0f) {
            return q;
        }
        if (3.0f * h < 2.0f) {
            return p + (q - p) * 6.0f * (0.6666667f - h);
        }
        return p;
    }
}

