/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.lib.legend.impl;

import java.awt.Graphics;
import java.awt.Image;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import org.cresques.cts.ICoordTrans;
import org.gvsig.fmap.dal.raster.BandDescriptor;
import org.gvsig.fmap.geom.GeometryLocator;
import org.gvsig.fmap.geom.exception.CreateEnvelopeException;
import org.gvsig.fmap.geom.exception.CreateGeometryException;
import org.gvsig.fmap.geom.primitive.Envelope;
import org.gvsig.fmap.geom.primitive.Point;
import org.gvsig.fmap.mapcontext.ViewPort;
import org.gvsig.fmap.mapcontext.raster.api.legend.ChangeColorInterpretationEvent;
import org.gvsig.fmap.mapcontext.raster.api.legend.ChangeOperationListEvent;
import org.gvsig.fmap.mapcontext.raster.api.legend.ChangePaletteBandEvent;
import org.gvsig.fmap.mapcontext.raster.api.legend.ChangePaletteEvent;
import org.gvsig.fmap.mapcontext.raster.api.legend.RasterLegendEvent;
import org.gvsig.fmap.mapcontext.raster.api.legend.listeners.RasterLegendChangedListener;
import org.gvsig.fmap.mapcontext.rendering.legend.ILegend;
import org.gvsig.fmap.mapcontext.rendering.legend.events.LegendContentsChangedListener;
import org.gvsig.fmap.mapcontext.rendering.legend.events.SymbolLegendEvent;
import org.gvsig.fmap.mapcontext.rendering.symbols.ISymbol;
import org.gvsig.raster.lib.buffer.api.Band;
import org.gvsig.raster.lib.buffer.api.Buffer;
import org.gvsig.raster.lib.buffer.api.BufferLocator;
import org.gvsig.raster.lib.buffer.api.BufferManager;
import org.gvsig.raster.lib.buffer.api.NoData;
import org.gvsig.raster.lib.buffer.api.OperationManager;
import org.gvsig.raster.lib.buffer.api.exceptions.BufferException;
import org.gvsig.raster.lib.buffer.api.exceptions.BufferOperationException;
import org.gvsig.raster.lib.buffer.api.operations.Operation;
import org.gvsig.raster.lib.buffer.api.operations.OperationList;
import org.gvsig.raster.lib.buffer.api.operations.OperationListEntry;
import org.gvsig.raster.lib.buffer.api.operations.OperationListNotification;
import org.gvsig.raster.lib.buffer.spi.operations.AbstractOperation;
import org.gvsig.raster.lib.legend.api.RasterLegend;
import org.gvsig.raster.lib.legend.api.Transparency;
import org.gvsig.raster.lib.legend.api.colorinterpretation.ColorInterpretation;
import org.gvsig.raster.lib.legend.api.colorinterpretation.ColorInterpretationNotification;
import org.gvsig.raster.lib.legend.api.colortable.ColorTable;
import org.gvsig.raster.lib.legend.impl.ColorUtils;
import org.gvsig.raster.lib.legend.impl.operations.cmyktorgb.CMYKToRGBOperationFactory;
import org.gvsig.raster.lib.legend.impl.operations.hsltorgb.HSLToRGBOperationFactory;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dispose.Disposable;
import org.gvsig.tools.dispose.DisposeUtils;
import org.gvsig.tools.dynobject.DynClass;
import org.gvsig.tools.dynobject.DynObject;
import org.gvsig.tools.dynobject.DynStruct;
import org.gvsig.tools.dynobject.impl.DefaultDynObjectManager;
import org.gvsig.tools.locator.LocatorException;
import org.gvsig.tools.observer.Observable;
import org.gvsig.tools.observer.Observer;
import org.gvsig.tools.persistence.PersistenceManager;
import org.gvsig.tools.persistence.Persistent;
import org.gvsig.tools.persistence.PersistentState;
import org.gvsig.tools.persistence.exception.PersistenceException;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.task.SimpleTaskStatus;
import org.gvsig.tools.task.TaskStatusManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultRasterLegend
implements RasterLegend {
    public static final String LEGEND_NAME = "BaseRasterLegend";
    private static final Logger LOG = LoggerFactory.getLogger(DefaultRasterLegend.class);
    private ColorInterpretation colorInterpretation;
    private Transparency transparency;
    private OperationList filters;
    private boolean transparentNoData;
    private List<RasterLegendChangedListener> listeners = new ArrayList<RasterLegendChangedListener>();
    public static final String PERSISTENT_NAME = "RasterLegendPersistence";
    public static final String PERSISTENT_DESCRIPTION = "Persistence definition of raster legend";
    private static final String COLOR_INTERPRETATION_PERSISTENCE_FIELD = "colorInterpretation";
    private static final String FILTERS_PERSISTENCE_FIELD = "filters";

    public DefaultRasterLegend() {
    }

    public DefaultRasterLegend(ColorInterpretation colorInterpretation) {
        this(colorInterpretation, null, null);
    }

    public DefaultRasterLegend(ColorInterpretation colorInterpretation, Transparency transparency, OperationList filters) {
        this.transparency = transparency;
        this.filters = filters;
        this.setColorInterpretation(colorInterpretation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void draw(Graphics graphics, Buffer buffer, ViewPort viewPort, SimpleTaskStatus taskStatus) {
        Buffer bufferToDraw;
        Buffer interpolated2;
        Buffer converted;
        Buffer interpolated;
        Buffer clip;
        boolean isMyTask;
        block65: {
            block66: {
                isMyTask = false;
                if (taskStatus == null) {
                    TaskStatusManager taskStatusManager = ToolsLocator.getTaskStatusManager();
                    taskStatus = taskStatusManager.createDefaultSimpleTaskStatus("_drawing_buffer_XxellipsisxX");
                    taskStatus.setAutoremove(true);
                    taskStatus.add();
                    isMyTask = true;
                } else {
                    taskStatus.push();
                }
                taskStatus.setIndeterminate();
                if (this.colorInterpretation == null || !this.colorInterpretation.hasInterpretation() || this.colorInterpretation.isUndefined()) {
                    taskStatus.abort();
                    throw new IllegalStateException("To draw buffer, raster legend has to have a color interpretation");
                }
                clip = null;
                interpolated = null;
                converted = null;
                interpolated2 = null;
                bufferToDraw = buffer;
                try {
                    Image image;
                    Point point;
                    block67: {
                        if (buffer != null && buffer.getColumns() > 0 && buffer.getRows() > 0) {
                            if (!viewPort.getProjection().equals(buffer.getProjection())) {
                                ICoordTrans coordTrans = viewPort.getProjection().getCT(buffer.getProjection());
                                ICoordTrans invertedCoordTrans = buffer.getProjection().getCT(viewPort.getProjection());
                                Envelope convertedEnvelope = viewPort.getAdjustedEnvelope().convert(coordTrans);
                                double viewPortPixelSizeX = viewPort.getAdjustedEnvelope().getLength(0) / (double)viewPort.getImageWidth();
                                double viewPortPixelSizeY = viewPort.getAdjustedEnvelope().getLength(1) / (double)viewPort.getImageHeight();
                                if (!convertedEnvelope.intersects(buffer.getEnvelope())) {
                                    if (clip == null) break block65;
                                    break block66;
                                }
                                try {
                                    clip = buffer.clip(convertedEnvelope);
                                    DisposeUtils.dispose((Disposable)buffer);
                                    Envelope bufferEnvelopeInViewPortCoords = clip.getEnvelope().convert(invertedCoordTrans);
                                    double widthPixel = bufferEnvelopeInViewPortCoords.getLength(0) / viewPortPixelSizeX;
                                    double heightPixel = bufferEnvelopeInViewPortCoords.getLength(1) / viewPortPixelSizeY;
                                    interpolated = clip.createInterpolated((int)Math.floor(heightPixel), (int)Math.floor(widthPixel), 2, taskStatus);
                                    DisposeUtils.dispose((Disposable)clip);
                                    converted = interpolated.convert(invertedCoordTrans, taskStatus);
                                    DisposeUtils.dispose((Disposable)interpolated);
                                    widthPixel = this.getWidthPixel(converted.getEnvelope(), viewPortPixelSizeX);
                                    heightPixel = this.getHeightPixel(converted.getEnvelope(), viewPortPixelSizeY);
                                    interpolated2 = converted.createInterpolated((int)Math.floor(heightPixel), (int)Math.floor(widthPixel), 2, taskStatus);
                                    DisposeUtils.dispose((Disposable)converted);
                                    bufferToDraw = interpolated2;
                                }
                                catch (CreateEnvelopeException | BufferException | LocatorException e) {
                                    LOG.warn("Buffer can not be clipped, converted or interpolated", e);
                                    taskStatus.abort();
                                    if (clip != null) {
                                        DisposeUtils.dispose((Disposable)clip);
                                        clip = null;
                                    }
                                    if (interpolated != null) {
                                        DisposeUtils.dispose((Disposable)interpolated);
                                        interpolated = null;
                                    }
                                    if (converted != null) {
                                        DisposeUtils.dispose(converted);
                                        converted = null;
                                    }
                                    if (interpolated2 != null) {
                                        DisposeUtils.dispose(interpolated2);
                                        interpolated2 = null;
                                    }
                                    if (bufferToDraw != null && bufferToDraw != buffer) {
                                        DisposeUtils.dispose((Disposable)bufferToDraw);
                                        bufferToDraw = null;
                                    }
                                    if (isMyTask) return;
                                    taskStatus.pop();
                                    return;
                                }
                            }
                            if (!viewPort.getAdjustedEnvelope().intersects(buffer.getEnvelope())) return;
                            double widthPixel = 0.0;
                            double heightPixel = 0.0;
                            try {
                                if (!buffer.getEnvelope().equals(viewPort.getAdjustedEnvelope())) {
                                    clip = buffer.clip(viewPort.getAdjustedEnvelope());
                                    DisposeUtils.dispose((Disposable)buffer);
                                    bufferToDraw = clip;
                                }
                                widthPixel = this.getWidthPixel(bufferToDraw.getEnvelope(), viewPort.getAdjustedEnvelope().getLength(0) / (double)viewPort.getImageWidth());
                                heightPixel = this.getHeightPixel(bufferToDraw.getEnvelope(), viewPort.getAdjustedEnvelope().getLength(1) / (double)viewPort.getImageHeight());
                                interpolated = bufferToDraw.createInterpolated((int)Math.floor(heightPixel), (int)Math.floor(widthPixel), 2, taskStatus);
                                DisposeUtils.disposeQuietly((Disposable)clip);
                                bufferToDraw = interpolated;
                            }
                            catch (BufferException e) {
                                LOG.warn("Buffer can not be interpolated with [rows: {} , columns: {}, method: {}]", (Object[])new String[]{String.valueOf((int)Math.floor(heightPixel)), String.valueOf((int)Math.floor(widthPixel)), String.valueOf(2)});
                                taskStatus.abort();
                                if (clip != null) {
                                    DisposeUtils.dispose((Disposable)clip);
                                    clip = null;
                                }
                                if (interpolated != null) {
                                    DisposeUtils.dispose(interpolated);
                                    interpolated = null;
                                }
                                if (converted != null) {
                                    DisposeUtils.dispose(converted);
                                    converted = null;
                                }
                                if (interpolated2 != null) {
                                    DisposeUtils.dispose(interpolated2);
                                    interpolated2 = null;
                                }
                                if (bufferToDraw != null && bufferToDraw != buffer) {
                                    DisposeUtils.dispose((Disposable)bufferToDraw);
                                    bufferToDraw = null;
                                }
                                if (isMyTask) return;
                                taskStatus.pop();
                                return;
                            }
                        }
                        OperationManager operationManager = BufferLocator.getOperationManager();
                        if (bufferToDraw == null) return;
                        if (bufferToDraw.getColumns() <= 0) return;
                        if (bufferToDraw.getRows() <= 0) return;
                        double x = bufferToDraw.getEnvelope().getMinimum(0);
                        double y = bufferToDraw.getEnvelope().getMaximum(1);
                        AffineTransform affineTransform = this.calculateAffineTransform(viewPort.getAdjustedEnvelope(), viewPort.getImageWidth(), viewPort.getImageHeight());
                        try {
                            point = GeometryLocator.getGeometryManager().createPoint(x, y, 0);
                            point.transform(affineTransform.createInverse());
                        }
                        catch (NoninvertibleTransformException | CreateGeometryException e) {
                            LOG.warn("Can not calculate the point of buffer in viewport image", e);
                            taskStatus.abort();
                            if (clip != null) {
                                DisposeUtils.dispose((Disposable)clip);
                                clip = null;
                            }
                            if (interpolated != null) {
                                DisposeUtils.dispose(interpolated);
                                interpolated = null;
                            }
                            if (converted != null) {
                                DisposeUtils.dispose(converted);
                                converted = null;
                            }
                            if (interpolated2 != null) {
                                DisposeUtils.dispose(interpolated2);
                                interpolated2 = null;
                            }
                            if (bufferToDraw != null && bufferToDraw != buffer) {
                                DisposeUtils.dispose((Disposable)bufferToDraw);
                                bufferToDraw = null;
                            }
                            if (isMyTask) return;
                            taskStatus.pop();
                            return;
                        }
                        image = null;
                        Buffer filteredBuffer = bufferToDraw;
                        try {
                            DefaultDynObjectManager dynObjectManager = new DefaultDynObjectManager();
                            DynClass parametersClass = dynObjectManager.createDynClass("Parameters", "Parameters to find through ultimately.");
                            parametersClass.addDynFieldObject("output_color_interpretation");
                            DynObject defaultParameters = dynObjectManager.createDynObject((DynStruct)parametersClass);
                            defaultParameters.setDynValue("output_color_interpretation", (Object)this.colorInterpretation);
                            this.getFilters().setDefaultParameters(defaultParameters);
                            Object oColorInterpretation = null;
                            filteredBuffer = this.getFilters().execute(taskStatus, bufferToDraw);
                            oColorInterpretation = this.getFilters().getParameterValue("output_color_interpretation");
                            ColorInterpretation colorInterpretationAfterFilters = null;
                            if (oColorInterpretation != null) {
                                colorInterpretationAfterFilters = (ColorInterpretation)oColorInterpretation;
                            }
                            if (colorInterpretationAfterFilters == null) {
                                colorInterpretationAfterFilters = this.colorInterpretation;
                            }
                            if (colorInterpretationAfterFilters.isPalette()) {
                                DynObject colorTableOperationParameters = operationManager.createOperationParameters("ColorTable");
                                colorTableOperationParameters.setDynValue("color_interpretation", (Object)colorInterpretationAfterFilters);
                                Buffer rgbBuffer = operationManager.execute(taskStatus, "ColorTable", filteredBuffer, colorTableOperationParameters);
                                image = this.drawRGBBuffer(graphics, rgbBuffer, (ColorInterpretation)colorTableOperationParameters.getDynValue("output_color_interpretation"), this.transparency, this.getFilters());
                                break block67;
                            }
                            if (colorInterpretationAfterFilters.hasAnyGrayBand()) {
                                image = this.drawGrayBuffer(graphics, filteredBuffer, colorInterpretationAfterFilters, this.transparency, this.filters);
                                break block67;
                            }
                            if (colorInterpretationAfterFilters.hasAnyRGBBand()) {
                                image = this.drawRGBBuffer(graphics, filteredBuffer, colorInterpretationAfterFilters, this.transparency, this.filters);
                            }
                        }
                        catch (Exception e) {
                            LOG.warn("Error drawing legend", (Throwable)e);
                            taskStatus.abort();
                            if (clip != null) {
                                DisposeUtils.dispose((Disposable)clip);
                                clip = null;
                            }
                            if (interpolated != null) {
                                DisposeUtils.dispose((Disposable)interpolated);
                                interpolated = null;
                            }
                            if (converted != null) {
                                DisposeUtils.dispose(converted);
                                converted = null;
                            }
                            if (interpolated2 != null) {
                                DisposeUtils.dispose(interpolated2);
                                interpolated2 = null;
                            }
                            if (bufferToDraw != null && bufferToDraw != buffer) {
                                DisposeUtils.dispose((Disposable)bufferToDraw);
                                bufferToDraw = null;
                            }
                            if (isMyTask) return;
                            taskStatus.pop();
                            return;
                        }
                        finally {
                            if (filteredBuffer != null && filteredBuffer != bufferToDraw) {
                                DisposeUtils.dispose((Disposable)filteredBuffer);
                                filteredBuffer = null;
                            }
                        }
                    }
                    graphics.drawImage(image, (int)Math.floor(point.getX()), (int)Math.floor(point.getY()), null);
                    return;
                }
                catch (CreateEnvelopeException | LocatorException e1) {
                    LOG.warn("Can not calculate the envelope of buffer", e1);
                    taskStatus.abort();
                    return;
                }
            }
            DisposeUtils.dispose((Disposable)clip);
            clip = null;
        }
        if (interpolated != null) {
            DisposeUtils.dispose(interpolated);
            interpolated = null;
        }
        if (converted != null) {
            DisposeUtils.dispose(converted);
            converted = null;
        }
        if (interpolated2 != null) {
            DisposeUtils.dispose(interpolated2);
            interpolated2 = null;
        }
        if (bufferToDraw != null && bufferToDraw != buffer) {
            DisposeUtils.dispose((Disposable)bufferToDraw);
            bufferToDraw = null;
        }
        if (isMyTask) return;
        taskStatus.pop();
        return;
        finally {
            if (clip != null) {
                DisposeUtils.dispose(clip);
                clip = null;
            }
            if (interpolated != null) {
                DisposeUtils.dispose(interpolated);
                interpolated = null;
            }
            if (converted != null) {
                DisposeUtils.dispose(converted);
                converted = null;
            }
            if (interpolated2 != null) {
                DisposeUtils.dispose(interpolated2);
                interpolated2 = null;
            }
            if (bufferToDraw != null && bufferToDraw != buffer) {
                DisposeUtils.dispose((Disposable)bufferToDraw);
                bufferToDraw = null;
            }
            if (!isMyTask) {
                taskStatus.pop();
            }
        }
    }

    private AffineTransform calculateAffineTransform(Envelope envelope, double imageWidth, double imageHeight) {
        double pixelSizeX = envelope.getLength(0) / imageWidth;
        double rotationX = 0.0;
        double x = envelope.getMinimum(0);
        double rotationY = 0.0;
        double pixelSizeY = -envelope.getLength(1) / imageHeight;
        double y = envelope.getMaximum(1);
        return new AffineTransform(pixelSizeX, rotationY, rotationX, pixelSizeY, x, y);
    }

    private double getWidthPixel(Envelope envelope, double dist1pixel) {
        double widthEnvelope = envelope.getLength(0);
        return widthEnvelope / dist1pixel;
    }

    private double getHeightPixel(Envelope envelope, double dist1pixel) {
        double heightEnvelope = envelope.getLength(1);
        return heightEnvelope / dist1pixel;
    }

    private Image drawRGBBuffer(Graphics graphics, Buffer buffer, ColorInterpretation colorInterpretation, Transparency transparency, OperationList filters) throws BufferOperationException {
        Buffer byteBuffer;
        Buffer bufferToDraw = byteBuffer = this.convertToByteBuffer(buffer);
        BufferedImage image = null;
        if (colorInterpretation.isRGB() || colorInterpretation.isRGBA() || colorInterpretation.hasAnyRGBBand()) {
            image = ToolsSwingLocator.getToolsSwingManager().createBufferedImage(bufferToDraw.getColumns(), bufferToDraw.getRows(), 2);
        } else if (colorInterpretation.isBGR()) {
            image = ToolsSwingLocator.getToolsSwingManager().createBufferedImage(bufferToDraw.getColumns(), bufferToDraw.getRows(), 4);
        }
        if (image == null) {
            throw new IllegalStateException("Color interpretation is not RGB,RGBA or BGR and buffer was be drawn without color table");
        }
        int redBandIndex = colorInterpretation.getBand("Red");
        int greenBandIndex = colorInterpretation.getBand("Green");
        int blueBandIndex = colorInterpretation.getBand("Blue");
        Band redBand = null;
        if (redBandIndex >= 0) {
            redBand = bufferToDraw.getBand(redBandIndex);
        }
        Band greenBand = null;
        if (greenBandIndex >= 0) {
            greenBand = bufferToDraw.getBand(greenBandIndex);
        }
        Band blueBand = null;
        if (blueBandIndex >= 0) {
            blueBand = bufferToDraw.getBand(blueBandIndex);
        }
        Band alphaBand = null;
        if (colorInterpretation.hasAlphaBand()) {
            int alphaBandIndex = colorInterpretation.getBand("Alpha");
            alphaBand = bufferToDraw.getBand(alphaBandIndex);
        }
        for (int i = 0; i < bufferToDraw.getRows(); ++i) {
            for (int j = 0; j < bufferToDraw.getColumns(); ++j) {
                int alphaByteValue = 0;
                byte redByteValue = 0;
                if (redBand != null) {
                    Number redValue = (Number)redBand.get(i, j);
                    NoData noData = redBand.getNoData();
                    if (noData != null) {
                        if (redValue.equals(noData.getValue())) {
                            alphaByteValue = 0 | alphaByteValue;
                            redByteValue = 0;
                        } else {
                            alphaByteValue = 255;
                            redByteValue = redValue.byteValue();
                        }
                    } else {
                        redByteValue = redValue.byteValue();
                    }
                }
                byte greenByteValue = 0;
                if (greenBand != null) {
                    Number greenValue = (Number)greenBand.get(i, j);
                    NoData noData = greenBand.getNoData();
                    if (noData != null) {
                        if (greenValue.equals(noData.getValue())) {
                            alphaByteValue = 0 | alphaByteValue;
                            greenByteValue = 0;
                        } else {
                            alphaByteValue = 255;
                            greenByteValue = greenValue.byteValue();
                        }
                    } else {
                        greenByteValue = greenValue.byteValue();
                    }
                }
                int blueByteValue = 0;
                if (blueBand != null) {
                    Number blueValue = (Number)blueBand.get(i, j);
                    NoData noData = blueBand.getNoData();
                    if (noData != null) {
                        if (blueValue.equals(noData.getValue())) {
                            alphaByteValue = 0 | alphaByteValue;
                            blueByteValue = 0;
                        } else {
                            alphaByteValue = 255;
                            blueByteValue = blueValue.byteValue();
                        }
                    } else {
                        blueByteValue = blueValue.byteValue();
                    }
                }
                if (alphaByteValue != 0 && alphaBand != null) {
                    Number alphaValue = (Number)alphaBand.get(i, j);
                    int alphaBandIndex = colorInterpretation.getBand("Alpha");
                    NoData noData = alphaBand.getNoData();
                    alphaByteValue = noData != null ? (alphaValue.equals(noData.getValue()) ? 0 : (int)alphaValue.byteValue()) : (int)alphaValue.byteValue();
                }
                if (alphaByteValue != 0 && transparency != null) {
                    int newAlpha = transparency.getTransparencyRangeAlpha((int)redByteValue, (int)greenByteValue, blueByteValue);
                    alphaByteValue = this.getNewAlpha(alphaByteValue & 0xFF, newAlpha);
                    int transparencyValue = transparency.getAlpha();
                    alphaByteValue = this.getNewAlpha(alphaByteValue & 0xFF, transparencyValue);
                }
                int intRGB = 0;
                if (colorInterpretation.hasAnyRGBBand()) {
                    intRGB = ((byte)alphaByteValue & 0xFF) << 24 | ((byte)redByteValue & 0xFF) << 16 | ((byte)greenByteValue & 0xFF) << 8 | (byte)blueByteValue & 0xFF;
                } else if (colorInterpretation.isBGR()) {
                    intRGB = ((byte)blueByteValue & 0xFF) << 16 | ((byte)greenByteValue & 0xFF) << 8 | (byte)redByteValue & 0xFF;
                }
                image.setRGB(j, i, intRGB);
            }
        }
        return image;
    }

    private Image drawHSLBuffer(Graphics graphics, Buffer buffer, ColorInterpretation colorInterpretation, Transparency transparency, OperationList filters) throws BufferOperationException {
        Buffer byteBuffer = this.convertToByteBuffer(buffer);
        BufferedImage image = null;
        image = ToolsSwingLocator.getToolsSwingManager().createBufferedImage(buffer.getColumns(), buffer.getRows(), 2);
        int hueBandIndex = colorInterpretation.getBand("Hue");
        int saturationBandIndex = colorInterpretation.getBand("Saturation");
        int lightBandIndex = colorInterpretation.getBand("Lightness");
        Band hueBand = byteBuffer.getBand(hueBandIndex);
        Band saturationBand = byteBuffer.getBand(saturationBandIndex);
        Band lightBand = byteBuffer.getBand(lightBandIndex);
        for (int i = 0; i < buffer.getRows(); ++i) {
            for (int j = 0; j < buffer.getColumns(); ++j) {
                Number hueValue = (Number)hueBand.get(i, j);
                Number saturationValue = (Number)saturationBand.get(i, j);
                Number lightValue = (Number)lightBand.get(i, j);
                Number[] rgbaValues = ColorUtils.fromHSLtoRGBA(hueValue.floatValue(), saturationValue.floatValue(), lightValue.floatValue());
                Integer alphaValue = rgbaValues[3].intValue();
                if (transparency != null) {
                    alphaValue = alphaValue.byteValue() & 0xFF;
                    int newAlpha = transparency.getTransparencyRangeAlpha(rgbaValues[0].byteValue(), rgbaValues[1].byteValue(), rgbaValues[2].byteValue());
                    alphaValue = this.getNewAlpha(alphaValue, newAlpha);
                    int transparencyValue = transparency.getAlpha();
                    alphaValue = this.getNewAlpha(alphaValue, transparencyValue);
                }
                if (filters != null) {
                    // empty if block
                }
                int intRGB = 0;
                intRGB = (alphaValue.byteValue() & 0xFF) << 24 | (rgbaValues[0].byteValue() & 0xFF) << 16 | (rgbaValues[1].byteValue() & 0xFF) << 8 | (rgbaValues[2].byteValue() & 0xFF) << 0;
                image.setRGB(j, i, intRGB);
            }
        }
        return image;
    }

    private Image drawCMYKBuffer(Graphics graphics, Buffer buffer, ColorInterpretation colorInterpretation, Transparency transparency, OperationList filters) throws BufferOperationException {
        Buffer byteBuffer = this.convertToByteBuffer(buffer);
        BufferedImage image = null;
        image = ToolsSwingLocator.getToolsSwingManager().createBufferedImage(buffer.getColumns(), buffer.getRows(), 2);
        int cyanBandIndex = colorInterpretation.getBand("Cyan");
        int magentaBandIndex = colorInterpretation.getBand("Magenta");
        int yellowBandIndex = colorInterpretation.getBand("Yellow");
        int blackBandIndex = colorInterpretation.getBand("Black");
        Band cyanBand = byteBuffer.getBand(cyanBandIndex);
        Band magentaBand = byteBuffer.getBand(magentaBandIndex);
        Band yellowBand = byteBuffer.getBand(yellowBandIndex);
        Band blackBand = byteBuffer.getBand(blackBandIndex);
        for (int i = 0; i < buffer.getRows(); ++i) {
            for (int j = 0; j < buffer.getColumns(); ++j) {
                Number cyanValue = (Number)cyanBand.get(i, j);
                Number magentaValue = (Number)magentaBand.get(i, j);
                Number yellowValue = (Number)yellowBand.get(i, j);
                Number blackValue = (Number)blackBand.get(i, j);
                Number[] rgbValues = ColorUtils.fromCMYKtoRGB(cyanValue.floatValue(), magentaValue.floatValue(), yellowValue.floatValue(), blackValue.floatValue());
                Integer alphaValue = 255;
                if (transparency != null) {
                    alphaValue = alphaValue.byteValue() & 0xFF;
                    int newAlpha = transparency.getTransparencyRangeAlpha(rgbValues[0].byteValue(), rgbValues[1].byteValue(), rgbValues[2].byteValue());
                    alphaValue = this.getNewAlpha(alphaValue, newAlpha);
                    int transparencyValue = transparency.getAlpha();
                    alphaValue = this.getNewAlpha(alphaValue, transparencyValue);
                }
                if (filters != null) {
                    // empty if block
                }
                int intRGB = 0;
                intRGB = (alphaValue.byteValue() & 0xFF) << 24 | (rgbValues[0].byteValue() & 0xFF) << 16 | (rgbValues[1].byteValue() & 0xFF) << 8 | (rgbValues[2].byteValue() & 0xFF) << 0;
                image.setRGB(j, i, intRGB);
            }
        }
        return image;
    }

    private Image drawYCBCRBuffer(Graphics graphics, Buffer buffer, ColorInterpretation colorInterpretation, Transparency transparency, OperationList filters) throws BufferOperationException {
        Buffer byteBuffer = this.convertToByteBuffer(buffer);
        BufferedImage image = null;
        image = ToolsSwingLocator.getToolsSwingManager().createBufferedImage(buffer.getColumns(), buffer.getRows(), 2);
        int yIndex = colorInterpretation.getBand("YCbCr_Y");
        int cbBandIndex = colorInterpretation.getBand("YCbCr_Cb");
        int crBandIndex = colorInterpretation.getBand("YCbCr_Cr");
        Band yBand = byteBuffer.getBand(yIndex);
        Band cbBand = byteBuffer.getBand(cbBandIndex);
        Band crBand = byteBuffer.getBand(crBandIndex);
        for (int i = 0; i < buffer.getRows(); ++i) {
            for (int j = 0; j < buffer.getColumns(); ++j) {
                Number yValue = (Number)yBand.get(i, j);
                Number cbValue = (Number)cbBand.get(i, j);
                Number crValue = (Number)crBand.get(i, j);
                Number[] rgbValues = ColorUtils.fromYCBCRtoRGB(yValue.floatValue(), cbValue.floatValue(), crValue.floatValue());
                Integer alphaValue = 255;
                if (transparency != null) {
                    alphaValue = alphaValue.byteValue() & 0xFF;
                    int newAlpha = transparency.getTransparencyRangeAlpha(rgbValues[0].byteValue(), rgbValues[1].byteValue(), rgbValues[2].byteValue());
                    alphaValue = this.getNewAlpha(alphaValue, newAlpha);
                    int transparencyValue = transparency.getAlpha();
                    alphaValue = this.getNewAlpha(alphaValue, transparencyValue);
                }
                if (filters != null) {
                    // empty if block
                }
                int intRGB = 0;
                intRGB = (alphaValue.byteValue() & 0xFF) << 24 | (rgbValues[0].byteValue() & 0xFF) << 16 | (rgbValues[1].byteValue() & 0xFF) << 8 | (rgbValues[2].byteValue() & 0xFF) << 0;
                image.setRGB(j, i, intRGB);
            }
        }
        return image;
    }

    private Image drawGrayBuffer(Graphics graphics, Buffer buffer, ColorInterpretation colorInterpretation, Transparency transparency, OperationList filters) throws BufferOperationException {
        BufferedImage image = null;
        Buffer byteBuffer = this.convertToByteBuffer(buffer);
        image = ToolsSwingLocator.getToolsSwingManager().createBufferedImage(byteBuffer.getColumns(), byteBuffer.getRows(), 2);
        Band grayBand = byteBuffer.getBand(colorInterpretation.getBand("Gray"));
        for (int i = 0; i < byteBuffer.getRows(); ++i) {
            for (int j = 0; j < byteBuffer.getColumns(); ++j) {
                byte grayByteValue = 0;
                int alphaByteValue = -1;
                Number grayValue = (Number)grayBand.get(i, j);
                NoData noData = grayBand.getNoData();
                if (noData != null) {
                    if (grayValue.equals(noData.getValue())) {
                        alphaByteValue = 0;
                        grayByteValue = 0;
                    } else {
                        alphaByteValue = 255;
                        grayByteValue = grayValue.byteValue();
                    }
                } else {
                    grayByteValue = grayValue.byteValue();
                }
                if (alphaByteValue != 0 && transparency != null) {
                    int newAlpha = transparency.getTransparencyRangeAlpha((int)grayByteValue, (int)grayByteValue, (int)grayByteValue);
                    alphaByteValue = this.getNewAlpha(alphaByteValue, newAlpha);
                    int transparencyValue = transparency.getAlpha();
                    alphaByteValue = this.getNewAlpha(alphaByteValue, transparencyValue);
                }
                if (filters != null) {
                    // empty if block
                }
                int intARGB = ((byte)alphaByteValue & 0xFF) << 24 | ((byte)grayByteValue & 0xFF) << 16 | ((byte)grayByteValue & 0xFF) << 8 | (byte)grayByteValue & 0xFF;
                image.setRGB(j, i, intARGB);
            }
        }
        return image;
    }

    private Buffer convertToByteBuffer(Buffer buffer) throws BufferOperationException {
        int[] types = buffer.getBandTypes();
        boolean mustConvert = false;
        ArrayList<Integer> bandsToProcess = new ArrayList<Integer>();
        for (int i = 0; i < types.length; ++i) {
            if (types[i] == 0) continue;
            bandsToProcess.add(i);
            mustConvert = true;
        }
        if (mustConvert) {
            OperationManager operationManager = BufferLocator.getOperationManager();
            DynObject parameters = operationManager.createOperationParameters("LinearStretchEnhancement");
            parameters.setDynValue("bands_to_process", bandsToProcess);
            return operationManager.execute(null, "LinearStretchEnhancement", buffer, parameters);
        }
        return buffer;
    }

    private Image drawPaletteBuffer(Graphics graphics, Buffer buffer, ColorInterpretation colorInterpretation, Transparency transparency, OperationList filters) {
        BufferedImage image = ToolsSwingLocator.getToolsSwingManager().createBufferedImage(buffer.getColumns(), buffer.getRows(), 2);
        for (int i = 0; i < buffer.getRows(); ++i) {
            for (int j = 0; j < buffer.getColumns(); ++j) {
                Object value = buffer.getBand(colorInterpretation.getPaletteBand()).get(i, j);
                byte[] rgba = colorInterpretation.getPalette().getRGBA(value);
                if (transparency != null) {
                    int alpha = rgba[3] & 0xFF;
                    int newAlpha = transparency.getTransparencyRangeAlpha(rgba[0], rgba[1], rgba[2]);
                    alpha = this.getNewAlpha(alpha, newAlpha);
                    int transparencyValue = transparency.getAlpha();
                    rgba[3] = (byte)this.getNewAlpha(alpha, transparencyValue);
                }
                if (filters != null) {
                    // empty if block
                }
                int intARGB = (rgba[3] & 0xFF) << 24 | (rgba[0] & 0xFF) << 16 | (rgba[1] & 0xFF) << 8 | (rgba[2] & 0xFF) << 0;
                image.setRGB(j, i, intARGB);
            }
        }
        return image;
    }

    private int getNewAlpha(int alpha, int newAlpha) {
        return (int)Math.round((double)alpha * ((double)newAlpha / 255.0));
    }

    public ColorInterpretation getColorInterpretation() {
        return this.colorInterpretation;
    }

    public void setColorInterpretation(ColorInterpretation colorInterpretation) {
        if (this.colorInterpretation != null) {
            this.colorInterpretation.deleteObserver((Observer)this);
        }
        this.colorInterpretation = colorInterpretation;
        this.colorInterpretation.addObserver((Observer)this);
    }

    public OperationList getFilters() {
        if (this.filters == null) {
            BufferManager bufferManager = BufferLocator.getBufferManager();
            this.filters = ((OperationManager)bufferManager).createOperationList();
        }
        return this.filters;
    }

    public void setFilters(OperationList filterList) {
        OperationList oldFilters = this.filters;
        this.filters = filterList;
        this.fireColorinterpretationChangedEvent((RasterLegendEvent)new ChangeOperationListEvent((List)oldFilters, (List)this.filters));
    }

    public static void registerPersistence() {
        PersistenceManager manager = ToolsLocator.getPersistenceManager();
        DynStruct definition = manager.getDefinition(PERSISTENT_NAME);
        if (definition == null) {
            definition = manager.addDefinition(DefaultRasterLegend.class, PERSISTENT_NAME, PERSISTENT_DESCRIPTION, null, null);
            definition.addDynFieldObject(COLOR_INTERPRETATION_PERSISTENCE_FIELD).setMandatory(false).setClassOfValue(ColorInterpretation.class);
            definition.addDynFieldObject(FILTERS_PERSISTENCE_FIELD).setMandatory(false).setClassOfValue(OperationList.class);
        }
    }

    public void saveToState(PersistentState state) throws PersistenceException {
        state.set(COLOR_INTERPRETATION_PERSISTENCE_FIELD, (Persistent)this.getColorInterpretation());
        state.set(FILTERS_PERSISTENCE_FIELD, (Persistent)this.getFilters());
    }

    public void loadFromState(PersistentState state) throws PersistenceException {
        this.setColorInterpretation((ColorInterpretation)state.get(COLOR_INTERPRETATION_PERSISTENCE_FIELD));
        this.setFilters((OperationList)state.get(FILTERS_PERSISTENCE_FIELD));
    }

    public void setTransparency(Transparency transparency) {
        this.transparency = transparency;
    }

    public Transparency getTransparency() {
        return this.transparency;
    }

    public ISymbol getDefaultSymbol() {
        return null;
    }

    public Object clone() throws CloneNotSupportedException {
        DefaultRasterLegend cloned = (DefaultRasterLegend)super.clone();
        ColorInterpretation clonedColorInterpretation = (ColorInterpretation)this.getColorInterpretation().clone();
        cloned.setColorInterpretation(clonedColorInterpretation);
        cloned.setFilters((OperationList)this.getFilters().clone());
        return cloned;
    }

    public ILegend cloneLegend() {
        try {
            return (RasterLegend)this.clone();
        }
        catch (Exception e) {
            throw new RuntimeException("Can't clone the legend", e);
        }
    }

    public void fireDefaultSymbolChangedEvent(SymbolLegendEvent event) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            ((LegendContentsChangedListener)this.listeners.get(i)).symbolChanged(event);
        }
    }

    public LegendContentsChangedListener[] getListeners() {
        return this.listeners.toArray(new LegendContentsChangedListener[this.listeners.size()]);
    }

    public void setTransparentNoData(boolean noDataTransparent) {
        this.transparentNoData = noDataTransparent;
    }

    public boolean areTransparentNoData() {
        return this.transparentNoData;
    }

    public void update(Observable observable, Object notification) {
        if (notification instanceof ColorInterpretationNotification) {
            String type = ((ColorInterpretationNotification)notification).getType();
            if (type.equals("changed_color_interpretation_value_notification") || type.equals("added_color_interpretation_notification") || type.equals("copied_from_color_interpretation_notification")) {
                this.fireColorinterpretationChangedEvent((RasterLegendEvent)new ChangeColorInterpretationEvent((String[])((ColorInterpretationNotification)notification).getValue(0), (String[])((ColorInterpretationNotification)notification).getValue(1)));
            }
            if (type.equals("setted_palette_notification")) {
                this.fireColorinterpretationChangedEvent((RasterLegendEvent)new ChangePaletteEvent((ColorTable)((ColorInterpretationNotification)notification).getValue(0), (ColorTable)((ColorInterpretationNotification)notification).getValue(1)));
            }
            if (type.equals("changed_palette_notification")) {
                this.fireColorinterpretationChangedEvent((RasterLegendEvent)new ChangePaletteEvent((ColorTable)((ColorInterpretationNotification)notification).getValue(0), (ColorTable)((ColorInterpretationNotification)notification).getValue(0)));
            }
            if (type.equals("changed_palette_band_notification")) {
                this.fireColorinterpretationChangedEvent((RasterLegendEvent)new ChangePaletteBandEvent(((Integer)((ColorInterpretationNotification)notification).getValue(0)).intValue(), ((Integer)((ColorInterpretationNotification)notification).getValue(1)).intValue()));
            }
        }
        if (notification instanceof OperationListNotification) {
            this.fireOperationListChangedEvent((RasterLegendEvent)new ChangeOperationListEvent((List)((OperationListNotification)notification).getValue(0), (List)((OperationListNotification)notification).getValue(1)));
        }
    }

    public void fireColorinterpretationChangedEvent(RasterLegendEvent event) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            this.listeners.get(i).colorInterpretationChanged(event);
        }
    }

    public void fireOperationListChangedEvent(RasterLegendEvent event) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            this.listeners.get(i).operationListChanged(event);
        }
    }

    public void addLegendListener(LegendContentsChangedListener listener) {
        if (listener instanceof RasterLegendChangedListener) {
            this.addLegendListener((RasterLegendChangedListener)listener);
            return;
        }
        throw new UnsupportedOperationException("Raster layer can't be listened by a no RasterLegendChangedListener");
    }

    public void removeLegendListener(LegendContentsChangedListener listener) {
        if (listener instanceof RasterLegendChangedListener) {
            this.removeLegendListener((RasterLegendChangedListener)listener);
            return;
        }
        throw new UnsupportedOperationException("Raster layer can't be listened by a no RasterLegendChangedListener");
    }

    private void addLegendListener(RasterLegendChangedListener listener) {
        if (listener != null && !this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    private void removeLegendListener(RasterLegendChangedListener listener) {
        this.listeners.remove(listener);
    }

    public void addColorTableOperation(ColorInterpretation colorInterpretation, int index) {
        OperationList theFilters = this.getFilters();
        theFilters.removeIfExists("LinearStretchEnhancement");
        theFilters.removeIfExists("ColorTable");
        OperationManager operationManager = BufferLocator.getOperationManager();
        Operation colorTableOperation = operationManager.createOperation("ColorTable");
        DynObject colorTableOperationParameters = operationManager.createOperationParameters("ColorTable");
        colorTableOperationParameters.setDynValue("color_interpretation", (Object)colorInterpretation);
        colorTableOperationParameters.setDynValue(AbstractOperation.COPY_UNPROCESSED_BANDS_PARAM, (Object)true);
        OperationListEntry colorTableEntry = operationManager.createOperationListEntry(colorTableOperation, colorTableOperationParameters);
        theFilters.add(index, (Object)colorTableEntry);
    }

    public void addLinearStretchEnhancementOperationIfNeeded(ColorInterpretation colorInterpretation, List<BandDescriptor> bands, int index) {
        OperationList theFilters = this.getFilters();
        theFilters.removeIfExists("LinearStretchEnhancement");
        theFilters.removeIfExists("ColorTable");
        if (!colorInterpretation.isPalette() && (colorInterpretation.hasAnyColorInterpretationBand() || colorInterpretation.hasAlphaBand() || colorInterpretation.hasAnyGrayBand())) {
            ArrayList<Integer> bandsToProcess = new ArrayList<Integer>();
            for (int i = 0; i < bands.size(); ++i) {
                if (!colorInterpretation.isColorInterpretation(i) && !colorInterpretation.isAlphaInterpretation(i) && !colorInterpretation.isGrayInterpretation(i) || bands.get(i).getDataType() == 0) continue;
                bandsToProcess.add(i);
            }
            if (!bandsToProcess.isEmpty()) {
                OperationManager operationManager = BufferLocator.getOperationManager();
                Operation linearStretchEnhancementOperation = operationManager.createOperation("LinearStretchEnhancement");
                DynObject linearStretchEnhancementOperationParameters = operationManager.createOperationParameters("LinearStretchEnhancement");
                linearStretchEnhancementOperationParameters.setDynValue("bands_to_process", bandsToProcess);
                OperationListEntry colorTableEntry = operationManager.createOperationListEntry(linearStretchEnhancementOperation, linearStretchEnhancementOperationParameters);
                theFilters.add(index, (Object)colorTableEntry);
            }
        }
    }

    public void addHSLToRGBOperation(ColorInterpretation colorInterpretation) {
        OperationManager operationManager = BufferLocator.getOperationManager();
        DynObject hSLToRGBOperationParameters = operationManager.createOperationParameters(HSLToRGBOperationFactory.NAME);
        hSLToRGBOperationParameters.setDynValue("color_interpretation", (Object)colorInterpretation);
        Operation hSLToRGBOperation = operationManager.createOperation(HSLToRGBOperationFactory.NAME);
        OperationListEntry hSLToRGBOperationEntry = operationManager.createOperationListEntry(hSLToRGBOperation, hSLToRGBOperationParameters);
        this.getFilters().add((Object)hSLToRGBOperationEntry);
    }

    public void addCMYKToRGBOperation(ColorInterpretation colorInterpretation) {
        OperationManager operationManager = BufferLocator.getOperationManager();
        DynObject cmykToRGBOperationParameters = operationManager.createOperationParameters(CMYKToRGBOperationFactory.NAME);
        cmykToRGBOperationParameters.setDynValue("color_interpretation", (Object)colorInterpretation);
        Operation cmykToRGBOperation = operationManager.createOperation(HSLToRGBOperationFactory.NAME);
        OperationListEntry cmykToRGBOperationEntry = operationManager.createOperationListEntry(cmykToRGBOperation, cmykToRGBOperationParameters);
        this.getFilters().add((Object)cmykToRGBOperationEntry);
    }

    public void addYCBCRToRGBOperation(ColorInterpretation colorInterpretation) {
    }
}

