/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.lib.legend.impl;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.WritableRaster;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.gvsig.raster.lib.buffer.api.operations.OperationList;
import org.gvsig.raster.lib.legend.api.RasterLegend;
import org.gvsig.raster.lib.legend.api.Transparency;
import org.gvsig.raster.lib.legend.api.TransparencyRange;
import org.gvsig.raster.lib.legend.api.colorinterpretation.ColorInterpretation;
import org.gvsig.raster.lib.legend.api.colortable.ColorTable;
import org.gvsig.raster.lib.legend.api.colortable.ColorTableIO;
import org.gvsig.raster.lib.legend.api.colortable.ColorTableIOFactory;
import org.gvsig.raster.lib.legend.api.colortable.MakeColorTable;
import org.gvsig.raster.lib.legend.api.colortable.colortableclass.ColorTableClass;
import org.gvsig.raster.lib.legend.impl.ColorManager;
import org.gvsig.raster.lib.legend.impl.DefaultColorInterpretation;
import org.gvsig.raster.lib.legend.impl.DefaultColorManager;
import org.gvsig.raster.lib.legend.impl.DefaultColorTable;
import org.gvsig.raster.lib.legend.impl.DefaultColorTableClass;
import org.gvsig.raster.lib.legend.impl.DefaultRasterLegend;
import org.gvsig.raster.lib.legend.impl.DefaultTransparency;
import org.gvsig.raster.lib.legend.impl.DefaultTransparencyRange;
import org.gvsig.raster.lib.legend.impl.RasterLegendManagerServices;
import org.gvsig.raster.lib.legend.impl.colortable.DefaultMakeColorTable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultRasterLegendManager
implements RasterLegendManagerServices {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultRasterLegendManager.class);
    private Map<String, ColorTableIOFactory> colorTableIOFactories = new HashMap<String, ColorTableIOFactory>();
    private ColorManager colorManager;

    public RasterLegend createLegend() {
        return new DefaultRasterLegend();
    }

    public RasterLegend createLegend(ColorInterpretation colorInterpretation) {
        return new DefaultRasterLegend(colorInterpretation);
    }

    public RasterLegend createLegend(ColorInterpretation colorInterpretation, Transparency transparency, OperationList filters) {
        return new DefaultRasterLegend(colorInterpretation, transparency, filters);
    }

    public List<Pair<File, ColorTable>> getColorTables(File folder) {
        if (folder.isFile()) {
            throw new IllegalArgumentException("File object has to be a directory");
        }
        if (!folder.canRead()) {
            throw new IllegalArgumentException("It is necessary read permissions to get files and load color tables");
        }
        ArrayList<Pair<File, ColorTable>> colorTables = new ArrayList<Pair<File, ColorTable>>();
        block2: for (File file : this.listFilesForFolder(folder)) {
            Collection<ColorTableIOFactory> factories = this.colorTableIOFactories.values();
            for (ColorTableIOFactory colorTableIOFactory : factories) {
                if (!colorTableIOFactory.accept(file)) continue;
                ColorTableIO colorTableIO = colorTableIOFactory.create();
                try {
                    ColorTable colorTable = colorTableIO.read(file);
                    colorTables.add((Pair<File, ColorTable>)new ImmutablePair((Object)file, (Object)colorTable));
                    continue block2;
                }
                catch (Exception e) {
                    LOG.warn(String.format("%1s factory accepts file but it can not get ColorTable from file", colorTableIOFactory.getName()), (Throwable)e);
                }
            }
        }
        return colorTables;
    }

    private List<File> listFilesForFolder(File folder) {
        ArrayList<File> files = new ArrayList<File>();
        for (File fileEntry : folder.listFiles()) {
            if (fileEntry.isDirectory()) {
                this.listFilesForFolder(fileEntry);
                continue;
            }
            files.add(fileEntry);
        }
        return files;
    }

    public ColorTable createColorTable() {
        return new DefaultColorTable();
    }

    public ColorTable createColorTable(String name, List<ColorTableClass> colorTableClasses, boolean interpolated) {
        return new DefaultColorTable(name, colorTableClasses, interpolated);
    }

    public List<ColorTableClass> createListColorTableClasses(double minimum, double maximum, int intervals, Color fromColor, Color toColor) {
        double intervalSize = (maximum - minimum) / (double)intervals;
        return this.createListColorTableClasses(minimum, maximum, intervalSize, fromColor, toColor);
    }

    public List<ColorTableClass> createListColorTableClasses(double minimum, double maximum, double intervalSize, Color fromColor, Color toColor) {
        ArrayList<ColorTableClass> colorTableClasses = new ArrayList<ColorTableClass>();
        int counter = 0;
        double value = minimum;
        Color color = fromColor;
        while (value < maximum) {
            double proportion = (value - minimum) / (maximum - minimum);
            color = this.getInterpolatedColor(fromColor, toColor, proportion);
            ColorTableClass colorTableClass = this.createColorTableClass(Integer.toString(counter), value, 50.0, color);
            colorTableClasses.add(colorTableClass);
            value += intervalSize;
            ++counter;
        }
        value = maximum;
        ColorTableClass colorTableClass = this.createColorTableClass(Integer.toString(counter), value, 50.0, toColor);
        colorTableClasses.add(colorTableClass);
        return colorTableClasses;
    }

    private Color getInterpolatedColor(Color fromColor, Color toColor, double proportion) {
        int red = fromColor.getRed();
        int green = fromColor.getGreen();
        int blue = fromColor.getBlue();
        int alpha = fromColor.getAlpha();
        int rangeRed = toColor.getRed() - fromColor.getRed();
        red = (int)Math.round((double)fromColor.getRed() + (double)rangeRed * proportion);
        int rangeGreen = toColor.getGreen() - fromColor.getGreen();
        green = (int)Math.round((double)fromColor.getGreen() + (double)rangeGreen * proportion);
        int rangeBlue = toColor.getBlue() - fromColor.getBlue();
        blue = (int)Math.round((double)fromColor.getBlue() + (double)rangeBlue * proportion);
        int rangeAlpha = toColor.getAlpha() - fromColor.getAlpha();
        alpha = (int)Math.round((double)fromColor.getAlpha() + (double)rangeAlpha * proportion);
        return new Color(red, green, blue, alpha);
    }

    public ColorTableIO getColorTableIO() {
        ColorTableIOFactory defaultFactory = this.colorTableIOFactories.get("gvSIGColorTableIO");
        if (defaultFactory == null && this.colorTableIOFactories.isEmpty()) {
            LOG.warn("Any default Color Table IO factory registered");
            return null;
        }
        return defaultFactory.create();
    }

    public List<ColorTableIOFactory> getColorTableIOFactories() {
        return new ArrayList<ColorTableIOFactory>(this.colorTableIOFactories.values());
    }

    public ColorTableIOFactory getColorTableIOFactory(String name) {
        return this.colorTableIOFactories.get(name);
    }

    public void registerColorTableIOFactory(String name, ColorTableIOFactory colorTableIOFactory) {
        this.colorTableIOFactories.put(name, colorTableIOFactory);
    }

    public ColorTableClass createColorTableClass() {
        return new DefaultColorTableClass();
    }

    public ColorTableClass createColorTableClass(String className, double value, double interpolated, Color color) {
        return new DefaultColorTableClass(className, value, color, interpolated);
    }

    public ColorInterpretation createColorInterpretation(String[] coloInterpretations) {
        return new DefaultColorInterpretation(coloInterpretations);
    }

    public ColorInterpretation createColorInterpretation(List<String> coloInterpretations) {
        String[] x = coloInterpretations.toArray(new String[coloInterpretations.size()]);
        return new DefaultColorInterpretation(x);
    }

    public ColorInterpretation createColorInterpretation(String definedColorInterpretation) {
        return new DefaultColorInterpretation(definedColorInterpretation);
    }

    public ColorInterpretation createColorInterpretation(BufferedImage image, String prefix) {
        ColorInterpretation colorInterpretation = null;
        ColorModel colorModel = image.getColorModel();
        if (colorModel instanceof ComponentColorModel) {
            WritableRaster raster = image.getRaster();
            if (raster.getNumBands() == 3) {
                colorInterpretation = this.createColorInterpretation("RGB");
            } else if (raster.getNumBands() == 4) {
                colorInterpretation = this.createColorInterpretation("ARGB");
            }
        } else if (colorModel instanceof IndexColorModel) {
            colorInterpretation = this.createColorInterpretation("PALETTE");
            IndexColorModel indexColorModel = (IndexColorModel)colorModel;
            int[] rgbs = new int[indexColorModel.getMapSize()];
            boolean hasalpha = indexColorModel.hasAlpha();
            indexColorModel.getRGBs(rgbs);
            ArrayList<ColorTableClass> colorTableClasses = new ArrayList<ColorTableClass>();
            for (int i = 0; i < rgbs.length; ++i) {
                String className = i + "";
                double value = (byte)i;
                double interpolation = 50.0;
                Color color = new Color(rgbs[i], hasalpha);
                ColorTableClass colorTableClass = this.createColorTableClass(className, value, interpolation, color);
                colorTableClasses.add(colorTableClass);
            }
            String colorTableName = prefix + "_color_table";
            ColorTable colorTable = this.createColorTable(colorTableName, colorTableClasses, true);
            colorInterpretation.setPalette(colorTable);
            colorInterpretation.setPaletteBand(0);
        }
        return colorInterpretation;
    }

    public Transparency createTransparency() {
        return new DefaultTransparency();
    }

    public Transparency createTransparency(int transparency, List<TransparencyRange> transparencyRanges) {
        return new DefaultTransparency(transparency, transparencyRanges);
    }

    public TransparencyRange createTransparencyRange() {
        return new DefaultTransparencyRange();
    }

    public TransparencyRange createTransparencyRange(int[] redRange, int[] greenRange, int[] blueRange, int alpha, boolean isAnd) {
        return new DefaultTransparencyRange(redRange, greenRange, blueRange, alpha, isAnd);
    }

    public MakeColorTable createMakeColorTable() {
        return new DefaultMakeColorTable();
    }

    @Override
    public ColorManager getColorManager() {
        if (this.colorManager == null) {
            this.colorManager = new DefaultColorManager();
        }
        return this.colorManager;
    }
}

