/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.lib.legend.impl.io;

import java.awt.Color;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import org.gvsig.raster.lib.legend.api.RasterLegendLocator;
import org.gvsig.raster.lib.legend.api.colortable.ColorTable;
import org.gvsig.raster.lib.legend.api.colortable.ColorTableIO;
import org.gvsig.raster.lib.legend.api.colortable.colortableclass.ColorTableClass;
import org.gvsig.raster.lib.legend.api.exceptions.ColorTableIOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GimpGradientColorTableIO
implements ColorTableIO {
    private static final Logger LOG = LoggerFactory.getLogger(GimpGradientColorTableIO.class);
    public static final String NAME = "GimpGradientColorTableIO";
    public static final String DESCRIPTION = "ColorTableIO to read and write Gimp gradients";

    public String getName() {
        return NAME;
    }

    public String getDescription() {
        return DESCRIPTION;
    }

    public ColorTable read(File file) throws ColorTableIOException {
        ArrayList<ColorTableClass> colorTableClasses = new ArrayList<ColorTableClass>();
        ColorTable colorTable = RasterLegendLocator.getRasterLegendManager().createColorTable();
        try {
            String currentLine;
            BufferedReader reader = new BufferedReader(new FileReader(file));
            int cont = 0;
            while ((currentLine = reader.readLine()) != null) {
                if (cont == 1) {
                    colorTable.setName(currentLine.substring(6));
                } else if (cont > 1) {
                    String[] strings = currentLine.split("\\s+");
                    if (strings.length < 13) continue;
                    colorTableClasses.add(this.parseColorItem(strings, 0));
                    colorTableClasses.add(this.parseColorItem(strings, 1));
                }
                ++cont;
            }
            reader.close();
        }
        catch (IOException ex) {
            LOG.error("Error reading file to create color table", (Throwable)ex);
            throw new ColorTableIOException((Throwable)ex);
        }
        colorTable.setClasses(colorTableClasses, true);
        return colorTable;
    }

    public void read(ColorTable colorTable, File file) throws ColorTableIOException {
        ColorTable tmpColorTable = this.read(file);
        colorTable.copyFrom(tmpColorTable);
    }

    public void write(ColorTable colorTable, File file) throws ColorTableIOException {
        List colorTableClass = colorTable.getClasses();
        try {
            BufferedWriter writer = new BufferedWriter(new FileWriter(file));
            writer.write("GIMP Gradient\n");
            writer.write("Name: " + colorTable.getName() + "\n");
            writer.write(colorTableClass.size() - 1 + "\n");
            for (int i = 1; i < colorTableClass.size(); ++i) {
                double min = ((ColorTableClass)colorTableClass.get(0)).getValue();
                double max = ((ColorTableClass)colorTableClass.get(colorTableClass.size() - 1)).getValue();
                String line = "";
                ColorTableClass item1 = (ColorTableClass)colorTableClass.get(i - 1);
                ColorTableClass item2 = (ColorTableClass)colorTableClass.get(i);
                double pos1 = (item1.getValue() - min) / (max - min);
                double pos2 = (item2.getValue() - min) / (max - min);
                NumberFormat format = NumberFormat.getNumberInstance();
                format.setMaximumFractionDigits(6);
                format.setMinimumFractionDigits(6);
                line = line + format.format(pos1).replaceAll(",", ".") + " ";
                double interp = pos1 + (pos2 - pos1) * item1.getInterpolated() / 100.0;
                line = line + format.format(interp).replaceAll(",", ".") + " ";
                line = line + format.format(pos2).replaceAll(",", ".") + " ";
                Color color = item1.getColor();
                line = line + format.format((double)color.getRed() / 255.0).replaceAll(",", ".") + " ";
                line = line + format.format((double)color.getGreen() / 255.0).replaceAll(",", ".") + " ";
                line = line + format.format((double)color.getBlue() / 255.0).replaceAll(",", ".") + " ";
                line = line + format.format((double)color.getAlpha() / 255.0).replaceAll(",", ".") + " ";
                color = item2.getColor();
                line = line + format.format((double)color.getRed() / 255.0).replaceAll(",", ".") + " ";
                line = line + format.format((double)color.getGreen() / 255.0).replaceAll(",", ".") + " ";
                line = line + format.format((double)color.getBlue() / 255.0).replaceAll(",", ".") + " ";
                line = line + format.format((double)color.getAlpha() / 255.0).replaceAll(",", ".") + " ";
                line = line + "0 0\n";
                writer.write(line);
            }
            writer.close();
        }
        catch (IOException ex) {
            LOG.error("Error writting file to create Gimp gradient", (Throwable)ex);
            throw new ColorTableIOException((Throwable)ex);
        }
    }

    private ColorTableClass parseColorItem(String[] strings, int pos) {
        ColorTableClass item = RasterLegendLocator.getRasterLegendManager().createColorTableClass();
        double pos1 = Double.valueOf(strings[0]);
        double pos2 = Double.valueOf(strings[1]);
        double pos3 = Double.valueOf(strings[2]);
        if (pos == 0) {
            item.setValue(pos1 * 255.0);
        } else {
            item.setValue(pos3 * 255.0);
        }
        if (pos == 0) {
            item.setInterpolated(100.0 * (pos2 - pos1) / (pos3 - pos1));
        }
        if (pos == 0) {
            item.setColor(new Color((int)(Double.valueOf(strings[3]) * 255.0), (int)(Double.valueOf(strings[4]) * 255.0), (int)(Double.valueOf(strings[5]) * 255.0), (int)(Double.valueOf(strings[6]) * 255.0)));
        } else {
            item.setColor(new Color((int)(Double.valueOf(strings[7]) * 255.0), (int)(Double.valueOf(strings[8]) * 255.0), (int)(Double.valueOf(strings[9]) * 255.0), (int)(Double.valueOf(strings[10]) * 255.0)));
        }
        return item;
    }
}

