/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.lib.legend.impl.io;

import java.awt.Color;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.gvsig.raster.lib.legend.api.RasterLegendLocator;
import org.gvsig.raster.lib.legend.api.colortable.ColorTable;
import org.gvsig.raster.lib.legend.api.colortable.ColorTableIO;
import org.gvsig.raster.lib.legend.api.colortable.colortableclass.ColorTableClass;
import org.gvsig.raster.lib.legend.api.exceptions.ColorTableIOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GimpPaletteColorTableIO
implements ColorTableIO {
    private static final Logger LOG = LoggerFactory.getLogger(GimpPaletteColorTableIO.class);
    public static final String NAME = "GimpPaletteColorTableIO";
    public static final String DESCRIPTION = "ColorTableIO to read and write Gimp palettes";

    public String getName() {
        return NAME;
    }

    public String getDescription() {
        return DESCRIPTION;
    }

    public ColorTable read(File file) throws ColorTableIOException {
        if (file.isDirectory()) {
            throw new IllegalArgumentException("File can not be a directory.");
        }
        if (!file.exists() || !file.canRead()) {
            throw new IllegalArgumentException("File does not exist or can be readed");
        }
        ArrayList<ColorTableClass> colorItems = new ArrayList<ColorTableClass>();
        ColorTable colorTable = RasterLegendLocator.getRasterLegendManager().createColorTable();
        try {
            String currentLine;
            BufferedReader reader = new BufferedReader(new FileReader(file));
            int cont = 0;
            while ((currentLine = reader.readLine()) != null) {
                if (currentLine.charAt(0) == '#') continue;
                if (cont == 1) {
                    colorTable.setName(currentLine.substring(6));
                } else if (cont > 1) {
                    String[] strings = (" " + currentLine).split("\\s+");
                    ColorTableClass colorTableClass = null;
                    if (strings.length < 4) continue;
                    colorTableClass = this.parseColorItem(strings);
                    strings = (" " + currentLine).split("\\s+\\d+\\s+\\d+\\s+\\d+\\s+");
                    if (!strings[1].equals("Untitled")) {
                        colorTableClass.setName(strings[1]);
                    } else {
                        colorTableClass.setName("");
                    }
                    colorTableClass.setValue((double)(cont - 2));
                    colorItems.add(colorTableClass);
                }
                ++cont;
            }
            reader.close();
        }
        catch (IOException ex) {
            LOG.error("Can not read file to get gimp palette", (Throwable)ex);
            throw new ColorTableIOException((Throwable)ex);
        }
        colorTable.setClasses(colorItems, false);
        return colorTable;
    }

    private ColorTableClass parseColorItem(String[] strings) {
        ColorTableClass item = RasterLegendLocator.getRasterLegendManager().createColorTableClass();
        item.setInterpolated(100.0);
        item.setColor(new Color(Integer.valueOf(strings[1]), Integer.valueOf(strings[2]), Integer.valueOf(strings[3])));
        return item;
    }

    public void read(ColorTable colorTable, File file) throws ColorTableIOException {
        ColorTable tmpColorTable = this.read(file);
        colorTable.copyFrom(tmpColorTable);
    }

    public void write(ColorTable colorTable, File file) throws ColorTableIOException {
        List colorTableClasses = colorTable.getClasses();
        try {
            BufferedWriter writer = new BufferedWriter(new FileWriter(file));
            writer.write("GIMP Palette\n");
            writer.write("Name: " + colorTable.getName() + "\n");
            writer.write("#\n");
            for (int i = 0; i < colorTableClasses.size(); ++i) {
                String line = "";
                ColorTableClass item1 = (ColorTableClass)colorTableClasses.get(i);
                Color color = item1.getColor();
                line = line + color.getRed() + " ";
                line = line + color.getGreen() + " ";
                line = line + color.getBlue() + "\t";
                line = item1.getName() != null && item1.getName().length() > 0 ? line + item1.getName() + "\n" : line + "Untitled\n";
                writer.write(line);
            }
            writer.close();
        }
        catch (IOException e) {
            LOG.error("Can not write to create new Gimp palette file from color table", (Throwable)e);
            throw new ColorTableIOException((Throwable)e);
        }
    }
}

