/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.lib.legend.impl.io;

import java.awt.Color;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import org.gvsig.raster.lib.legend.api.RasterLegendLocator;
import org.gvsig.raster.lib.legend.api.RasterLegendManager;
import org.gvsig.raster.lib.legend.api.colortable.ColorTable;
import org.gvsig.raster.lib.legend.api.colortable.ColorTableIO;
import org.gvsig.raster.lib.legend.api.colortable.colortableclass.ColorTableClass;
import org.gvsig.raster.lib.legend.api.exceptions.ColorTableIOException;
import org.kxml2.io.KXmlParser;
import org.kxml2.io.KXmlSerializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xmlpull.v1.XmlPullParserException;

public class gvSIGColorTableIO
implements ColorTableIO {
    private static final Logger LOG = LoggerFactory.getLogger(gvSIGColorTableIO.class);
    public static final String NAME = "gvSIGColorTableIO";
    public static final String DESCRIPTION = "Color table IO to read and write gvSIG color tables";

    public String getName() {
        return NAME;
    }

    public String getDescription() {
        return DESCRIPTION;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ColorTable read(File file) throws ColorTableIOException {
        if (file.isDirectory()) {
            throw new IllegalArgumentException("File can not be a directory.");
        }
        if (!file.exists() || !file.canRead()) {
            throw new IllegalArgumentException("File does not exist or can be readed");
        }
        RasterLegendManager rasterLegendManager = RasterLegendLocator.getRasterLegendManager();
        ColorTable colorTable = rasterLegendManager.createColorTable();
        ArrayList<ColorTableClass> classes = new ArrayList<ColorTableClass>();
        KXmlParser parser = new KXmlParser();
        FileInputStream in = null;
        InputStreamReader reader = null;
        int tag = 0;
        try {
            in = new FileInputStream(file);
            reader = new InputStreamReader((InputStream)in, "UTF8");
            parser.setInput((Reader)reader);
            tag = parser.nextTag();
            parser.require(2, null, "ColorTable");
        }
        catch (FileNotFoundException e) {
            LOG.error(String.format("Can not find %1s file", file.getAbsolutePath()), (Throwable)e);
            throw new ColorTableIOException((Throwable)e);
        }
        catch (XmlPullParserException e) {
            LOG.error("Can not parse XML", (Throwable)e);
            throw new ColorTableIOException((Throwable)e);
        }
        catch (IOException e) {
            LOG.error("Can not go to next XML tag or there are errors setting require tag", (Throwable)e);
            throw new ColorTableIOException((Throwable)e);
        }
        for (int i = 0; i < parser.getAttributeCount(); ++i) {
            if (parser.getAttributeName(i).equals("name")) {
                colorTable.setName(parser.getAttributeValue(i));
                continue;
            }
            if (!parser.getAttributeName(i).equals("interpolated")) continue;
            colorTable.setInterpolated(Boolean.parseBoolean(parser.getAttributeValue(i)));
        }
        try {
            tag = parser.nextTag();
        }
        catch (IOException | XmlPullParserException e) {
            LOG.error("Can not go to next XML tag", e);
            throw new ColorTableIOException(e);
        }
        while (tag != 3 || !parser.getName().equals("ColorTable")) {
            try {
                if (tag != 2) continue;
                if (parser.getName().equals("Color")) {
                    ColorTableClass colorTableClass = rasterLegendManager.createColorTableClass();
                    int a = 255;
                    for (int i = 0; i < parser.getAttributeCount(); ++i) {
                        if (parser.getAttributeName(i).equals("value")) {
                            colorTableClass.setValue(Double.parseDouble(parser.getAttributeValue(i)));
                            ColorTableClass aux = this.getColorItem(classes, Double.parseDouble(parser.getAttributeValue(i)));
                            if (aux != null) {
                                a = aux.getColor().getAlpha();
                            }
                        }
                        if (parser.getAttributeName(i).equals("name")) {
                            colorTableClass.setName(parser.getAttributeValue(i));
                        }
                        if (parser.getAttributeName(i).equals("rgb")) {
                            String rgb = parser.getAttributeValue(i);
                            int r = Integer.valueOf(rgb.substring(0, rgb.indexOf(",")));
                            int g = Integer.valueOf(rgb.substring(rgb.indexOf(",") + 1, rgb.lastIndexOf(",")));
                            int b = Integer.valueOf(rgb.substring(rgb.lastIndexOf(",") + 1, rgb.length()));
                            colorTableClass.setColor(new Color(r, g, b, a));
                        }
                        if (!parser.getAttributeName(i).equals("interpolated")) continue;
                        colorTableClass.setInterpolated(Double.parseDouble(parser.getAttributeValue(i)));
                    }
                    classes.add(colorTableClass);
                    continue;
                }
                if (!parser.getName().equals("Alpha")) continue;
                ColorTableClass colorItem = null;
                for (int i = 0; i < parser.getAttributeCount(); ++i) {
                    if (parser.getAttributeName(i).equals("value")) {
                        colorItem = this.getColorItem(classes, Double.parseDouble(parser.getAttributeValue(i)));
                    }
                    if (parser.getAttributeName(i).equals("alpha") && colorItem != null) {
                        int a = Integer.parseInt(parser.getAttributeValue(i));
                        colorItem.setColor(new Color(colorItem.getColor().getRed(), colorItem.getColor().getGreen(), colorItem.getColor().getBlue(), a));
                    }
                    if (!parser.getAttributeName(i).equals("interpolated") || colorItem == null) continue;
                    colorItem.setInterpolated(Double.parseDouble(parser.getAttributeValue(i)));
                }
                classes.add(colorItem);
            }
            finally {
                try {
                    tag = parser.nextTag();
                }
                catch (IOException | XmlPullParserException e) {
                    LOG.error("Can not go to next XML tag", e);
                    throw new ColorTableIOException(e);
                }
            }
        }
        try {
            reader.close();
        }
        catch (IOException e) {
            LOG.warn("Can not close input stream", (Throwable)e);
        }
        colorTable.setClasses(classes, false);
        return colorTable;
    }

    private ColorTableClass getColorItem(List<ColorTableClass> classes, double value) {
        for (int i = 0; i < classes.size(); ++i) {
            if (classes.get(i).getValue() != value) continue;
            return classes.remove(i);
        }
        return null;
    }

    public void read(ColorTable colorTable, File file) throws ColorTableIOException {
        ColorTable tmpColorTable = this.read(file);
        colorTable.copyFrom(tmpColorTable);
    }

    public void write(ColorTable colorTable, File file) throws ColorTableIOException {
        try {
            ColorTableClass colorItem;
            int i;
            KXmlSerializer parserOutput = new KXmlSerializer();
            FileOutputStream out = new FileOutputStream(file);
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)out, "UTF8");
            parserOutput.setOutput((Writer)writer);
            parserOutput.startDocument("UTF-8", null);
            parserOutput.startTag(null, "ColorTable");
            parserOutput.attribute(null, "name", colorTable.getName());
            parserOutput.attribute(null, "interpolated", String.valueOf(colorTable.isInterpolated()));
            parserOutput.attribute(null, "version", "1.1");
            parserOutput.text("\n");
            List classes = colorTable.getClasses();
            for (i = 0; i < classes.size(); ++i) {
                colorItem = (ColorTableClass)classes.get(i);
                parserOutput.startTag(null, "Color");
                parserOutput.attribute(null, "value", String.valueOf(colorItem.getValue()));
                if (colorItem.getName() != null) {
                    parserOutput.attribute(null, "name", String.valueOf(colorItem.getName()));
                } else {
                    parserOutput.attribute(null, "name", "");
                }
                Color color = colorItem.getColor();
                parserOutput.attribute(null, "rgb", String.valueOf(color.getRed() + "," + color.getGreen() + "," + color.getBlue()));
                parserOutput.attribute(null, "interpolated", String.valueOf(colorItem.getInterpolated()));
                parserOutput.endTag(null, "Color");
                parserOutput.text("\n");
            }
            for (i = 0; i < classes.size(); ++i) {
                colorItem = (ColorTableClass)classes.get(i);
                parserOutput.startTag(null, "Alpha");
                parserOutput.attribute(null, "value", String.valueOf(colorItem.getValue()));
                parserOutput.attribute(null, "alpha", String.valueOf(colorItem.getColor().getAlpha()));
                parserOutput.attribute(null, "interpolated", String.valueOf(colorItem.getInterpolated()));
                parserOutput.endTag(null, "Alpha");
                parserOutput.text("\n");
            }
            parserOutput.endTag(null, "ColorTable");
            parserOutput.text("\n");
            parserOutput.endDocument();
            writer.close();
        }
        catch (FileNotFoundException e) {
            LOG.error(String.format("Can not find %1s file", file.getAbsolutePath()), (Throwable)e);
            throw new ColorTableIOException((Throwable)e);
        }
        catch (IOException e) {
            LOG.error("Error writting Color table to XML file", (Throwable)e);
            throw new ColorTableIOException((Throwable)e);
        }
    }
}

