/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.lib.legend.impl.operations.brightness;

import org.gvsig.fmap.geom.exception.CreateEnvelopeException;
import org.gvsig.raster.lib.buffer.api.Band;
import org.gvsig.raster.lib.buffer.api.BufferLocator;
import org.gvsig.raster.lib.buffer.api.BufferManager;
import org.gvsig.raster.lib.buffer.api.NoData;
import org.gvsig.raster.lib.buffer.api.exceptions.BandException;
import org.gvsig.raster.lib.buffer.api.exceptions.BufferException;
import org.gvsig.raster.lib.buffer.api.exceptions.BufferOperationException;
import org.gvsig.raster.lib.buffer.api.operations.OperationFactory;
import org.gvsig.raster.lib.buffer.spi.exceptions.ProcessingOperationException;
import org.gvsig.raster.lib.legend.api.RasterLegendLocator;
import org.gvsig.raster.lib.legend.api.RasterLegendManager;
import org.gvsig.raster.lib.legend.spi.AbstractColoredOperation;
import org.gvsig.tools.locator.LocatorException;

public class BrightnessOperation
extends AbstractColoredOperation {
    public static String BRIGHTNESS_PARAM = "brightness";
    public static String OUTPUT_COLOR_INTERPRETATION_PARAM = "output_color_interpretation";
    private int brightness;
    private RowProcessor rowProcessor;

    public BrightnessOperation(OperationFactory factory) {
        super(factory);
    }

    public void preProcess() throws BufferOperationException {
        super.preProcess();
        BufferManager manager = BufferLocator.getBufferManager();
        RasterLegendManager legendManager = RasterLegendLocator.getRasterLegendManager();
        this.brightness = (Integer)this.getParameter(BRIGHTNESS_PARAM, 0);
        int bands = this.getInputBuffer().getBandCount();
        if (this.mustCopyUnprocessedBands()) {
            this.setParameter(OUTPUT_COLOR_INTERPRETATION_PARAM, this.getInputColorInterpretation());
            NoData[] noData = this.getInputBuffer().getBandNoData();
            try {
                this.setOutputBuffer(manager.createBuffer(this.getInputBuffer().getRows(), this.getInputBuffer().getColumns(), this.getInputBuffer().getBandTypes(), this.getInputBuffer().getBandNoData(), this.getInputBuffer().getProjection(), this.getInputBuffer().getEnvelope()));
            }
            catch (Exception e) {
                throw new ProcessingOperationException((Throwable)e);
            }
        }
        String[] colorInterpretations = this.getProcessableBandColorInterpretationsAsArray();
        this.setOutputColorInterpretation(legendManager.createColorInterpretation(colorInterpretations));
        this.setParameter(OUTPUT_COLOR_INTERPRETATION_PARAM, this.getOutputColorInterpretation());
        try {
            this.setOutputBuffer(manager.createBuffer(this.getInputBuffer().getRows(), this.getInputBuffer().getColumns(), this.getProcessableBandTypesAsArray(), this.getProcessableBandNoDatasAsArray(), this.getInputBuffer().getProjection(), this.getInputBuffer().getEnvelope()));
        }
        catch (CreateEnvelopeException | BufferException | LocatorException e) {
            throw new ProcessingOperationException(e);
        }
    }

    public void process() throws ProcessingOperationException {
        super.process();
        for (int band = 0; band < this.getInputBuffer().getBandCount(); ++band) {
            this.rowProcessor = new ByteRowProcessor(band);
            if (this.isProcessableBand(band)) {
                Band bufferBand = this.getInputBuffer().getBand(band);
                Band outputBufferBand = this.getOutputBuffer().getBand(band);
                for (int row = 0; row < this.getInputBuffer().getRows(); ++row) {
                    Object rowBuffer = bufferBand.createRowBuffer();
                    bufferBand.fetchRow(row, rowBuffer);
                    Object outputRowBuffer = outputBufferBand.createRowBuffer();
                    this.rowProcessor.processRow(rowBuffer, outputRowBuffer);
                    outputBufferBand.putRow(row, outputRowBuffer);
                }
                continue;
            }
            if (this.mustCopyUnprocessedBands()) {
                try {
                    this.getOutputBuffer().getBand(band).copyFrom(this.getInputBuffer().getBand(band));
                    continue;
                }
                catch (BandException e) {
                    throw new ProcessingOperationException((Throwable)e);
                }
            }
            if (!this.getInputColorInterpretation().isAlphaInterpretation(band)) continue;
            try {
                this.getOutputBuffer().getBand(this.getOutputColorInterpretation().getAlphaBand()).copyFrom(this.getInputBuffer().getBand(band));
                continue;
            }
            catch (BandException e) {
                throw new ProcessingOperationException((Throwable)e);
            }
        }
    }

    protected boolean isProcessableBand(int band) {
        return this.isRGBorGrayBand(band) && this.getInputBuffer().getBandTypes()[band] == 0;
    }

    private boolean isRGBorGrayBand(int band) {
        String bandColorInterpretation = this.getInputColorInterpretation().get(band);
        return bandColorInterpretation.equals("Red") || bandColorInterpretation.equals("Green") || bandColorInterpretation.equals("Blue") || bandColorInterpretation.equals("Gray");
    }

    public void postProcess() throws BufferOperationException {
        super.postProcess();
    }

    private class ByteRowProcessor
    extends AbstractRowProcessor {
        public ByteRowProcessor(int band) {
            super(band);
        }

        @Override
        public void processRow(Object inputRow, Object outputRow) {
            byte[] inputByteRow = (byte[])inputRow;
            byte[] outputByteRow = (byte[])outputRow;
            for (int i = 0; i < inputByteRow.length; ++i) {
                outputByteRow[i] = this.processValue(inputByteRow[i]);
            }
        }

        @Override
        public byte processValue(Object value) {
            if (this.noData.isDefined() && this.noData.getValue().equals(value)) {
                return (Byte)value;
            }
            int iValue = 0xFF & (Byte)value;
            int result = iValue + BrightnessOperation.this.brightness;
            if (result > this.maxResult) {
                result = this.maxResult;
            }
            if (result < this.minResult) {
                result = this.minResult;
            }
            return (byte)result;
        }
    }

    private abstract class AbstractRowProcessor
    implements RowProcessor {
        int maxResult = 255;
        int minResult = 0;
        NoData noData;

        public AbstractRowProcessor(int band) {
            this.noData = BrightnessOperation.this.getInputBuffer().getBand(band).getNoData();
            if (this.noData.isDefined()) {
                this.minResult = 1;
            }
        }
    }

    static interface RowProcessor {
        public void processRow(Object var1, Object var2);

        public byte processValue(Object var1);
    }
}

