/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.lib.legend.impl.operations.cmyktorgb;

import java.util.ArrayList;
import java.util.List;
import org.gvsig.fmap.geom.exception.CreateEnvelopeException;
import org.gvsig.raster.lib.buffer.api.Band;
import org.gvsig.raster.lib.buffer.api.BufferLocator;
import org.gvsig.raster.lib.buffer.api.BufferManager;
import org.gvsig.raster.lib.buffer.api.NoData;
import org.gvsig.raster.lib.buffer.api.exceptions.BufferException;
import org.gvsig.raster.lib.buffer.api.exceptions.BufferOperationException;
import org.gvsig.raster.lib.buffer.api.operations.OperationFactory;
import org.gvsig.raster.lib.buffer.spi.exceptions.ProcessingOperationException;
import org.gvsig.raster.lib.legend.api.RasterLegendLocator;
import org.gvsig.raster.lib.legend.api.RasterLegendManager;
import org.gvsig.raster.lib.legend.impl.ColorManager;
import org.gvsig.raster.lib.legend.impl.RasterLegendManagerServices;
import org.gvsig.raster.lib.legend.spi.AbstractColoredOperation;
import org.gvsig.tools.locator.LocatorException;

public class CMYKToRGBOperation
extends AbstractColoredOperation {
    public CMYKToRGBOperation(OperationFactory factory) {
        super(factory);
    }

    public void preProcess() throws BufferOperationException {
        super.preProcess();
        BufferManager manager = BufferLocator.getBufferManager();
        RasterLegendManager legendManager = RasterLegendLocator.getRasterLegendManager();
        try {
            if (!this.getInputColorInterpretation().isCMYK()) {
                throw new UnsupportedOperationException("The color interpretation of input buffer isn't CMYK");
            }
            int[] inputBandTypes = this.getInputBuffer().getBandTypes();
            if (inputBandTypes[this.getInputColorInterpretation().getBand("Cyan")] != 0 || inputBandTypes[this.getInputColorInterpretation().getBand("Magenta")] != 0 || inputBandTypes[this.getInputColorInterpretation().getBand("Yellow")] != 0 || inputBandTypes[this.getInputColorInterpretation().getBand("Black")] != 0) {
                throw new UnsupportedOperationException("The type of bands isn't BYTE");
            }
            int sourceBands = this.getInputBuffer().getBandCount();
            NoData[] sourceNoDatas = this.getInputBuffer().getBandNoData();
            int[] sourceTypes = this.getInputBuffer().getBandTypes();
            ArrayList<String> colorInterpretations = new ArrayList<String>();
            ArrayList<NoData> noDatas = new ArrayList<NoData>();
            ArrayList<Integer> types = new ArrayList<Integer>();
            colorInterpretations.add("Red");
            colorInterpretations.add("Green");
            colorInterpretations.add("Blue");
            types.add(0);
            types.add(0);
            types.add(0);
            noDatas.add(null);
            noDatas.add(null);
            noDatas.add(null);
            if (this.getInputColorInterpretation().hasAlphaBand()) {
                int alphaBand = this.getInputColorInterpretation().getAlphaBand();
                if (sourceTypes[alphaBand] != 0) {
                    throw new UnsupportedOperationException("The type of ALPHA band isn't BYTE");
                }
                colorInterpretations.add("Alpha");
                types.add(sourceTypes[alphaBand]);
                noDatas.add(sourceNoDatas[alphaBand]);
            }
            if (this.mustCopyUnprocessedBands()) {
                for (int band = 0; band < sourceBands; ++band) {
                    if (this.isProcessableBand(band) || this.getInputColorInterpretation().isAlphaInterpretation(band)) continue;
                    colorInterpretations.add("Undefined");
                    noDatas.add(sourceNoDatas[band]);
                    types.add(this.getInputBuffer().getBandTypes()[band]);
                }
            }
            this.setOutputColorInterpretation(legendManager.createColorInterpretation(colorInterpretations));
            this.setParameter("output_color_interpretation", this.getOutputColorInterpretation());
            this.setOutputBuffer(manager.createBuffer(this.getInputBuffer().getRows(), this.getInputBuffer().getColumns(), this.getTypesAsArray(types), this.getNoDatasAsArray(noDatas), this.getInputBuffer().getProjection(), this.getInputBuffer().getEnvelope()));
        }
        catch (CreateEnvelopeException | BufferException | LocatorException e) {
            throw new ProcessingOperationException(e);
        }
    }

    public void process() throws ProcessingOperationException {
        try {
            super.process();
            if (this.mustCopyUnprocessedBands()) {
                int bands = this.getInputBuffer().getBandCount();
                int outBand = this.getInputColorInterpretation().hasAlphaBand() ? 4 : 3;
                for (int band = 0; band < bands; ++band) {
                    if (this.getInputColorInterpretation().isAlphaInterpretation(band)) {
                        this.getOutputBuffer().getBand(this.getInputColorInterpretation().getAlphaBand()).copyFrom(this.getInputBuffer().getBand(band));
                        continue;
                    }
                    if (this.isProcessableBand(band)) continue;
                    this.getOutputBuffer().getBand(outBand).copyFrom(this.getInputBuffer().getBand(band));
                    ++outBand;
                }
            }
            Object[] rowBandsBuffer = new Object[4];
            for (int row = 0; row < this.getInputBuffer().getRows(); ++row) {
                Band outputBufferBand;
                int band;
                Band bufferBandCyan = this.getInputBuffer().getBand(this.getInputColorInterpretation().getBand("Cyan"));
                rowBandsBuffer[0] = bufferBandCyan.createRowBuffer();
                bufferBandCyan.fetchRow(row, rowBandsBuffer[0]);
                Band bufferBandMagenta = this.getInputBuffer().getBand(this.getInputColorInterpretation().getBand("Magenta"));
                rowBandsBuffer[1] = bufferBandMagenta.createRowBuffer();
                bufferBandMagenta.fetchRow(row, rowBandsBuffer[1]);
                Band bufferBandYellow = this.getInputBuffer().getBand(this.getInputColorInterpretation().getBand("Yellow"));
                rowBandsBuffer[2] = bufferBandYellow.createRowBuffer();
                bufferBandYellow.fetchRow(row, rowBandsBuffer[2]);
                Band bufferBandBlack = this.getInputBuffer().getBand(this.getInputColorInterpretation().getBand("Black"));
                rowBandsBuffer[3] = bufferBandBlack.createRowBuffer();
                bufferBandBlack.fetchRow(row, rowBandsBuffer[3]);
                ArrayList<Object> outputRowBuffers = new ArrayList<Object>();
                for (band = 0; band < 3; ++band) {
                    outputBufferBand = this.getOutputBuffer().getBand(band);
                    Object outputRowBuffer = outputBufferBand.createRowBuffer();
                    outputRowBuffers.add(outputRowBuffer);
                }
                this.processRow(rowBandsBuffer, outputRowBuffers);
                for (band = 0; band < 3; ++band) {
                    outputBufferBand = this.getOutputBuffer().getBand(band);
                    outputBufferBand.putRow(row, outputRowBuffers.get(band));
                }
            }
        }
        catch (Exception e) {
            throw new ProcessingOperationException((Throwable)e);
        }
    }

    public void postProcess() throws BufferOperationException {
        super.postProcess();
    }

    private void processRow(Object[] inputRows, List outputRows) {
        ColorManager colorManager = ((RasterLegendManagerServices)RasterLegendLocator.getRasterLegendManager()).getColorManager();
        byte[][] inputByteRows = new byte[inputRows.length][((byte[])inputRows[0]).length];
        for (int i = 0; i < inputRows.length; ++i) {
            inputByteRows[i] = (byte[])inputRows[i];
        }
        int[] convertedValues = new int[3];
        for (int i = 0; i < inputByteRows[0].length; ++i) {
            double[] rgb = colorManager.CMYKtoRGB((double)(0xFF & inputByteRows[0][i]) / 255.0, (double)(0xFF & inputByteRows[1][i]) / 255.0, (double)(0xFF & inputByteRows[2][i]) / 255.0, (double)(0xFF & inputByteRows[3][i]) / 255.0);
            for (int band = 0; band < outputRows.size(); ++band) {
                ((byte[])outputRows.get((int)band))[i] = Double.valueOf(rgb[band] * 255.0).byteValue();
            }
        }
    }

    protected boolean isProcessableBand(int band) {
        return this.isCMYKBand(band) && this.getInputBuffer().getBandTypes()[band] == 0;
    }

    private boolean isCMYKBand(int band) {
        String bandColorInterpretation = this.getInputColorInterpretation().get(band);
        return bandColorInterpretation.equals("Cyan") || bandColorInterpretation.equals("Magenta") || bandColorInterpretation.equals("Yellow") || bandColorInterpretation.equals("Black");
    }
}

