/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.lib.legend.impl.operations.colorbalancecmy;

import java.util.List;
import org.gvsig.raster.lib.buffer.api.exceptions.BufferOperationException;
import org.gvsig.raster.lib.buffer.api.operations.OperationFactory;
import org.gvsig.raster.lib.legend.api.RasterLegendLocator;
import org.gvsig.raster.lib.legend.impl.ColorManager;
import org.gvsig.raster.lib.legend.impl.RasterLegendManagerServices;
import org.gvsig.raster.lib.legend.impl.operations.colorbalancergb.AbstractColorBalanceOperation;

public class ColorBalanceCMYOperation
extends AbstractColorBalanceOperation {
    public static String CYAN_PARAM = "cyan";
    public static String MAGENTA_PARAM = "magenta";
    public static String YELLOW_PARAM = "yellow";
    public static String LUMINOSITY_PARAM = "luminosity";
    private int cyan;
    private int magenta;
    private int yellow;
    private boolean luminosity;

    public ColorBalanceCMYOperation(OperationFactory factory) {
        super(factory);
    }

    @Override
    protected void initialiceParams() {
        this.cyan = (Integer)this.getParameter(CYAN_PARAM, 0);
        this.magenta = (Integer)this.getParameter(MAGENTA_PARAM, 0);
        this.yellow = (Integer)this.getParameter(YELLOW_PARAM, 0);
        this.luminosity = (Boolean)this.getParameter(LUMINOSITY_PARAM, 0);
    }

    @Override
    public void postProcess() throws BufferOperationException {
        super.postProcess();
    }

    @Override
    protected void processRow(Object[] inputRows, List outputRows) {
        int i;
        ColorManager colorManager = ((RasterLegendManagerServices)RasterLegendLocator.getRasterLegendManager()).getColorManager();
        byte[][] inputByteRows = new byte[inputRows.length][((byte[])inputRows[0]).length];
        for (i = 0; i < inputRows.length; ++i) {
            inputByteRows[i] = (byte[])inputRows[i];
        }
        for (i = 0; i < inputByteRows[0].length; ++i) {
            int band;
            byte[] value = new byte[4];
            value[0] = inputByteRows[0][i];
            value[1] = inputByteRows[1][i];
            value[2] = inputByteRows[2][i];
            double[] cmyk = colorManager.RGBtoCMYK(value[0] & 0xFF, value[1] & 0xFF, value[2] & 0xFF, 1.0);
            double lum = colorManager.getLuminosity(value[0] & 0xFF, value[1] & 0xFF, value[2] & 0xFF);
            cmyk[0] = Math.min(cmyk[0] + (double)this.cyan / 300.0, 1.0);
            cmyk[1] = Math.min(cmyk[1] + (double)this.magenta / 300.0, 1.0);
            cmyk[2] = Math.min(cmyk[2] + (double)this.yellow / 300.0, 1.0);
            double[] rgb = colorManager.CMYKtoRGB(cmyk[0], cmyk[1], cmyk[2], cmyk[3]);
            for (band = 0; band < 3; ++band) {
                value[band] = (byte)(rgb[band] * 255.0);
            }
            if (this.luminosity) {
                double[] hsl = colorManager.RGBtoHSL(value[0] & 0xFF, value[1] & 0xFF, value[2] & 0xFF);
                hsl[0] = (int)(255.0 * hsl[0] / 360.0 + 0.5);
                hsl[1] = (int)(hsl[1] * 255.0 + 0.5);
                hsl[2] = (int)(lum * 255.0 + 0.5);
                int[] v1 = colorManager.HSLtoRGB((int)hsl[0] & 0xFFFFFFFF, (int)hsl[1] & 0xFFFFFFFF, (int)hsl[2] & 0xFFFFFFFF);
                for (int band2 = 0; band2 < 3; ++band2) {
                    value[band2] = Integer.valueOf(v1[band2]).byteValue();
                }
            }
            for (band = 0; band < inputRows.length; ++band) {
                ((byte[])outputRows.get((int)band))[i] = value[band];
            }
        }
    }
}

