/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.lib.legend.impl.operations.colorbalancergb;

import java.util.ArrayList;
import java.util.List;
import org.gvsig.fmap.geom.exception.CreateEnvelopeException;
import org.gvsig.raster.lib.buffer.api.Band;
import org.gvsig.raster.lib.buffer.api.BufferLocator;
import org.gvsig.raster.lib.buffer.api.BufferManager;
import org.gvsig.raster.lib.buffer.api.NoData;
import org.gvsig.raster.lib.buffer.api.exceptions.BandException;
import org.gvsig.raster.lib.buffer.api.exceptions.BufferException;
import org.gvsig.raster.lib.buffer.api.exceptions.BufferOperationException;
import org.gvsig.raster.lib.buffer.api.operations.OperationFactory;
import org.gvsig.raster.lib.buffer.spi.exceptions.ProcessingOperationException;
import org.gvsig.raster.lib.legend.api.RasterLegendLocator;
import org.gvsig.raster.lib.legend.api.RasterLegendManager;
import org.gvsig.raster.lib.legend.spi.AbstractColoredOperation;
import org.gvsig.tools.locator.LocatorException;

public abstract class AbstractColorBalanceOperation
extends AbstractColoredOperation {
    public AbstractColorBalanceOperation(OperationFactory factory) {
        super(factory);
    }

    protected abstract void initialiceParams();

    public void preProcess() throws BufferOperationException {
        super.preProcess();
        BufferManager manager = BufferLocator.getBufferManager();
        RasterLegendManager legendManager = RasterLegendLocator.getRasterLegendManager();
        this.initialiceParams();
        try {
            if (!this.getInputColorInterpretation().isGray() && !this.getInputColorInterpretation().isRGB()) {
                throw new UnsupportedOperationException("The color interpretation of input buffer isn't RGB nor GRAYSCALE");
            }
            int[] inputBandTypes = this.getInputBuffer().getBandTypes();
            if (this.getInputColorInterpretation().isGray()) {
                if (inputBandTypes[this.getInputColorInterpretation().getBand("Gray")] != 0) {
                    throw new UnsupportedOperationException("The type of GRAY band isn't BYTE");
                }
            } else if (this.getInputColorInterpretation().isRGB()) {
                if (inputBandTypes[this.getInputColorInterpretation().getBand("Red")] != 0 || inputBandTypes[this.getInputColorInterpretation().getBand("Green")] != 0 || inputBandTypes[this.getInputColorInterpretation().getBand("Blue")] != 0) {
                    throw new UnsupportedOperationException("The type of RGB bands isn't BYTE");
                }
            } else {
                throw new UnsupportedOperationException("The color interpretation of input buffer isn't RGB nor GRAYSCALE");
            }
            int sourceBands = this.getInputBuffer().getBandCount();
            NoData[] sourceNoDatas = this.getInputBuffer().getBandNoData();
            int[] sourceTypes = this.getInputBuffer().getBandTypes();
            ArrayList<String> colorInterpretations = new ArrayList<String>();
            ArrayList<NoData> noDatas = new ArrayList<NoData>();
            ArrayList<Integer> types = new ArrayList<Integer>();
            colorInterpretations.add("Red");
            colorInterpretations.add("Green");
            colorInterpretations.add("Blue");
            types.add(0);
            types.add(0);
            types.add(0);
            noDatas.add(null);
            noDatas.add(null);
            noDatas.add(null);
            if (this.getInputColorInterpretation().hasAlphaBand()) {
                int alphaBand = this.getInputColorInterpretation().getAlphaBand();
                if (sourceTypes[alphaBand] != 0) {
                    throw new UnsupportedOperationException("The type of ALPHA band isn't BYTE");
                }
                colorInterpretations.add("Alpha");
                types.add(sourceTypes[alphaBand]);
                noDatas.add(sourceNoDatas[alphaBand]);
            }
            if (this.mustCopyUnprocessedBands()) {
                for (int band = 0; band < sourceBands; ++band) {
                    if (this.isProcessableBand(band) || this.getInputColorInterpretation().isAlphaInterpretation(band)) continue;
                    colorInterpretations.add(this.getInputColorInterpretation().get(band));
                    noDatas.add(sourceNoDatas[band]);
                    types.add(this.getInputBuffer().getBandTypes()[band]);
                }
            }
            this.setOutputColorInterpretation(legendManager.createColorInterpretation(colorInterpretations));
            this.setParameter("output_color_interpretation", this.getOutputColorInterpretation());
            this.setOutputBuffer(manager.createBuffer(this.getInputBuffer().getRows(), this.getInputBuffer().getColumns(), this.getTypesAsArray(types), this.getNoDatasAsArray(noDatas), this.getInputBuffer().getProjection(), this.getInputBuffer().getEnvelope()));
        }
        catch (CreateEnvelopeException | BufferException | LocatorException e) {
            throw new BufferOperationException(e);
        }
    }

    public void process() throws ProcessingOperationException {
        super.process();
        if (this.getInputColorInterpretation().hasAlphaBand()) {
            try {
                this.getOutputBuffer().getBand(3).copyFrom(this.getInputBuffer().getBand(this.getInputColorInterpretation().getAlphaBand()));
            }
            catch (BandException e) {
                throw new ProcessingOperationException((Throwable)e);
            }
        }
        Object[] rowBandsBuffer = new Object[3];
        for (int row = 0; row < this.getInputBuffer().getRows(); ++row) {
            Band outputBufferBand;
            int band;
            if (this.getInputColorInterpretation().isGray()) {
                Band bufferBandGray = this.getInputBuffer().getBand(this.getInputColorInterpretation().getBand("Gray"));
                rowBandsBuffer[0] = bufferBandGray.createRowBuffer();
                bufferBandGray.fetchRow(row, rowBandsBuffer[0]);
                rowBandsBuffer[1] = bufferBandGray.createRowBuffer();
                bufferBandGray.fetchRow(row, rowBandsBuffer[0]);
                rowBandsBuffer[2] = bufferBandGray.createRowBuffer();
                bufferBandGray.fetchRow(row, rowBandsBuffer[0]);
            } else if (this.getInputColorInterpretation().isRGB()) {
                Band bufferBandRed = this.getInputBuffer().getBand(this.getInputColorInterpretation().getBand("Red"));
                rowBandsBuffer[0] = bufferBandRed.createRowBuffer();
                bufferBandRed.fetchRow(row, rowBandsBuffer[0]);
                Band bufferBandGreen = this.getInputBuffer().getBand(this.getInputColorInterpretation().getBand("Green"));
                rowBandsBuffer[1] = bufferBandGreen.createRowBuffer();
                bufferBandGreen.fetchRow(row, rowBandsBuffer[1]);
                Band bufferBandBlue = this.getInputBuffer().getBand(this.getInputColorInterpretation().getBand("Blue"));
                rowBandsBuffer[2] = bufferBandBlue.createRowBuffer();
                bufferBandBlue.fetchRow(row, rowBandsBuffer[2]);
            } else {
                throw new UnsupportedOperationException("The color interpretation of input buffer isn't RGB nor GRAYSCALE");
            }
            ArrayList<Object> outputRowBuffers = new ArrayList<Object>();
            for (band = 0; band < 3; ++band) {
                outputBufferBand = this.getOutputBuffer().getBand(band);
                Object outputRowBuffer = outputBufferBand.createRowBuffer();
                outputRowBuffers.add(outputRowBuffer);
            }
            this.processRow(rowBandsBuffer, outputRowBuffers);
            for (band = 0; band < 3; ++band) {
                outputBufferBand = this.getOutputBuffer().getBand(band);
                outputBufferBand.putRow(row, outputRowBuffers.get(band));
            }
        }
    }

    protected abstract void processRow(Object[] var1, List var2);

    public void postProcess() throws BufferOperationException {
        super.postProcess();
    }

    protected boolean isProcessableBand(int band) {
        return this.isRGBorGrayBand(band) && this.getInputBuffer().getBandTypes()[band] == 0;
    }

    protected boolean isRGBorGrayBand(int band) {
        String bandColorInterpretation = this.getInputColorInterpretation().get(band);
        return bandColorInterpretation.equals("Red") || bandColorInterpretation.equals("Green") || bandColorInterpretation.equals("Blue") || bandColorInterpretation.equals("Gray");
    }
}

