/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.lib.buffer.impl;

import java.io.IOException;
import java.nio.Buffer;
import org.gvsig.raster.lib.buffer.api.Band;
import org.gvsig.raster.lib.buffer.api.BandInfo;
import org.gvsig.raster.lib.buffer.api.BandTileManager;
import org.gvsig.raster.lib.buffer.api.BufferLocator;
import org.gvsig.raster.lib.buffer.api.NoData;
import org.gvsig.raster.lib.buffer.impl.AbstractBand;
import org.gvsig.raster.lib.buffer.impl.DefaultBufferNotification;
import org.gvsig.raster.lib.buffer.impl.exceptions.CopyFromBandException;
import org.gvsig.tools.dispose.Disposable;
import org.gvsig.tools.dispose.DisposeUtils;
import org.gvsig.tools.exception.BaseException;

public abstract class AbstractTiledBand
extends AbstractBand
implements Band {
    protected Buffer data;
    protected int firstRowOfTile;
    protected int firstColumnOfTile;
    protected int rowsPerTile;
    protected int columnsPerTile;
    protected BandTileManager tileManager;
    private boolean loaded;
    protected int rowsInTile;
    protected int columnsInTile;

    public AbstractTiledBand(int rows, int columns, NoData noData, BandTileManager tileManager) {
        this.rows = rows;
        this.columns = columns;
        this.loaded = false;
        this.rowsPerTile = tileManager.getRowsPerTile();
        this.columnsPerTile = tileManager.getColumnsPerTile();
        this.rowsInTile = this.rowsPerTile;
        this.columnsInTile = this.columnsPerTile;
        this.noData = noData == null ? BufferLocator.getBufferManager().createNoData(null, null) : noData;
        this.tileManager = tileManager;
    }

    @Override
    protected void doCopyFrom(Band source) throws CopyFromBandException {
        if (this.getColumns() != source.getColumns() || this.getRows() != source.getRows() || this.getDataType() != source.getDataType()) {
            throw new CopyFromBandException(source, this);
        }
        Object rowBuffer = this.createRowBuffer();
        for (int row = 0; row <= this.rows; ++row) {
            source.fetchRow(row, rowBuffer);
            this.putRow(row, rowBuffer);
        }
    }

    @Override
    protected void doCopyFrom(Band source, int row, int column) throws CopyFromBandException {
        if (this.getColumns() <= row + source.getColumns() || this.getRows() <= column + source.getRows() || this.getDataType() != source.getDataType()) {
            throw new CopyFromBandException(source, this);
        }
        Object rowBuffer = source.createRowBuffer();
        for (int r = 0; r < Math.min(this.getRows() - row, source.getRows()); ++r) {
            source.fetchRow(r, rowBuffer);
            System.arraycopy(rowBuffer, 0, this.data, (r + row) * this.getColumns() + column, Math.min(this.getColumns() - column, source.getColumns()));
            this.putRow(r, rowBuffer);
        }
    }

    protected void loadTile(int row, int column) {
        if (this.loaded && row >= this.firstRowOfTile && row < this.firstRowOfTile + this.rowsPerTile && column >= this.firstColumnOfTile && column < this.firstColumnOfTile + this.columnsPerTile) {
            return;
        }
        if (this.loaded) {
            this.saveCurrentTile();
        }
        this.loaded = false;
        int currentTileRow = row / this.rowsPerTile;
        this.firstRowOfTile = currentTileRow * this.rowsPerTile;
        int currentTileColumn = column / this.columnsPerTile;
        this.firstColumnOfTile = currentTileColumn * this.columnsPerTile;
        Band loadedBand = null;
        try {
            this.rowsInTile = this.rowsPerTile;
            if (this.firstRowOfTile + this.rowsPerTile > this.rows) {
                this.rowsInTile = this.rows - this.firstRowOfTile;
            }
            this.columnsInTile = this.columnsPerTile;
            if (this.firstColumnOfTile + this.columnsPerTile > this.columns) {
                this.columnsInTile = this.columns - this.firstColumnOfTile;
            }
            loadedBand = this.tileManager.load(this.firstRowOfTile, this.firstColumnOfTile, this.getDataType());
            Object rowBuffer = loadedBand.createRowBuffer();
            for (int loadedRow = 0; loadedRow < this.rowsInTile; ++loadedRow) {
                loadedBand.fetchRow(loadedRow, rowBuffer);
                int pos = loadedRow * this.columnsInTile;
                System.arraycopy(rowBuffer, 0, this.data.array(), pos, loadedBand.getColumns());
            }
            this.loaded = true;
            this.notifyObservers((Object)new DefaultBufferNotification("loaded_page_notification", new Object[]{this}));
        }
        catch (IOException e) {
            try {
                throw new RuntimeException("Can't load current tile", e);
            }
            catch (Throwable throwable) {
                DisposeUtils.dispose(loadedBand);
                throw throwable;
            }
        }
        DisposeUtils.dispose((Disposable)loadedBand);
    }

    protected void saveCurrentTile() {
        try {
            int rowsInTile = this.rowsPerTile;
            if (this.firstRowOfTile + this.rowsPerTile > this.rows) {
                rowsInTile = this.rows - this.firstRowOfTile;
            }
            int columnsInTile = this.columnsPerTile;
            if (this.firstColumnOfTile + this.columnsPerTile > this.columns) {
                columnsInTile = this.columns - this.firstColumnOfTile;
            }
            this.tileManager.save(this.data, this.firstRowOfTile, rowsInTile, this.firstColumnOfTile, columnsInTile, this.getDataType());
        }
        catch (UnsupportedOperationException rowsInTile) {
        }
        catch (IOException e) {
            throw new RuntimeException("Can't save current tile", e);
        }
    }

    protected abstract int getDataSize();

    @Override
    public boolean isReadOnly() {
        if (this.tileManager == null) {
            return false;
        }
        return !this.tileManager.isSupportedSave();
    }

    @Override
    public boolean isPaginated() {
        return true;
    }

    @Override
    public BandInfo getBandInfo() {
        return this.tileManager == null ? null : this.tileManager.getBandInfo();
    }

    protected int calculateBufferSizeToAllocate(int rows, int columns) {
        int allocateRows = this.rowsInTile;
        if (rows < this.rowsInTile) {
            allocateRows = rows;
        }
        int allocateColumns = this.columnsInTile;
        return allocateRows * allocateColumns;
    }

    @Override
    public void doDispose() throws BaseException {
        super.doDispose();
        this.data = null;
        this.tileManager = null;
    }
}

