/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.lib.buffer.impl;

import java.awt.image.Raster;
import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ShortBuffer;
import org.gvsig.raster.lib.buffer.api.BandInfo;
import org.gvsig.raster.lib.buffer.api.BandPageManager;
import org.gvsig.tools.dispose.impl.AbstractDisposable;
import org.gvsig.tools.exception.BaseException;

public class AwtRasterBandPageManager
extends AbstractDisposable
implements BandPageManager {
    private Raster img;
    private int band;

    public AwtRasterBandPageManager(Raster img, int band) {
        this.img = img;
        this.band = band;
    }

    public void load(Buffer buffer, int row, int rows, int dataType) throws IOException {
        buffer.rewind();
        int columns = this.img.getWidth();
        switch (dataType) {
            case 0: {
                int[] intArray = new int[buffer.capacity()];
                this.img.getSamples(0, row, columns, rows, this.band, intArray);
                for (int cell = 0; cell < intArray.length; ++cell) {
                    ((ByteBuffer)buffer).put(cell, (byte)intArray[cell]);
                }
                break;
            }
            case 1: 
            case 2: {
                int[] intArray = new int[buffer.capacity()];
                this.img.getSamples(row, 0, columns, rows, this.band, intArray);
                for (int cell = 0; cell < intArray.length; ++cell) {
                    ((ShortBuffer)buffer).put(cell, (short)intArray[cell]);
                }
                break;
            }
            case 3: {
                this.img.getSamples(row, 0, columns, rows, this.band, (int[])buffer.array());
                break;
            }
            case 4: {
                this.img.getSamples(row, 0, columns, rows, this.band, (float[])buffer.array());
                break;
            }
            case 5: {
                this.img.getSamples(row, 0, columns, rows, this.band, (double[])buffer.array());
                break;
            }
            default: {
                throw new IllegalArgumentException("Data Type " + dataType + " not supported.");
            }
        }
    }

    public void save(Buffer buffer, int row, int rows, int dataType) throws IOException {
    }

    public boolean isSupportedSave() {
        return false;
    }

    public BandInfo getBandInfo() {
        return null;
    }

    protected void doDispose() throws BaseException {
        this.img = null;
    }
}

