/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.lib.buffer.impl;

import java.awt.image.BufferedImage;
import java.util.ArrayList;
import org.gvsig.fmap.geom.primitive.Envelope;
import org.gvsig.raster.lib.buffer.api.Band;
import org.gvsig.raster.lib.buffer.api.Buffer;
import org.gvsig.raster.lib.buffer.api.BufferLocator;
import org.gvsig.raster.lib.buffer.api.BufferManager;
import org.gvsig.raster.lib.buffer.api.exceptions.BandException;
import org.gvsig.raster.lib.buffer.impl.AbstractBuffer;
import org.gvsig.raster.lib.buffer.impl.exceptions.CreateBufferException;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dispose.Disposable;
import org.gvsig.tools.dispose.DisposeUtils;
import org.gvsig.tools.exception.BaseException;
import org.gvsig.tools.observer.Observer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClippedBuffer
extends AbstractBuffer
implements Buffer {
    protected static final Logger logger = LoggerFactory.getLogger(ClippedBuffer.class);
    Buffer buffer;
    int firstRow;
    int firstColumn;

    public ClippedBuffer(Buffer buffer, Envelope envelope) throws CreateBufferException {
        ToolsLocator.getDisposableManager().bind((Disposable)buffer);
        this.buffer = buffer;
        try {
            Envelope intersectionEnvelope = this.buffer.getEnvelope().getGeometry().intersection(envelope.getGeometry()).getEnvelope();
            int rows = (int)Math.round(intersectionEnvelope.getLength(1) / this.buffer.getDimensions().getPixelSizeY());
            rows = rows == 0 ? 1 : rows;
            int columns = (int)Math.round(intersectionEnvelope.getLength(0) / this.buffer.getDimensions().getPixelSizeX());
            columns = columns == 0 ? 1 : columns;
            this.dimensions = BufferLocator.getBufferManager().createBufferDimensions(rows, columns, intersectionEnvelope);
            this.firstRow = (int)Math.round((this.buffer.getEnvelope().getMaximum(1) - this.getEnvelope().getMaximum(1)) / this.buffer.getDimensions().getPixelSizeY());
            this.firstColumn = (int)Math.round((this.getEnvelope().getMinimum(0) - this.buffer.getEnvelope().getMinimum(0)) / this.buffer.getDimensions().getPixelSizeX());
            this.projection = buffer.getProjection();
            this.bands = new ArrayList();
            this.createBands(this.buffer.getBands());
        }
        catch (Exception e) {
            throw new CreateBufferException(e);
        }
    }

    private void createBands(Band[] bands) throws BandException {
        BufferManager bufferManager = BufferLocator.getBufferManager();
        for (int i = 0; i < bands.length; ++i) {
            Band band = bufferManager.createClippedBand((Buffer)this, bands[i]);
            this.bands.add(band);
            band.addObserver((Observer)this);
        }
    }

    protected int getFirstRow() {
        return this.firstRow;
    }

    protected int getFirstColumn() {
        return this.firstColumn;
    }

    @Override
    public void doDispose() throws BaseException {
        super.doDispose();
        DisposeUtils.dispose((Disposable)this.buffer);
        this.buffer = null;
    }

    public BufferedImage getBufferedImage() {
        return null;
    }
}

