/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.lib.buffer.impl;

import org.gvsig.raster.lib.buffer.api.NoData;

public class DefaultNoData
implements NoData {
    Number value;
    Number defaultValue;

    public DefaultNoData(Number defaultValue) {
        this.value = this.defaultValue = defaultValue;
    }

    public void setDefaultValue(Number defaultValue) {
        this.defaultValue = defaultValue;
    }

    public int compareTo(NoData o) {
        Number aux = null;
        if (o.isDefined()) {
            aux = o.getValue();
        }
        return ((Comparable)((Object)this.value)).compareTo((Comparable)((Object)aux));
    }

    public boolean equals(Object obj) {
        if (obj instanceof NoData) {
            return this.compareTo((NoData)obj) == 0;
        }
        return super.equals(obj);
    }

    public Number getValue() {
        return this.value;
    }

    public void setValue(Number value) {
        this.value = value;
    }

    public boolean isDefined() {
        return this.value != null;
    }

    public void clear() {
        this.value = null;
    }

    public void restore() {
        this.value = this.defaultValue;
    }

    public Number getDefaultValue() {
        return this.defaultValue;
    }

    public int getDataType() {
        if (this.value instanceof Byte) {
            return 0;
        }
        if (this.value instanceof Short) {
            return 2;
        }
        if (this.value instanceof Integer) {
            return 3;
        }
        if (this.value instanceof Float) {
            return 4;
        }
        if (this.value instanceof Double) {
            return 5;
        }
        return 32;
    }

    public void copyFrom(NoData noData) {
        this.defaultValue = noData.getDefaultValue();
        this.value = noData.getValue();
    }

    public Object clone() throws CloneNotSupportedException {
        DefaultNoData cloned = (DefaultNoData)super.clone();
        cloned.setDefaultValue(this.getDefaultValue());
        cloned.setValue(this.getValue());
        return cloned;
    }
}

