/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.lib.buffer.impl;

import java.util.Arrays;
import org.gvsig.raster.lib.buffer.api.Band;
import org.gvsig.raster.lib.buffer.api.BufferLocator;
import org.gvsig.raster.lib.buffer.api.NoData;
import org.gvsig.raster.lib.buffer.impl.AbstractBand;
import org.gvsig.raster.lib.buffer.impl.DefaultBandNotification;
import org.gvsig.raster.lib.buffer.impl.exceptions.CopyFromBandException;

public class MemoryBandInt
extends AbstractBand
implements Band.BandInt {
    int[] data;

    public MemoryBandInt(int rows, int columns) {
        this(rows, columns, BufferLocator.getBufferManager().createNoData(null, null));
    }

    public MemoryBandInt(int rows, int columns, NoData noData) {
        this.rows = rows;
        this.columns = columns;
        this.data = new int[rows * columns];
        this.noData = noData == null ? BufferLocator.getBufferManager().createNoData(null, null) : noData;
    }

    public int getDataType() {
        return 3;
    }

    public Object get(int row, int column) {
        return this.getValue(row, column);
    }

    @Override
    protected void doSet(int row, int column, Object value) {
        this.setValue(row, column, (Integer)value);
    }

    @Override
    protected void doFill(Object value) {
        if ((value = this.nullValueToNoData(value)) == null) {
            value = 0;
        }
        Arrays.fill(this.data, (Integer)value);
    }

    int[] getData() {
        return this.data;
    }

    @Override
    protected void doCopyFrom(Band source) throws CopyFromBandException {
        if (this.getColumns() == source.getColumns() && this.getRows() == source.getRows()) {
            if (source instanceof MemoryBandInt) {
                System.arraycopy(((MemoryBandInt)source).getData(), 0, this.data, 0, this.getRows() * this.getColumns());
            } else {
                Object rowBuffer = source.createRowBuffer();
                for (int row = 0; row < source.getRows(); ++row) {
                    source.fetchRow(row, rowBuffer);
                    try {
                        System.arraycopy(rowBuffer, 0, this.data, row * this.getColumns(), this.getColumns());
                        continue;
                    }
                    catch (Exception e) {
                        throw new CopyFromBandException(source, this, e);
                    }
                }
            }
        } else {
            throw new CopyFromBandException(source, this);
        }
    }

    @Override
    protected void doCopyFrom(Band source, int row, int column) throws CopyFromBandException {
        if (this.getColumns() >= source.getColumns() + column && this.getRows() >= source.getRows() + row && source instanceof MemoryBandInt) {
            for (int r = 0; r < Math.min(this.getRows() - row, source.getRows()); ++r) {
                System.arraycopy(((MemoryBandInt)source).getData(), r * source.getColumns(), this.data, (r + row) * this.getColumns() + column, Math.min(this.getColumns() - column, source.getColumns()));
            }
        } else {
            throw new CopyFromBandException(source, this);
        }
    }

    public int getValue(int row, int column) {
        return this.data[row * this.getColumns() + column];
    }

    public void setValue(int row, int column, int value) {
        this.doSetValue(row, column, value);
        this.notifyObservers((Object)new DefaultBandNotification("set_band_notification", new Object[]{row, column, value}));
    }

    protected void doSetValue(int row, int column, int value) {
        this.data[row * this.getColumns() + column] = value;
    }

    public int[] createRowBuffer() {
        return new int[this.getColumns()];
    }

    public void fetchRow(int row, Object rowBuffer) {
        System.arraycopy(this.data, row * this.getColumns(), (int[])rowBuffer, 0, this.getColumns());
    }

    @Override
    protected void doPutRow(int row, Object rowBuffer) {
        System.arraycopy((int[])rowBuffer, 0, this.data, row * this.getColumns(), this.getColumns());
    }
}

