/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.lib.buffer.impl;

import java.nio.DoubleBuffer;
import java.util.Arrays;
import org.gvsig.raster.lib.buffer.api.Band;
import org.gvsig.raster.lib.buffer.api.BandTileManager;
import org.gvsig.raster.lib.buffer.api.NoData;
import org.gvsig.raster.lib.buffer.impl.AbstractTiledBand;
import org.gvsig.raster.lib.buffer.impl.DefaultBandNotification;

public class TiledBandDouble
extends AbstractTiledBand
implements Band.BandDouble {
    public TiledBandDouble(int rows, int columns, NoData noData, BandTileManager tileManager) {
        super(rows, columns, noData, tileManager);
        this.data = DoubleBuffer.allocate(this.calculateBufferSizeToAllocate(rows, columns));
    }

    public int getDataType() {
        return 5;
    }

    @Override
    protected int getDataSize() {
        return 8;
    }

    public Object get(int row, int column) {
        return this.getValue(row, column);
    }

    @Override
    protected void doSet(int row, int column, Object value) {
        this.setValue(row, column, (Double)value);
    }

    @Override
    protected void doFill(Object value) {
        if ((value = this.nullValueToNoData(value)) == null) {
            value = 0;
        }
        for (int row = 0; row < this.rows; row += this.rowsInTile) {
            for (int column = 0; column < this.columns; column += this.columnsInTile) {
                this.loadTile(row, column);
                Arrays.fill((double[])this.data.array(), (Double)value);
            }
        }
    }

    public double getValue(int row, int column) {
        this.loadTile(row, column);
        return ((DoubleBuffer)this.data).get((row - this.firstRowOfTile) * this.columnsInTile + (column - this.firstColumnOfTile));
    }

    public void setValue(int row, int column, double value) {
        this.doSetValue(row, column, value);
        this.notifyObservers((Object)new DefaultBandNotification("set_band_notification", new Object[]{row, column, value}));
    }

    protected void doSetValue(int row, int column, double value) {
        this.loadTile(row, column);
        ((DoubleBuffer)this.data).put((row - this.firstRowOfTile) * this.columnsInTile + (column - this.firstColumnOfTile), value);
    }

    public double[] createRowBuffer() {
        return new double[this.getColumns()];
    }

    public void fetchRow(int row, Object rowBuffer) {
        double[] target = (double[])rowBuffer;
        for (int column = 0; column < this.columns; column += this.columnsInTile) {
            this.loadTile(row, column);
            double[] source = (double[])this.data.array();
            System.arraycopy(source, (row - this.firstRowOfTile) * this.columnsInTile, target, column, this.columnsInTile);
        }
    }

    @Override
    protected void doPutRow(int row, Object rowBuffer) {
        double[] source = (double[])rowBuffer;
        for (int column = 0; column < this.columns; column += this.columnsInTile) {
            this.loadTile(row, column);
            double[] target = (double[])this.data.array();
            System.arraycopy(source, column, target, (row - this.firstRowOfTile) * this.columnsInTile, this.columnsInTile);
        }
    }
}

