/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.lib.buffer.impl;

import java.nio.FloatBuffer;
import java.util.Arrays;
import org.gvsig.raster.lib.buffer.api.Band;
import org.gvsig.raster.lib.buffer.api.BandTileManager;
import org.gvsig.raster.lib.buffer.api.NoData;
import org.gvsig.raster.lib.buffer.impl.AbstractTiledBand;
import org.gvsig.raster.lib.buffer.impl.DefaultBandNotification;

public class TiledBandFloat
extends AbstractTiledBand
implements Band.BandFloat {
    public TiledBandFloat(int rows, int columns, NoData noData, BandTileManager tileManager) {
        super(rows, columns, noData, tileManager);
        this.data = FloatBuffer.allocate(this.calculateBufferSizeToAllocate(rows, columns));
    }

    public int getDataType() {
        return 4;
    }

    @Override
    protected int getDataSize() {
        return 4;
    }

    public Object get(int row, int column) {
        return Float.valueOf(this.getValue(row, column));
    }

    @Override
    protected void doSet(int row, int column, Object value) {
        this.setValue(row, column, ((Float)value).floatValue());
    }

    @Override
    protected void doFill(Object value) {
        if ((value = this.nullValueToNoData(value)) == null) {
            value = 0;
        }
        for (int row = 0; row < this.rows; row += this.rowsInTile) {
            for (int column = 0; column < this.columns; column += this.columnsInTile) {
                this.loadTile(row, column);
                Arrays.fill((float[])this.data.array(), ((Float)value).floatValue());
            }
        }
    }

    public float getValue(int row, int column) {
        this.loadTile(row, column);
        return ((FloatBuffer)this.data).get((row - this.firstRowOfTile) * this.columnsInTile + (column - this.firstColumnOfTile));
    }

    public void setValue(int row, int column, float value) {
        this.doSetValue(row, column, value);
        this.notifyObservers((Object)new DefaultBandNotification("set_band_notification", new Object[]{row, column, Float.valueOf(value)}));
    }

    protected void doSetValue(int row, int column, float value) {
        this.loadTile(row, column);
        ((FloatBuffer)this.data).put((row - this.firstRowOfTile) * this.columnsInTile + (column - this.firstColumnOfTile), value);
    }

    public float[] createRowBuffer() {
        return new float[this.getColumns()];
    }

    public void fetchRow(int row, Object rowBuffer) {
        float[] target = (float[])rowBuffer;
        for (int column = 0; column < this.columns; column += this.columnsInTile) {
            this.loadTile(row, column);
            float[] source = (float[])this.data.array();
            System.arraycopy(source, (row - this.firstRowOfTile) * this.columnsInTile, target, column, this.columnsInTile);
        }
    }

    @Override
    protected void doPutRow(int row, Object rowBuffer) {
        float[] source = (float[])rowBuffer;
        for (int column = 0; column < this.columns; column += this.columnsInTile) {
            this.loadTile(row, column);
            float[] target = (float[])this.data.array();
            System.arraycopy(source, column, target, (row - this.firstRowOfTile) * this.columnsInTile, this.columnsInTile);
        }
    }
}

