/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.lib.buffer.impl;

import java.nio.ShortBuffer;
import java.util.Arrays;
import org.gvsig.raster.lib.buffer.api.Band;
import org.gvsig.raster.lib.buffer.api.BandTileManager;
import org.gvsig.raster.lib.buffer.api.NoData;
import org.gvsig.raster.lib.buffer.impl.AbstractTiledBand;
import org.gvsig.raster.lib.buffer.impl.DefaultBandNotification;

public class TiledBandShort
extends AbstractTiledBand
implements Band.BandShort {
    public TiledBandShort(int rows, int columns, NoData noData, BandTileManager tileManager) {
        super(rows, columns, noData, tileManager);
        this.data = ShortBuffer.allocate(this.calculateBufferSizeToAllocate(rows, columns));
    }

    public int getDataType() {
        return 2;
    }

    @Override
    protected int getDataSize() {
        return 2;
    }

    public Object get(int row, int column) {
        return this.getValue(row, column);
    }

    @Override
    protected void doSet(int row, int column, Object value) {
        this.setValue(row, column, (Short)value);
    }

    @Override
    protected void doFill(Object value) {
        if ((value = this.nullValueToNoData(value)) == null) {
            value = 0;
        }
        for (int row = 0; row < this.rows; row += this.rowsInTile) {
            for (int column = 0; column < this.columns; column += this.columnsInTile) {
                this.loadTile(row, column);
                Arrays.fill((short[])this.data.array(), (Short)value);
            }
        }
    }

    public short getValue(int row, int column) {
        this.loadTile(row, column);
        return ((ShortBuffer)this.data).get((row - this.firstRowOfTile) * this.columnsInTile + (column - this.firstColumnOfTile));
    }

    public void setValue(int row, int column, short value) {
        this.doSetValue(row, column, value);
        this.notifyObservers((Object)new DefaultBandNotification("set_band_notification", new Object[]{row, column, value}));
    }

    protected void doSetValue(int row, int column, short value) {
        this.loadTile(row, column);
        ((ShortBuffer)this.data).put((row - this.firstRowOfTile) * this.columnsInTile + (column - this.firstColumnOfTile), value);
    }

    public short[] createRowBuffer() {
        return new short[this.getColumns()];
    }

    public void fetchRow(int row, Object rowBuffer) {
        short[] target = (short[])rowBuffer;
        for (int column = 0; column < this.columns; column += this.columnsInTile) {
            this.loadTile(row, column);
            short[] source = (short[])this.data.array();
            System.arraycopy(source, (row - this.firstRowOfTile) * this.columnsInTile, target, column, this.columnsInTile);
        }
    }

    @Override
    protected void doPutRow(int row, Object rowBuffer) {
        short[] source = (short[])rowBuffer;
        for (int column = 0; column < this.columns; column += this.columnsInTile) {
            this.loadTile(row, column);
            short[] target = (short[])this.data.array();
            System.arraycopy(source, column, target, (row - this.firstRowOfTile) * this.columnsInTile, this.columnsInTile);
        }
    }
}

