/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.lib.buffer.impl.operations;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.raster.lib.buffer.api.BufferLocator;
import org.gvsig.raster.lib.buffer.api.OperationManager;
import org.gvsig.raster.lib.buffer.api.operations.Operation;
import org.gvsig.raster.lib.buffer.api.operations.OperationListEntry;
import org.gvsig.raster.lib.buffer.impl.operations.DefaultOperationList;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dynobject.DynClass;
import org.gvsig.tools.dynobject.DynField;
import org.gvsig.tools.dynobject.DynField_v2;
import org.gvsig.tools.dynobject.DynObject;
import org.gvsig.tools.dynobject.DynStruct;
import org.gvsig.tools.dynobject.impl.DefaultDynObjectManager;
import org.gvsig.tools.persistence.PersistenceManager;
import org.gvsig.tools.persistence.PersistentState;
import org.gvsig.tools.persistence.exception.PersistenceException;

public class DefaultOperationListEntry
implements OperationListEntry {
    public static final String PERSISTENT_NAME = "OperationListEntryPersistence";
    public static final String PERSISTENT_DESCRIPTION = "Persistence definition of operation list entry";
    private static final String OPERATION_PERSISTENCE_FIELD = "operations";
    private static final String PARAMETERS_PERSISTENCE_FIELD = "parameters";
    private static final String IS_ACTIVE_PERSISTENCE_FIELD = "active";
    private Operation operation;
    private DynObject parameters;
    private boolean active;
    private Map<String, String> lookupParameters;

    public DefaultOperationListEntry(Operation operation, DynObject parameters) {
        this.operation = operation;
        this.parameters = parameters;
        this.active = true;
    }

    public Operation getOperation() {
        return this.operation;
    }

    public DynObject getParameters() {
        return this.parameters;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public void saveToState(PersistentState state) throws PersistenceException {
        state.set(OPERATION_PERSISTENCE_FIELD, this.getOperation().getFactory().getName());
        state.set(PARAMETERS_PERSISTENCE_FIELD, (Object)this.getParameters());
        state.set(IS_ACTIVE_PERSISTENCE_FIELD, this.isActive());
    }

    public void loadFromState(PersistentState state) throws PersistenceException {
        OperationManager operationManager = BufferLocator.getOperationManager();
        String name = state.getString(OPERATION_PERSISTENCE_FIELD);
        this.operation = operationManager.createOperation(name);
        this.parameters = (DynObject)state.get(PARAMETERS_PERSISTENCE_FIELD);
        operationManager.createOperationListEntry(this.operation, this.parameters);
        this.active = (Boolean)state.get(IS_ACTIVE_PERSISTENCE_FIELD);
    }

    public static void registerPersistence() {
        PersistenceManager manager = ToolsLocator.getPersistenceManager();
        DynStruct definition = manager.getDefinition(PERSISTENT_NAME);
        if (definition == null) {
            definition = manager.addDefinition(DefaultOperationList.class, PERSISTENT_NAME, PERSISTENT_DESCRIPTION, null, null);
            definition.addDynFieldString(OPERATION_PERSISTENCE_FIELD).setMandatory(true);
            definition.addDynField(PARAMETERS_PERSISTENCE_FIELD).setMandatory(true).setClassOfValue(DynObject.class);
            definition.addDynFieldBoolean(IS_ACTIVE_PERSISTENCE_FIELD).setMandatory(false).setDefaultFieldValue((Object)true);
        }
    }

    public String getLookpupParameterName(String name) {
        return this.getLookupParameters().get(name);
    }

    public Map<String, String> getLookupParameters() {
        if (this.lookupParameters == null) {
            this.lookupParameters = new HashMap<String, String>();
            DynClass paramsDefinition = this.parameters.getDynClass();
            DynField[] fields = paramsDefinition.getDynFields();
            for (int i = 0; i < fields.length; ++i) {
                DynField_v2 field = (DynField_v2)fields[i];
                String name = (String)field.getTags().get("lookupParameter");
                if (StringUtils.isEmpty((CharSequence)name)) continue;
                this.lookupParameters.put(field.getName(), name);
            }
        }
        return this.lookupParameters;
    }

    public Object clone() throws CloneNotSupportedException {
        DynClass dynClass = this.parameters.getDynClass();
        DynObject clonedParameters = DefaultDynObjectManager.getManager().createDynObject((DynStruct)dynClass);
        DynField[] dynFields = dynClass.getDynFields();
        for (int i = 0; i < dynFields.length; ++i) {
            String name = dynFields[i].getName();
            clonedParameters.setDynValue(name, this.parameters.getDynValue(name));
        }
        DefaultOperationListEntry cloned = new DefaultOperationListEntry(this.operation.getFactory().create(), clonedParameters);
        cloned.setActive(this.isActive());
        return cloned;
    }
}

