/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.lib.buffer.impl.operations.edgedetection.firstderivative;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.gvsig.fmap.geom.exception.CreateEnvelopeException;
import org.gvsig.raster.lib.buffer.api.Band;
import org.gvsig.raster.lib.buffer.api.BufferLocator;
import org.gvsig.raster.lib.buffer.api.BufferManager;
import org.gvsig.raster.lib.buffer.api.Kernel;
import org.gvsig.raster.lib.buffer.api.NoData;
import org.gvsig.raster.lib.buffer.api.exceptions.BandException;
import org.gvsig.raster.lib.buffer.api.exceptions.BufferException;
import org.gvsig.raster.lib.buffer.api.exceptions.BufferOperationException;
import org.gvsig.raster.lib.buffer.api.operations.OperationFactory;
import org.gvsig.raster.lib.buffer.spi.exceptions.ProcessingOperationException;
import org.gvsig.raster.lib.buffer.spi.operations.AbstractSpecifiedBandsOperation;
import org.gvsig.tools.locator.LocatorException;

public class FirstDerivativeOperation
extends AbstractSpecifiedBandsOperation {
    public static final String SOBEL_OPERATOR_STRING = "SOBEL";
    public static final String ROBERTS_OPERATOR_STRING = "ROBERTS";
    public static final String PREWITT_OPERATOR_STRING = "PREWITT";
    public static final String FREICHEN_OPERATOR_STRING = "FREICHEN";
    public static String OPERATOR_PARAM = "operator";
    public static String UMBRAL_PARAM = "umbral";
    public static String COMPARE_PARAM = "compare";
    private String operator;
    private int umbral;
    private boolean compare;
    private RowProcessor[] rowProcessors;
    private Kernel operatorH;
    private Kernel operatorV;
    private static final int SIDE_WINDOW = 3;
    private static final int HALF_SIDE_WINDOW = 1;
    static final double[][] sobelH = new double[][]{{-1.0, 0.0, 1.0}, {-2.0, 0.0, 2.0}, {-1.0, 0.0, 1.0}};
    static final double[][] sobelV = new double[][]{{-1.0, -2.0, -1.0}, {0.0, 0.0, 0.0}, {1.0, 2.0, 1.0}};
    static final double[][] robertsH = new double[][]{{0.0, 0.0, -1.0}, {0.0, 1.0, 0.0}, {0.0, 0.0, 0.0}};
    static final double[][] robertsV = new double[][]{{-1.0, 0.0, 0.0}, {0.0, 1.0, 0.0}, {0.0, 0.0, 0.0}};
    static final double[][] prewittH = new double[][]{{1.0, 0.0, -1.0}, {1.0, 0.0, -1.0}, {1.0, 0.0, -1.0}};
    static final double[][] prewittV = new double[][]{{-1.0, -1.0, -1.0}, {0.0, 0.0, 0.0}, {1.0, 1.0, 1.0}};
    static final double sqr2 = Math.sqrt(2.0);
    static final double[][] freiChenH = new double[][]{{-1.0, -1.4, -1.0}, {0.0, 0.0, 0.0}, {1.0, 1.4, 1.0}};
    static final double[][] freiChenV = new double[][]{{-1.0, 0.0, 1.0}, {-1.4, 0.0, 1.4}, {-1.0, 0.0, 1.0}};

    public FirstDerivativeOperation(OperationFactory factory) {
        super(factory);
    }

    public void preProcess() throws BufferOperationException {
        super.preProcess();
        BufferManager manager = BufferLocator.getBufferManager();
        switch (this.operator = (String)this.getParameter(OPERATOR_PARAM, SOBEL_OPERATOR_STRING)) {
            case "SOBEL": {
                this.operatorH = manager.createKernel(sobelH);
                this.operatorV = manager.createKernel(sobelV);
                break;
            }
            case "ROBERTS": {
                this.operatorH = manager.createKernel(robertsH);
                this.operatorV = manager.createKernel(robertsV);
                break;
            }
            case "PREWITT": {
                this.operatorH = manager.createKernel(prewittH);
                this.operatorV = manager.createKernel(prewittV);
                break;
            }
            case "FREICHEN": {
                this.operatorH = manager.createKernel(freiChenH);
                this.operatorV = manager.createKernel(freiChenV);
            }
        }
        this.compare = (Boolean)this.getParameter(COMPARE_PARAM, false);
        this.umbral = (Integer)this.getParameter(UMBRAL_PARAM, 0);
        int bands = this.getInputBuffer().getBandCount();
        NoData[] noData = this.getInputBuffer().getBandNoData();
        if (this.mustCopyUnprocessedBands()) {
            try {
                this.setOutputBuffer(manager.createBuffer(this.getInputBuffer().getRows(), this.getInputBuffer().getColumns(), this.getInputBuffer().getBandTypes(), this.getInputBuffer().getBandNoData(), this.getInputBuffer().getProjection(), this.getInputBuffer().getEnvelope()));
            }
            catch (CreateEnvelopeException | BufferException | LocatorException e) {
                throw new ProcessingOperationException(e);
            }
        }
        try {
            this.setOutputBuffer(manager.createBuffer(this.getInputBuffer().getRows(), this.getInputBuffer().getColumns(), this.getProcessableBandTypesAsArray(), this.getProcessableBandNoDatasAsArray(), this.getInputBuffer().getProjection(), this.getInputBuffer().getEnvelope()));
        }
        catch (CreateEnvelopeException | BufferException | LocatorException e) {
            throw new ProcessingOperationException(e);
        }
        this.rowProcessors = new RowProcessor[bands];
        block24: for (int band = 0; band < noData.length; ++band) {
            if (!this.isProcessableBand(band)) continue;
            int bandType = this.getInputBuffer().getBand(band).getDataType();
            switch (bandType) {
                case 0: {
                    this.rowProcessors[band] = new ByteRowProcessor(band);
                    continue block24;
                }
                case 1: {
                    this.rowProcessors[band] = new UShortRowProcessor(band);
                    continue block24;
                }
                case 2: {
                    this.rowProcessors[band] = new ShortRowProcessor(band);
                    continue block24;
                }
                case 3: {
                    this.rowProcessors[band] = new IntRowProcessor(band);
                    continue block24;
                }
                case 4: {
                    this.rowProcessors[band] = new FloatRowProcessor(band);
                    continue block24;
                }
                case 5: {
                    this.rowProcessors[band] = new DoubleRowProcessor(band);
                    continue block24;
                }
                default: {
                    throw new IllegalArgumentException("Unknow type of band '" + band + "'");
                }
            }
        }
    }

    public void process() throws ProcessingOperationException {
        super.process();
        for (int band = 0; band < this.getInputBuffer().getBandCount(); ++band) {
            if (this.getBandsToProcess().contains(band)) {
                Band bufferBand = this.getInputBuffer().getBand(band);
                Band outputBufferBand = this.getOutputBuffer().getBand(band);
                for (int row = 0; row < this.getInputBuffer().getRows(); ++row) {
                    Object rowBuffer = bufferBand.createRowBuffer();
                    bufferBand.fetchRow(row, rowBuffer);
                    ArrayList<Object> bundle = new ArrayList<Object>();
                    if (row - 1 >= 0 && row + 1 < this.getInputBuffer().getRows()) {
                        for (int r = Math.max(row - 1, 0); r <= Math.min(row + 1, this.getInputBuffer().getRows() - 1); ++r) {
                            Object bundleRow = bufferBand.createRowBuffer();
                            bufferBand.fetchRow(r, bundleRow);
                            bundle.add(bundleRow);
                        }
                        Object outputRowBuffer = outputBufferBand.createRowBuffer();
                        this.rowProcessors[band].processRow(rowBuffer, bundle, outputRowBuffer);
                        outputBufferBand.putRow(row, outputRowBuffer);
                        continue;
                    }
                    if (this.getInputBuffer().getBandTypes()[band] != 0) continue;
                    outputBufferBand.putRow(row, rowBuffer);
                }
                continue;
            }
            if (!this.mustCopyUnprocessedBands()) continue;
            try {
                this.getOutputBuffer().getBand(band).copyFrom(this.getInputBuffer().getBand(band));
                continue;
            }
            catch (BandException e) {
                throw new ProcessingOperationException((Throwable)e);
            }
        }
    }

    public void postProcess() throws BufferOperationException {
        super.postProcess();
    }

    private class DoubleRowProcessor
    extends AbstractRowProcessor {
        public DoubleRowProcessor(int band) {
            super(band);
        }

        @Override
        public void processRow(Object inputRow, List<Object> bundleRow, Object outputRow) {
            Number[] inputDoubleRow = (Number[])inputRow;
            byte[] outputByteRow = (byte[])outputRow;
            for (int i = 0; i < inputDoubleRow.length; ++i) {
                if (i - 1 >= 0 && i + 1 < inputDoubleRow.length) {
                    double[][] k = new double[3][3];
                    int r = 0;
                    int c = 0;
                    for (double[] dArray : bundleRow) {
                        for (int column = Math.max(i - 1, 0); column <= Math.min(i + 1, inputDoubleRow.length - 1); ++column) {
                            Double value = dArray[c];
                            k[r][c] = this.noData.isDefined() && this.noData.getValue().equals(value) ? 0.0 : value;
                        }
                    }
                    Kernel kernel = BufferLocator.getBufferManager().createKernel(k);
                    outputByteRow[i] = this.processValue(kernel).byteValue();
                    continue;
                }
                outputByteRow[i] = ((Double)inputDoubleRow[i]).byteValue();
            }
        }
    }

    private class FloatRowProcessor
    extends AbstractRowProcessor {
        public FloatRowProcessor(int band) {
            super(band);
        }

        @Override
        public void processRow(Object inputRow, List<Object> bundleRow, Object outputRow) {
            Number[] inputFloatRow = (Number[])inputRow;
            byte[] outputByteRow = (byte[])outputRow;
            for (int i = 0; i < inputFloatRow.length; ++i) {
                if (i - 1 >= 0 && i + 1 < inputFloatRow.length) {
                    double[][] k = new double[3][3];
                    int r = 0;
                    int c = 0;
                    for (float[] fArray : bundleRow) {
                        for (int column = Math.max(i - 1, 0); column <= Math.min(i + 1, inputFloatRow.length - 1); ++column) {
                            Float value = Float.valueOf(Float.valueOf(fArray[c]).floatValue());
                            k[r][c] = this.noData.isDefined() && this.noData.getValue().equals(value) ? 0.0 : (double)value.floatValue();
                        }
                    }
                    Kernel kernel = BufferLocator.getBufferManager().createKernel(k);
                    outputByteRow[i] = this.processValue(kernel).byteValue();
                    continue;
                }
                outputByteRow[i] = ((Float)inputFloatRow[i]).byteValue();
            }
        }
    }

    private class IntRowProcessor
    extends AbstractRowProcessor {
        public IntRowProcessor(int band) {
            super(band);
        }

        @Override
        public void processRow(Object inputRow, List<Object> bundleRow, Object outputRow) {
            Number[] inputIntRow = (Number[])inputRow;
            byte[] outputByteRow = (byte[])outputRow;
            for (int i = 0; i < inputIntRow.length; ++i) {
                if (i - 1 >= 0 && i + 1 < inputIntRow.length) {
                    double[][] k = new double[3][3];
                    int r = 0;
                    int c = 0;
                    for (int[] nArray : bundleRow) {
                        for (int column = Math.max(i - 1, 0); column <= Math.min(i + 1, inputIntRow.length - 1); ++column) {
                            double value = Integer.valueOf(nArray[c]).intValue();
                            k[r][c] = this.noData.isDefined() && this.noData.getValue().equals(value) ? 0.0 : value;
                        }
                    }
                    Kernel kernel = BufferLocator.getBufferManager().createKernel(k);
                    outputByteRow[i] = this.processValue(kernel).byteValue();
                    continue;
                }
                outputByteRow[i] = ((Integer)inputIntRow[i]).byteValue();
            }
        }
    }

    private class UShortRowProcessor
    extends AbstractRowProcessor {
        public UShortRowProcessor(int band) {
            super(band);
        }

        @Override
        public void processRow(Object inputRow, List<Object> bundleRow, Object outputRow) {
            Number[] inputShortRow = (Number[])inputRow;
            byte[] outputByteRow = (byte[])outputRow;
            for (int i = 0; i < inputShortRow.length; ++i) {
                if (i - 1 >= 0 && i + 1 < inputShortRow.length) {
                    double[][] k = new double[3][3];
                    int r = 0;
                    int c = 0;
                    for (short[] sArray : bundleRow) {
                        for (int column = Math.max(i - 1, 0); column <= Math.min(i + 1, inputShortRow.length - 1); ++column) {
                            double value = 0xFFFF & Short.valueOf(sArray[c]);
                            k[r][c] = this.noData.isDefined() && this.noData.getValue().equals(value) ? 0.0 : value;
                        }
                    }
                    Kernel kernel = BufferLocator.getBufferManager().createKernel(k);
                    outputByteRow[i] = this.processValue(kernel).byteValue();
                    continue;
                }
                outputByteRow[i] = ((Short)inputShortRow[i]).byteValue();
            }
        }
    }

    private class ShortRowProcessor
    extends AbstractRowProcessor {
        public ShortRowProcessor(int band) {
            super(band);
        }

        @Override
        public void processRow(Object inputRow, List<Object> bundleRow, Object outputRow) {
            Number[] inputShortRow = (Number[])inputRow;
            byte[] outputByteRow = (byte[])outputRow;
            for (int i = 0; i < inputShortRow.length; ++i) {
                if (i - 1 >= 0 && i + 1 < inputShortRow.length) {
                    double[][] k = new double[3][3];
                    int r = 0;
                    int c = 0;
                    for (short[] sArray : bundleRow) {
                        for (int column = Math.max(i - 1, 0); column <= Math.min(i + 1, inputShortRow.length - 1); ++column) {
                            double value = Short.valueOf(sArray[c]).shortValue();
                            k[r][c] = this.noData.isDefined() && this.noData.getValue().equals(value) ? 0.0 : value;
                        }
                    }
                    Kernel kernel = BufferLocator.getBufferManager().createKernel(k);
                    outputByteRow[i] = this.processValue(kernel).byteValue();
                    continue;
                }
                outputByteRow[i] = ((Short)inputShortRow[i]).byteValue();
            }
        }
    }

    private class ByteRowProcessor
    extends AbstractRowProcessor {
        public ByteRowProcessor(int band) {
            super(band);
        }

        @Override
        public void processRow(Object inputRow, List<Object> bundleRow, Object outputRow) {
            byte[] inputByteRow = (byte[])inputRow;
            byte[] outputByteRow = (byte[])outputRow;
            for (int i = 0; i < inputByteRow.length; ++i) {
                if (i - 1 >= 0 && i + 1 < inputByteRow.length) {
                    double[][] k = new double[3][3];
                    int r = 0;
                    Iterator<Object> iterator = bundleRow.iterator();
                    while (iterator.hasNext()) {
                        int c = 0;
                        byte[] row = (byte[])iterator.next();
                        for (int column = Math.max(i - 1, 0); column <= Math.min(i + 1, inputByteRow.length - 1); ++column) {
                            byte value = row[column];
                            k[r][c] = this.noData.isDefined() && this.noData.getValue().equals(value) ? 0.0 : (double)(0xFF & value);
                            ++c;
                        }
                        ++r;
                    }
                    Kernel kernel = BufferLocator.getBufferManager().createKernel(k);
                    if (this.noData.isDefined() && this.noData.getValue().equals(inputByteRow[i])) {
                        outputByteRow[i] = inputByteRow[i];
                        continue;
                    }
                    outputByteRow[i] = this.processValue(kernel).byteValue();
                    continue;
                }
                outputByteRow[i] = inputByteRow[i];
            }
        }
    }

    private abstract class AbstractRowProcessor
    implements RowProcessor {
        int band;
        NoData noData;

        public AbstractRowProcessor(int band) {
            this.band = band;
            this.noData = FirstDerivativeOperation.this.getInputBuffer().getBand(band).getNoData();
        }

        @Override
        public Number processValue(Kernel kernel) {
            int[] convoResult = new int[4];
            convoResult[0] = (int)FirstDerivativeOperation.this.operatorH.convolution(kernel);
            convoResult[1] = (int)FirstDerivativeOperation.this.operatorV.convolution(kernel);
            int out = FirstDerivativeOperation.this.compare ? (convoResult[0] > convoResult[1] ? convoResult[0] : convoResult[1]) : (int)Math.sqrt(Math.pow(convoResult[0], 2.0) + Math.pow(convoResult[1], 2.0));
            if (FirstDerivativeOperation.this.umbral > 0) {
                out = out >= 255 - FirstDerivativeOperation.this.umbral ? 255 : 0;
            } else if (out < 0) {
                out = 0;
            } else if (out > 255) {
                out = 255;
            }
            return (byte)out;
        }
    }

    static interface RowProcessor {
        public void processRow(Object var1, List<Object> var2, Object var3);

        public Number processValue(Kernel var1);
    }
}

