/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.lib.buffer.impl.operations.linearstretchenhancement;

import org.gvsig.fmap.geom.exception.CreateEnvelopeException;
import org.gvsig.raster.lib.buffer.api.Band;
import org.gvsig.raster.lib.buffer.api.BufferLocator;
import org.gvsig.raster.lib.buffer.api.BufferManager;
import org.gvsig.raster.lib.buffer.api.NoData;
import org.gvsig.raster.lib.buffer.api.exceptions.BandException;
import org.gvsig.raster.lib.buffer.api.exceptions.BufferException;
import org.gvsig.raster.lib.buffer.api.exceptions.BufferOperationException;
import org.gvsig.raster.lib.buffer.api.operations.OperationFactory;
import org.gvsig.raster.lib.buffer.api.statistics.Statistics;
import org.gvsig.raster.lib.buffer.impl.DefaultNoData;
import org.gvsig.raster.lib.buffer.spi.exceptions.ProcessingOperationException;
import org.gvsig.raster.lib.buffer.spi.operations.AbstractSpecifiedBandsOperation;
import org.gvsig.tools.locator.LocatorException;

public class LinearStretchEnhancementOperation
extends AbstractSpecifiedBandsOperation {
    public static String STATISTICS_PARAM = "statistics";
    public static String REMOVE_ENDS_PARAM = "remove_ends";
    public static String TAIL_TRIM_PARAM = "tail_trim";
    public static String TAIL_TRIM_PERCENT_PARAM = "tail_trim_percent";
    private Statistics statistics;
    private boolean removeEnds;
    private boolean tailTrim;
    private double tailTrimPercent;
    private RowProcessor[] rowProcessors;

    public LinearStretchEnhancementOperation(OperationFactory factory) {
        super(factory);
    }

    public void preProcess() throws BufferOperationException {
        super.preProcess();
        BufferManager manager = BufferLocator.getBufferManager();
        this.statistics = (Statistics)this.getParameter(STATISTICS_PARAM, null);
        if (this.statistics == null) {
            this.statistics = this.getInputBuffer().getStatistics(null);
        }
        this.removeEnds = (Boolean)this.getParameter(REMOVE_ENDS_PARAM, false);
        this.tailTrim = (Boolean)this.getParameter(TAIL_TRIM_PARAM, false);
        this.tailTrimPercent = (Double)this.getParameter(TAIL_TRIM_PERCENT_PARAM, 0);
        this.tailTrimPercent = this.tailTrimPercent > 100.0 ? 100.0 : this.tailTrimPercent;
        this.tailTrimPercent = this.tailTrimPercent < 0.0 ? 0.0 : this.tailTrimPercent;
        int bands = this.getInputBuffer().getBandCount();
        this.rowProcessors = new RowProcessor[bands];
        int[] bandTypes = new int[bands];
        for (int i = 0; i < bandTypes.length; ++i) {
            bandTypes[i] = this.getBandsToProcess().contains(i) ? 0 : this.getInputBuffer().getBandTypes()[i];
        }
        NoData[] noData = this.getInputBuffer().getBandNoData();
        NoData[] resultNoData = new NoData[noData.length];
        for (int band = 0; band < noData.length; ++band) {
            int bandType = this.getInputBuffer().getBand(band).getDataType();
            switch (bandType) {
                case 0: {
                    this.rowProcessors[band] = new ByteRowProcessor(band);
                    break;
                }
                case 1: {
                    this.rowProcessors[band] = new UShortRowProcessor(band);
                    break;
                }
                case 2: {
                    this.rowProcessors[band] = new ShortRowProcessor(band);
                    break;
                }
                case 3: {
                    this.rowProcessors[band] = new IntRowProcessor(band);
                    break;
                }
                case 4: {
                    this.rowProcessors[band] = new FloatRowProcessor(band);
                    break;
                }
                case 5: {
                    this.rowProcessors[band] = new DoubleRowProcessor(band);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknow type of band '" + band + "'");
                }
            }
            if (noData[band].isDefined()) {
                resultNoData[band] = new DefaultNoData((byte)0);
                resultNoData[band] = manager.createNoData((Number)0, (Number)0);
                continue;
            }
            resultNoData[band] = manager.createNoData(null, null);
        }
        try {
            this.setOutputBuffer(manager.createBuffer(this.getInputBuffer().getRows(), this.getInputBuffer().getColumns(), bandTypes, resultNoData, this.getInputBuffer().getProjection(), this.getInputBuffer().getEnvelope()));
        }
        catch (CreateEnvelopeException | BufferException | LocatorException e) {
            throw new ProcessingOperationException(e);
        }
    }

    public void process() throws ProcessingOperationException {
        super.process();
        int bandCount = this.getInputBuffer().getBandCount();
        int rowCount = this.getInputBuffer().getRows();
        for (int band = 0; band < bandCount; ++band) {
            if (this.getBandsToProcess().contains(band)) {
                this.getTaskStatus().setRangeOfValues(0L, (long)rowCount);
                this.getTaskStatus().setCurValue(0L);
                this.getTaskStatus().message("LinearStretch band " + band + "/" + bandCount);
                Band bufferBand = this.getInputBuffer().getBand(band);
                Band outputBufferBand = this.getOutputBuffer().getBand(band);
                for (int row = 0; row < rowCount; ++row) {
                    this.getTaskStatus().setCurValue((long)row);
                    Object rowBuffer = bufferBand.createRowBuffer();
                    bufferBand.fetchRow(row, rowBuffer);
                    Object outputRowBuffer = outputBufferBand.createRowBuffer();
                    outputBufferBand.fetchRow(row, outputRowBuffer);
                    this.rowProcessors[band].processRow(rowBuffer, outputRowBuffer);
                    outputBufferBand.putRow(row, outputRowBuffer);
                }
                continue;
            }
            try {
                this.getOutputBuffer().getBand(band).copyFrom(this.getInputBuffer().getBand(band));
                continue;
            }
            catch (BandException e) {
                throw new ProcessingOperationException((Throwable)e);
            }
        }
        this.getTaskStatus().terminate();
    }

    public void postProcess() throws BufferOperationException {
        super.postProcess();
    }

    private class DoubleRowProcessor
    extends AbstractRowProcessor {
        public DoubleRowProcessor(int band) {
            super(band);
        }

        @Override
        public void processRow(Object inputRow, Object outputRow) {
            double[] inputByteRow = (double[])inputRow;
            byte[] outputByteRow = (byte[])outputRow;
            for (int i = 0; i < inputByteRow.length; ++i) {
                outputByteRow[i] = this.processValue(inputByteRow[i]);
            }
        }

        @Override
        public byte processValue(Object value) {
            double result;
            if (this.noData.isDefined() && this.noData.getValue().equals(value)) {
                return 0;
            }
            Double dValue = ((Number)value).doubleValue();
            if (dValue < this.minValue) {
                result = this.minResult;
            } else if (dValue > this.maxValue) {
                result = this.maxResult;
            } else {
                double ratio = (this.maxResult - this.minResult) / (this.maxValue - this.minValue);
                result = (dValue - this.minValue) * ratio + this.minResult;
            }
            return (byte)result;
        }
    }

    private class FloatRowProcessor
    extends AbstractRowProcessor {
        public FloatRowProcessor(int band) {
            super(band);
        }

        @Override
        public void processRow(Object inputRow, Object outputRow) {
            float[] inputByteRow = (float[])inputRow;
            byte[] outputByteRow = (byte[])outputRow;
            for (int i = 0; i < inputByteRow.length; ++i) {
                outputByteRow[i] = this.processValue(Float.valueOf(inputByteRow[i]));
            }
        }

        @Override
        public byte processValue(Object value) {
            double result;
            if (this.noData.isDefined() && this.noData.getValue().equals(value)) {
                return 0;
            }
            Double dValue = ((Number)value).doubleValue();
            if (dValue < this.minValue) {
                result = this.minResult;
            } else if (dValue > this.maxValue) {
                result = this.maxResult;
            } else {
                double ratio = (this.maxResult - this.minResult) / (this.maxValue - this.minValue);
                result = (dValue - this.minValue) * ratio + this.minResult;
            }
            return (byte)result;
        }
    }

    private class IntRowProcessor
    extends AbstractRowProcessor {
        public IntRowProcessor(int band) {
            super(band);
        }

        @Override
        public void processRow(Object inputRow, Object outputRow) {
            int[] inputByteRow = (int[])inputRow;
            byte[] outputByteRow = (byte[])outputRow;
            for (int i = 0; i < inputByteRow.length; ++i) {
                outputByteRow[i] = this.processValue(inputByteRow[i]);
            }
        }

        @Override
        public byte processValue(Object value) {
            double result;
            if (this.noData.isDefined() && this.noData.getValue().equals(value)) {
                return 0;
            }
            Double dValue = ((Number)value).doubleValue();
            if (dValue < this.minValue) {
                result = this.minResult;
            } else if (dValue > this.maxValue) {
                result = this.maxResult;
            } else {
                double ratio = (this.maxResult - this.minResult) / (this.maxValue - this.minValue);
                result = (dValue - this.minValue) * ratio + this.minResult;
            }
            return (byte)result;
        }
    }

    private class UShortRowProcessor
    extends AbstractRowProcessor {
        public UShortRowProcessor(int band) {
            super(band);
        }

        @Override
        public void processRow(Object inputRow, Object outputRow) {
            short[] inputByteRow = (short[])inputRow;
            byte[] outputByteRow = (byte[])outputRow;
            for (int i = 0; i < inputByteRow.length; ++i) {
                outputByteRow[i] = this.processValue(inputByteRow[i]);
            }
        }

        @Override
        public byte processValue(Object value) {
            double result;
            if (this.noData.isDefined() && this.noData.getValue().equals(value)) {
                return 0;
            }
            int iValue = 0xFFFF & (Short)value;
            Double dValue = ((Number)iValue).doubleValue();
            if (dValue < this.minValue) {
                result = this.minResult;
            } else if (dValue > this.maxValue) {
                result = this.maxResult;
            } else {
                double ratio = (this.maxResult - this.minResult) / (this.maxValue - this.minValue);
                result = (dValue - this.minValue) * ratio + this.minResult;
            }
            return (byte)result;
        }
    }

    private class ShortRowProcessor
    extends AbstractRowProcessor {
        public ShortRowProcessor(int band) {
            super(band);
        }

        @Override
        public void processRow(Object inputRow, Object outputRow) {
            short[] inputByteRow = (short[])inputRow;
            byte[] outputByteRow = (byte[])outputRow;
            for (int i = 0; i < inputByteRow.length; ++i) {
                outputByteRow[i] = this.processValue(inputByteRow[i]);
            }
        }

        @Override
        public byte processValue(Object value) {
            double result;
            if (this.noData.isDefined() && this.noData.getValue().equals(value)) {
                return 0;
            }
            short iValue = (Short)value;
            Double dValue = ((Number)Integer.valueOf(iValue)).doubleValue();
            if (dValue < this.minValue) {
                result = this.minResult;
            } else if (dValue > this.maxValue) {
                result = this.maxResult;
            } else {
                double ratio = (this.maxResult - this.minResult) / (this.maxValue - this.minValue);
                result = (dValue - this.minValue) * ratio + this.minResult;
            }
            return (byte)result;
        }
    }

    private class ByteRowProcessor
    extends AbstractRowProcessor {
        public ByteRowProcessor(int band) {
            super(band);
        }

        @Override
        public void processRow(Object inputRow, Object outputRow) {
            byte[] inputByteRow = (byte[])inputRow;
            byte[] outputByteRow = (byte[])outputRow;
            for (int i = 0; i < inputByteRow.length; ++i) {
                outputByteRow[i] = this.processValue(inputByteRow[i]);
            }
        }

        @Override
        public byte processValue(Object value) {
            double result;
            if (this.noData.isDefined() && this.noData.getValue().equals(value)) {
                return 0;
            }
            int iValue = 0xFF & (Byte)value;
            Double dValue = new Double(iValue);
            if (dValue < this.minValue) {
                result = this.minResult;
            } else if (dValue > this.maxValue) {
                result = this.maxResult;
            } else {
                double ratio = (this.maxResult - this.minResult) / (this.maxValue - this.minValue);
                result = (dValue - this.minValue) * ratio + this.minResult;
            }
            return (byte)result;
        }
    }

    private abstract class AbstractRowProcessor
    implements RowProcessor {
        int band;
        double minValue;
        double maxValue;
        double maxResult = 255.0;
        double minResult = 0.0;
        NoData noData;

        public AbstractRowProcessor(int band) {
            this.band = band;
            this.noData = LinearStretchEnhancementOperation.this.getInputBuffer().getBand(band).getNoData();
            if (this.noData.isDefined()) {
                this.minResult = 1.0;
            }
            this.minValue = LinearStretchEnhancementOperation.this.statistics.getMin()[band];
            this.maxValue = LinearStretchEnhancementOperation.this.statistics.getMax()[band];
            if (LinearStretchEnhancementOperation.this.removeEnds) {
                this.minValue = LinearStretchEnhancementOperation.this.statistics.getSecondMin()[band];
                this.maxValue = LinearStretchEnhancementOperation.this.statistics.getSecondMax()[band];
            }
            if (LinearStretchEnhancementOperation.this.tailTrim) {
                double[][] tailTrim = LinearStretchEnhancementOperation.this.statistics.getTailTrimValue(LinearStretchEnhancementOperation.this.tailTrimPercent);
                this.minValue = tailTrim[band][0];
                this.maxValue = tailTrim[band][1];
            }
        }
    }

    static interface RowProcessor {
        public void processRow(Object var1, Object var2);

        public byte processValue(Object var1);
    }
}

