/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.lib.buffer.impl.operations.mode;

import java.util.ArrayList;
import java.util.List;
import org.gvsig.raster.lib.buffer.api.Band;
import org.gvsig.raster.lib.buffer.api.BufferLocator;
import org.gvsig.raster.lib.buffer.api.BufferManager;
import org.gvsig.raster.lib.buffer.api.NoData;
import org.gvsig.raster.lib.buffer.api.exceptions.BandException;
import org.gvsig.raster.lib.buffer.api.exceptions.BufferOperationException;
import org.gvsig.raster.lib.buffer.api.operations.OperationFactory;
import org.gvsig.raster.lib.buffer.api.statistics.Statistics;
import org.gvsig.raster.lib.buffer.spi.exceptions.ProcessingOperationException;
import org.gvsig.raster.lib.buffer.spi.operations.AbstractSpecifiedBandsOperation;

public class ModeOperation
extends AbstractSpecifiedBandsOperation {
    public static String SIDE_WINDOW_PARAM = "side_window";
    private Statistics statistics;
    private int sideWindow;
    private RowProcessor[] rowProcessors;
    private int halfSideWindow;

    public ModeOperation(OperationFactory factory) {
        super(factory);
    }

    public void preProcess() throws BufferOperationException {
        super.preProcess();
        BufferManager manager = BufferLocator.getBufferManager();
        this.sideWindow = (Integer)this.getParameter(SIDE_WINDOW_PARAM, 3);
        this.halfSideWindow = this.sideWindow / 2;
        if (this.mustCopyUnprocessedBands()) {
            try {
                this.setOutputBuffer(manager.createBuffer(this.getInputBuffer().getRows(), this.getInputBuffer().getColumns(), this.getInputBuffer().getBandTypes(), this.getInputBuffer().getBandNoData(), this.getInputBuffer().getProjection(), this.getInputBuffer().getEnvelope()));
            }
            catch (Exception e) {
                throw new ProcessingOperationException((Throwable)e);
            }
        }
        try {
            this.setOutputBuffer(manager.createBuffer(this.getInputBuffer().getRows(), this.getInputBuffer().getColumns(), this.getProcessableBandTypesAsArray(), this.getProcessableBandNoDatasAsArray(), this.getInputBuffer().getProjection(), this.getInputBuffer().getEnvelope()));
        }
        catch (Exception e) {
            throw new ProcessingOperationException((Throwable)e);
        }
        int bands = this.getInputBuffer().getBandCount();
        this.rowProcessors = new RowProcessor[bands];
        block12: for (int band = 0; band < bands; ++band) {
            if (!this.isProcessableBand(band)) continue;
            int bandType = this.getInputBuffer().getBand(band).getDataType();
            switch (bandType) {
                case 0: {
                    this.rowProcessors[band] = new ByteRowProcessor(band);
                    continue block12;
                }
                case 1: {
                    this.rowProcessors[band] = new UShortRowProcessor(band);
                    continue block12;
                }
                case 2: {
                    this.rowProcessors[band] = new ShortRowProcessor(band);
                    continue block12;
                }
                case 3: {
                    this.rowProcessors[band] = new IntRowProcessor(band);
                    continue block12;
                }
                case 4: {
                    this.rowProcessors[band] = new FloatRowProcessor(band);
                    continue block12;
                }
                case 5: {
                    this.rowProcessors[band] = new DoubleRowProcessor(band);
                    continue block12;
                }
                default: {
                    throw new IllegalArgumentException("Unknow type of band '" + band + "'");
                }
            }
        }
    }

    public void process() throws ProcessingOperationException {
        super.process();
        for (int band = 0; band < this.getInputBuffer().getBandCount(); ++band) {
            if (this.getBandsToProcess().contains(band)) {
                Band bufferBand = this.getInputBuffer().getBand(band);
                Band outputBufferBand = this.getOutputBuffer().getBand(band);
                for (int row = 0; row < this.getInputBuffer().getRows(); ++row) {
                    Object rowBuffer = bufferBand.createRowBuffer();
                    bufferBand.fetchRow(row, rowBuffer);
                    ArrayList<Object> bundle = new ArrayList<Object>();
                    int maxr = Math.min(row + this.halfSideWindow, this.getInputBuffer().getRows() - 1);
                    for (int r = Math.max(row - this.halfSideWindow, 0); r <= maxr; ++r) {
                        Object bundleRow = bufferBand.createRowBuffer();
                        bufferBand.fetchRow(row, bundleRow);
                        bundle.add(bundleRow);
                    }
                    Object outputRowBuffer = outputBufferBand.createRowBuffer();
                    this.rowProcessors[band].processRow(rowBuffer, bundle, outputRowBuffer);
                    outputBufferBand.putRow(row, outputRowBuffer);
                }
                continue;
            }
            if (!this.mustCopyUnprocessedBands()) continue;
            try {
                this.getOutputBuffer().getBand(band).copyFrom(this.getInputBuffer().getBand(band));
                continue;
            }
            catch (BandException e) {
                throw new ProcessingOperationException((Throwable)e);
            }
        }
    }

    public void postProcess() throws BufferOperationException {
        super.postProcess();
    }

    private Number mode(Number value, List<Number> kernel) {
        Number maxValue = null;
        int maxCount = 0;
        Number[] kernelArray = kernel.toArray(new Number[0]);
        for (int i = 0; i < kernelArray.length; ++i) {
            int count = 0;
            for (int j = 0; j < kernelArray.length; ++j) {
                if (kernelArray[j] != kernelArray[i]) continue;
                ++count;
            }
            if (count <= maxCount) continue;
            maxCount = count;
            maxValue = kernelArray[i];
        }
        return maxValue;
    }

    private class DoubleRowProcessor
    extends AbstractRowProcessor {
        public DoubleRowProcessor(int band) {
            super(band);
        }

        @Override
        public void processRow(Object inputRow, List<Object> bundleRow, Object outputRow) {
            Number[] inputDoubleRow = (Number[])inputRow;
            double[] outputDoubleRow = (double[])outputRow;
            for (int i = 0; i < inputDoubleRow.length; ++i) {
                ArrayList<Number> kernel = new ArrayList<Number>();
                for (double[] dArray : bundleRow) {
                    for (int c = Math.max(i - ModeOperation.this.halfSideWindow, 0); c <= Math.min(i + ModeOperation.this.halfSideWindow, inputDoubleRow.length - 1); ++c) {
                        Double value = dArray[c];
                        if (this.noData.isDefined() && this.noData.getValue().equals(value)) continue;
                        kernel.add(value);
                        kernel.add(value);
                    }
                }
                outputDoubleRow[i] = this.processValue(inputDoubleRow[i], kernel).floatValue();
            }
        }

        @Override
        public Number processValue(Number value, List<Number> kernel) {
            if (this.noData.isDefined() && this.noData.getValue().equals(value)) {
                return (double)((Double)value);
            }
            return ModeOperation.this.mode(value, kernel).doubleValue();
        }
    }

    private class FloatRowProcessor
    extends AbstractRowProcessor {
        public FloatRowProcessor(int band) {
            super(band);
        }

        @Override
        public void processRow(Object inputRow, List<Object> bundleRow, Object outputRow) {
            Number[] inputFloatRow = (Number[])inputRow;
            float[] outputFloatRow = (float[])outputRow;
            for (int i = 0; i < inputFloatRow.length; ++i) {
                ArrayList<Number> kernel = new ArrayList<Number>();
                for (float[] fArray : bundleRow) {
                    for (int c = Math.max(i - ModeOperation.this.halfSideWindow, 0); c <= Math.min(i + ModeOperation.this.halfSideWindow, inputFloatRow.length - 1); ++c) {
                        Float value = Float.valueOf(Float.valueOf(fArray[c]).floatValue());
                        if (this.noData.isDefined() && this.noData.getValue().equals(value)) continue;
                        kernel.add(value);
                        kernel.add(value);
                    }
                }
                outputFloatRow[i] = this.processValue(inputFloatRow[i], kernel).floatValue();
            }
        }

        @Override
        public Number processValue(Number value, List<Number> kernel) {
            if (this.noData.isDefined() && this.noData.getValue().equals(value)) {
                return Float.valueOf(((Float)value).floatValue());
            }
            return Float.valueOf(ModeOperation.this.mode(value, kernel).floatValue());
        }
    }

    private class IntRowProcessor
    extends AbstractRowProcessor {
        public IntRowProcessor(int band) {
            super(band);
        }

        @Override
        public void processRow(Object inputRow, List<Object> bundleRow, Object outputRow) {
            Number[] inputIntRow = (Number[])inputRow;
            int[] outputIntRow = (int[])outputRow;
            for (int i = 0; i < inputIntRow.length; ++i) {
                ArrayList<Number> kernel = new ArrayList<Number>();
                for (int[] nArray : bundleRow) {
                    for (int c = Math.max(i - ModeOperation.this.halfSideWindow, 0); c <= Math.min(i + ModeOperation.this.halfSideWindow, inputIntRow.length - 1); ++c) {
                        Integer value = nArray[c];
                        if (this.noData.isDefined() && this.noData.getValue().equals(value)) continue;
                        kernel.add(value);
                        kernel.add(value);
                    }
                }
                outputIntRow[i] = this.processValue(inputIntRow[i], kernel).intValue();
            }
        }

        @Override
        public Number processValue(Number value, List<Number> kernel) {
            if (this.noData.isDefined() && this.noData.getValue().equals(value)) {
                return (int)((Integer)value);
            }
            return ModeOperation.this.mode(value, kernel).intValue();
        }
    }

    private class UShortRowProcessor
    extends AbstractRowProcessor {
        public UShortRowProcessor(int band) {
            super(band);
        }

        @Override
        public void processRow(Object inputRow, List<Object> bundleRow, Object outputRow) {
            Number[] inputShortRow = (Number[])inputRow;
            short[] outputShortRow = (short[])outputRow;
            for (int i = 0; i < inputShortRow.length; ++i) {
                ArrayList<Number> kernel = new ArrayList<Number>();
                for (short[] sArray : bundleRow) {
                    for (int c = Math.max(i - ModeOperation.this.halfSideWindow, 0); c <= Math.min(i + ModeOperation.this.halfSideWindow, inputShortRow.length - 1); ++c) {
                        Integer value = 0xFFFF & Short.valueOf(sArray[c]);
                        if (this.noData.isDefined() && this.noData.getValue().equals(value)) continue;
                        kernel.add(value);
                        kernel.add(value);
                    }
                }
                outputShortRow[i] = this.processValue(inputShortRow[i], kernel).shortValue();
            }
        }

        @Override
        public Number processValue(Number value, List<Number> kernel) {
            if (this.noData.isDefined() && this.noData.getValue().equals(value)) {
                return (short)((Short)value);
            }
            return (short)(ModeOperation.this.mode(value, kernel).intValue() & 0xFFFF);
        }
    }

    private class ShortRowProcessor
    extends AbstractRowProcessor {
        public ShortRowProcessor(int band) {
            super(band);
        }

        @Override
        public void processRow(Object inputRow, List<Object> bundleRow, Object outputRow) {
            Number[] inputShortRow = (Number[])inputRow;
            short[] outputShortRow = (short[])outputRow;
            for (int i = 0; i < inputShortRow.length; ++i) {
                ArrayList<Number> kernel = new ArrayList<Number>();
                for (short[] sArray : bundleRow) {
                    for (int c = Math.max(i - ModeOperation.this.halfSideWindow, 0); c <= Math.min(i + ModeOperation.this.halfSideWindow, inputShortRow.length - 1); ++c) {
                        Short value = sArray[c];
                        if (this.noData.isDefined() && this.noData.getValue().equals(value)) continue;
                        kernel.add(value);
                        kernel.add(value);
                    }
                }
                outputShortRow[i] = this.processValue(inputShortRow[i], kernel).shortValue();
            }
        }

        @Override
        public Number processValue(Number value, List<Number> kernel) {
            if (this.noData.isDefined() && this.noData.getValue().equals(value)) {
                return (short)((Short)value);
            }
            return (short)ModeOperation.this.mode(value, kernel).intValue();
        }
    }

    private class ByteRowProcessor
    extends AbstractRowProcessor {
        public ByteRowProcessor(int band) {
            super(band);
        }

        @Override
        public void processRow(Object inputRow, List<Object> bundleRow, Object outputRow) {
            byte[] inputByteRow = (byte[])inputRow;
            byte[] outputByteRow = (byte[])outputRow;
            for (int i = 0; i < inputByteRow.length; ++i) {
                ArrayList<Number> kernel = new ArrayList<Number>();
                for (byte[] byArray : bundleRow) {
                    for (int c = Math.max(i - ModeOperation.this.halfSideWindow, 0); c <= Math.min(i + ModeOperation.this.halfSideWindow, inputByteRow.length - 1); ++c) {
                        Integer value = 0xFF & Byte.valueOf(byArray[c]);
                        if (this.noData.isDefined() && this.noData.getValue().equals(value)) continue;
                        kernel.add(value);
                    }
                }
                outputByteRow[i] = this.processValue(inputByteRow[i], kernel).byteValue();
            }
        }

        @Override
        public Number processValue(Number value, List<Number> kernel) {
            if (this.noData.isDefined() && this.noData.getValue().equals(value)) {
                return (byte)((Byte)value);
            }
            return (byte)(ModeOperation.this.mode(value, kernel).intValue() & 0xFF);
        }
    }

    private abstract class AbstractRowProcessor
    implements RowProcessor {
        int band;
        NoData noData;

        public AbstractRowProcessor(int band) {
            this.band = band;
            this.noData = ModeOperation.this.getInputBuffer().getBand(band).getNoData();
        }
    }

    static interface RowProcessor {
        public void processRow(Object var1, List<Object> var2, Object var3);

        public Number processValue(Number var1, List<Number> var2);
    }
}

