/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.lib.buffer.impl.statistics;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.gvsig.fmap.mapcontext.MapContextLocator;
import org.gvsig.fmap.mapcontext.layers.LayerInformationBuilder;
import org.gvsig.raster.lib.buffer.api.Band;
import org.gvsig.raster.lib.buffer.api.BufferLocator;
import org.gvsig.raster.lib.buffer.api.BufferManager;
import org.gvsig.raster.lib.buffer.api.statistics.HistogramBand;
import org.gvsig.raster.lib.buffer.api.statistics.Statistics;
import org.gvsig.raster.lib.buffer.api.statistics.StatisticsBand;
import org.gvsig.raster.lib.buffer.impl.statistics.DefaultStatisticsBand;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.task.SimpleTaskStatus;

public class DefaultStatistics
implements Statistics {
    StatisticsBand[] statisticsBands;
    boolean calculated;
    double[][] varCov;

    private void init(List<Band> bands) {
        this.statisticsBands = new StatisticsBand[bands.size()];
        for (int i = 0; i < this.statisticsBands.length; ++i) {
            this.statisticsBands[i] = new DefaultStatisticsBand(bands.get(i));
        }
        this.varCov = new double[this.statisticsBands.length][this.statisticsBands.length];
        this.calculated = false;
    }

    public long[] getNumberOfValues() {
        if (!this.isCalculated()) {
            throw new IllegalStateException("Not calculated statistics.");
        }
        long[] result = new long[this.statisticsBands.length];
        for (int i = 0; i < this.statisticsBands.length; ++i) {
            result[i] = this.statisticsBands[i].getBandLength() - this.statisticsBands[i].getNoDataValuesCount();
        }
        return result;
    }

    public double[] getMax() {
        double[] result = new double[this.statisticsBands.length];
        for (int i = 0; i < this.statisticsBands.length; ++i) {
            result[i] = this.statisticsBands[i].getMaximum();
        }
        return result;
    }

    public double[] getSecondMax() {
        double[] result = new double[this.statisticsBands.length];
        for (int i = 0; i < this.statisticsBands.length; ++i) {
            result[i] = this.statisticsBands[i].getSecondMax();
        }
        return result;
    }

    public double[] getSecondMin() {
        double[] result = new double[this.statisticsBands.length];
        for (int i = 0; i < this.statisticsBands.length; ++i) {
            result[i] = this.statisticsBands[i].getSecondMin();
        }
        return result;
    }

    public double getMaximum() {
        double result = Double.NEGATIVE_INFINITY;
        for (int i = 0; i < this.statisticsBands.length; ++i) {
            double max = this.statisticsBands[i].getMaximum();
            if (!(result < max)) continue;
            result = max;
        }
        return result;
    }

    public double getMinimum() {
        double result = Double.POSITIVE_INFINITY;
        for (int i = 0; i < this.statisticsBands.length; ++i) {
            double min = this.statisticsBands[i].getMinimum();
            if (!(result > min)) continue;
            result = min;
        }
        return result;
    }

    public double[] getMean() {
        double[] result = new double[this.statisticsBands.length];
        for (int i = 0; i < this.statisticsBands.length; ++i) {
            result[i] = this.statisticsBands[i].getMean();
        }
        return result;
    }

    public double[] getMedian() {
        double[] result = new double[this.statisticsBands.length];
        for (int i = 0; i < this.statisticsBands.length; ++i) {
            result[i] = this.statisticsBands[i].getMedian();
        }
        return result;
    }

    public double[] getMin() {
        double[] result = new double[this.statisticsBands.length];
        for (int i = 0; i < this.statisticsBands.length; ++i) {
            result[i] = this.statisticsBands[i].getMinimum();
        }
        return result;
    }

    public double[] getVariance() {
        double[] result = new double[this.statisticsBands.length];
        for (int i = 0; i < this.statisticsBands.length; ++i) {
            result[i] = this.statisticsBands[i].getVariance();
        }
        return result;
    }

    public int getBandCount() {
        return this.statisticsBands.length;
    }

    public boolean isCalculated() {
        return this.calculated;
    }

    public void calculate(SimpleTaskStatus status, List<Band> bands) {
        this.calculated = false;
        boolean isMyStatus = false;
        if (status == null) {
            status = ToolsLocator.getTaskStatusManager().createDefaultSimpleTaskStatus("Statistics");
            status.add();
            isMyStatus = true;
        } else {
            status.push();
        }
        this.init(bands);
        try {
            int j;
            int i;
            status.setIndeterminate();
            status.message("Calculating statistics");
            int count = 1;
            int maxCount = this.statisticsBands.length * 3;
            for (i = 0; i < this.statisticsBands.length; ++i) {
                status.message("Calculating statistics " + count++ + "/" + maxCount);
                if (status.isCancellationRequested()) {
                    status.cancel();
                    return;
                }
                if (this.statisticsBands[i].isCalculated()) continue;
                this.statisticsBands[i].calculate(status, bands.get(i));
            }
            for (i = 0; i < this.statisticsBands.length; ++i) {
                status.message("Calculating statistics " + count++ + "/" + maxCount);
                if (status.isCancellationRequested()) {
                    status.cancel();
                    return;
                }
                for (j = i; j < this.statisticsBands.length; ++j) {
                    this.varCov[i][j] = this.getCovariance(status, this.statisticsBands[i], bands.get(i), this.statisticsBands[j], bands.get(j));
                }
            }
            status.setIndeterminate();
            for (i = 0; i < this.statisticsBands.length; ++i) {
                status.message("Calculating statistics " + count++ + "/" + maxCount);
                if (status.isCancellationRequested()) {
                    status.cancel();
                    return;
                }
                for (j = 0; j < i; ++j) {
                    this.varCov[i][j] = this.varCov[j][i];
                }
            }
            if (isMyStatus) {
                status.terminate();
            } else {
                status.pop();
            }
            this.calculated = true;
        }
        catch (Exception e) {
            status.abort();
            throw e;
        }
    }

    private double getCovariance(SimpleTaskStatus status, StatisticsBand statisticBand1, Band band1, StatisticsBand statisticBand2, Band band2) {
        double sigma = 0.0;
        int n = 0;
        int rowCount = band1.getRows();
        status.setRangeOfValues(0L, (long)rowCount);
        for (int row = 0; row < rowCount; ++row) {
            status.setCurValue((long)row);
            if (status.isCancellationRequested()) {
                status.cancel();
                return 0.0;
            }
            for (int column = 0; column < band1.getColumns(); ++column) {
                Double v1 = band1.getAsDouble(row, column);
                if (v1 != null) {
                    double factor1 = v1 - statisticBand1.getMean();
                    Double v2 = band2.getAsDouble(row, column);
                    if (v2 != null) {
                        double factor2 = v2 - statisticBand2.getMean();
                        sigma += factor1 * factor2;
                    }
                }
                ++n;
            }
        }
        return sigma / (double)n;
    }

    public double[][] getVarianceCovarianceMatrix() {
        return this.varCov;
    }

    public HistogramBand[] getHistogram() {
        HistogramBand[] histogramBands = new HistogramBand[this.statisticsBands.length];
        for (int i = 0; i < this.statisticsBands.length; ++i) {
            histogramBands[i] = this.statisticsBands[i].getHistogramBand();
        }
        return histogramBands;
    }

    public double[][] getTailTrimValue(double percent) {
        double[][] result = new double[this.statisticsBands.length][2];
        for (int i = 0; i < this.statisticsBands.length; ++i) {
            result[i] = this.statisticsBands[i].getTailTrimValue(percent);
        }
        return result;
    }

    public double[][] getTailTrimValue(int pos) {
        double[][] result = new double[this.statisticsBands.length][2];
        for (int i = 0; i < this.statisticsBands.length; ++i) {
            result[i] = this.statisticsBands[i].getTailTrimValue(pos);
        }
        return result;
    }

    public Iterator<StatisticsBand> iterator() {
        return Arrays.asList(this.statisticsBands).iterator();
    }

    public String toHTMLString() {
        I18nManager i18n = ToolsLocator.getI18nManager();
        if (!this.calculated) {
            return i18n.getTranslation("_Need_calculate_statistics");
        }
        LayerInformationBuilder builder = MapContextLocator.getMapContextManager().createLayerInformationBuilder();
        double[][] matrix = this.getVarianceCovarianceMatrix();
        BufferManager bufferManager = BufferLocator.getBufferManager();
        int bandCounter = 0;
        Iterator<StatisticsBand> iterator = this.iterator();
        while (iterator.hasNext()) {
            int bandCounter2;
            StatisticsBand statisticsBand = iterator.next();
            builder.title().labelkey(i18n.getTranslation("_band") + " " + bandCounter);
            int dataType = statisticsBand.getDataType();
            builder.property().labelkey("_dataType").value(bufferManager.getBufferTypeName(dataType), new Object[0]);
            Long dataCount = statisticsBand.getBandLength();
            builder.property().labelkey("_dataCount").value(dataCount.toString(), new Object[0]);
            Long noDataValuesCount = statisticsBand.getNoDataValuesCount();
            builder.property().labelkey("_noDataValuesCount").value(noDataValuesCount.toString(), new Object[0]);
            Double minimum = statisticsBand.getMinimum();
            builder.property().labelkey("_minimum").value(minimum.toString(), new Object[0]);
            Double maximum = statisticsBand.getMaximum();
            builder.property().labelkey("_maximum").value(maximum.toString(), new Object[0]);
            Double mean = statisticsBand.getMean();
            builder.property().labelkey("_mean").value(mean.toString(), new Object[0]);
            Double median = statisticsBand.getMedian();
            builder.property().labelkey("_median").value(median.toString(), new Object[0]);
            Double secondMin = statisticsBand.getSecondMin();
            builder.property().labelkey("_secondMin").value(secondMin.toString(), new Object[0]);
            Double secondMax = statisticsBand.getSecondMax();
            builder.property().labelkey("_secondMax").value(secondMax.toString(), new Object[0]);
            Double variance = statisticsBand.getVariance();
            builder.property().labelkey("_variance").value(variance.toString(), new Object[0]);
            Double standardDeviation = Math.sqrt(variance);
            builder.property().labelkey("_standard_deviation").value(standardDeviation.toString(), new Object[0]);
            double[] covariance = matrix[bandCounter];
            for (bandCounter2 = 0; bandCounter2 < covariance.length; ++bandCounter2) {
                builder.property().label(i18n.getTranslation("_covariance_with_band") + " " + bandCounter2).value(Double.toString(covariance[bandCounter2]), new Object[0]);
            }
            for (bandCounter2 = 0; bandCounter2 < covariance.length; ++bandCounter2) {
                Double pearson = covariance[bandCounter2] / (statisticsBand.getVariance() * this.statisticsBands[bandCounter2].getVariance());
                builder.property().label(i18n.getTranslation("_pearson_correlation_coefficient_with_band") + " " + bandCounter2).value(pearson.isNaN() ? "\u2015" : pearson.toString(), new Object[0]);
            }
            ++bandCounter;
        }
        return builder.toString();
    }
}

