/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.lib.buffer.impl.statistics;

import org.gvsig.raster.lib.buffer.api.Band;
import org.gvsig.raster.lib.buffer.api.statistics.HistogramBand;
import org.gvsig.raster.lib.buffer.api.statistics.StatisticsBand;
import org.gvsig.raster.lib.buffer.impl.statistics.HistogramOperation;
import org.gvsig.raster.lib.buffer.impl.statistics.MaxOperation;
import org.gvsig.raster.lib.buffer.impl.statistics.MeanOperation;
import org.gvsig.raster.lib.buffer.impl.statistics.MinOperation;
import org.gvsig.raster.lib.buffer.impl.statistics.SecondMaxOperation;
import org.gvsig.raster.lib.buffer.impl.statistics.SecondMinOperation;
import org.gvsig.raster.lib.buffer.impl.statistics.VarianceOperation;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.task.SimpleTaskStatus;

public class DefaultStatisticsBand
implements StatisticsBand {
    private boolean calculated;
    private double mean;
    private double max;
    private double secondMax;
    private double min;
    private double secondMin;
    private double variance;
    private HistogramBand histogramBand;
    private long countNoDataValues;
    private int bandLenght;
    private int dataType;

    public DefaultStatisticsBand(Band band) {
        this.init();
    }

    private void init() {
        this.calculated = false;
        this.countNoDataValues = 0L;
    }

    public boolean isCalculated() {
        return this.calculated;
    }

    public void calculate(SimpleTaskStatus status, Band band) {
        boolean isMyStatus = false;
        if (status == null) {
            status = ToolsLocator.getTaskStatusManager().createDefaultSimpleTaskStatus("Statistics");
            status.add();
            status.message("Calculating statistics band");
            isMyStatus = true;
        } else {
            status.push();
        }
        try {
            this.calculated = false;
            status.setRangeOfValues(0L, (long)(band.getRows() * 2));
            long cont = 0L;
            this.bandLenght = band.getRows() * band.getColumns();
            this.dataType = band.getDataType();
            MeanOperation meanOperation = new MeanOperation();
            MaxOperation maxOperation = new MaxOperation();
            MinOperation minOperation = new MinOperation();
            SecondMaxOperation secondMaxOperation = new SecondMaxOperation();
            SecondMinOperation secondMinOperation = new SecondMinOperation();
            meanOperation.pre();
            maxOperation.pre();
            minOperation.pre();
            secondMaxOperation.pre();
            secondMinOperation.pre();
            for (int row = 0; row < band.getRows(); ++row) {
                status.setCurValue(cont++);
                if (status.isCancellationRequested()) {
                    status.cancel();
                    return;
                }
                for (int column = 0; column < band.getColumns(); ++column) {
                    Double value = band.getAsDouble(row, column);
                    if (value == null) {
                        ++this.countNoDataValues;
                        continue;
                    }
                    meanOperation.addValue(value);
                    maxOperation.addValue(value);
                    minOperation.addValue(value);
                    secondMaxOperation.addValue(value);
                    secondMinOperation.addValue(value);
                }
            }
            meanOperation.post();
            maxOperation.post();
            minOperation.post();
            secondMaxOperation.post();
            secondMinOperation.post();
            this.mean = ((Number)meanOperation.getResult()).doubleValue();
            this.max = ((Number)maxOperation.getResult()).doubleValue();
            this.min = ((Number)minOperation.getResult()).doubleValue();
            this.secondMax = ((Number)secondMaxOperation.getResult()).doubleValue();
            this.secondMin = ((Number)secondMinOperation.getResult()).doubleValue();
            VarianceOperation varianceOperation = new VarianceOperation(this);
            varianceOperation.pre();
            HistogramOperation histogramOperation = new HistogramOperation(this, band);
            histogramOperation.pre();
            for (int row = 0; row < band.getRows(); ++row) {
                status.setCurValue(cont++);
                if (status.isCancellationRequested()) {
                    status.cancel();
                    return;
                }
                for (int column = 0; column < band.getColumns(); ++column) {
                    Double value = band.getAsDouble(row, column);
                    if (value == null) continue;
                    histogramOperation.addValue(value);
                    varianceOperation.addValue(value);
                }
            }
            histogramOperation.post();
            varianceOperation.post();
            this.histogramBand = (HistogramBand)histogramOperation.getResult();
            this.variance = ((Number)varianceOperation.getResult()).doubleValue();
            this.calculated = true;
        }
        catch (Exception e) {
            status.abort();
            throw e;
        }
        finally {
            if (isMyStatus) {
                status.terminate();
            } else {
                status.pop();
            }
        }
    }

    public int getDataType() {
        return this.dataType;
    }

    public long getBandLength() {
        return this.bandLenght;
    }

    public double getSecondMax() {
        return this.secondMax;
    }

    public double getSecondMin() {
        return this.secondMin;
    }

    public double getMaximum() {
        return this.max;
    }

    public double getMinimum() {
        return this.min;
    }

    public double getMean() {
        return this.mean;
    }

    public double getVariance() {
        return this.variance;
    }

    public double[] getTailTrimValue(double percent) {
        return this.getHistogramBand().getTailTrimValue(percent);
    }

    public double[] getTailTrimValue(int pos) {
        return this.getHistogramBand().getTailTrimValue(pos);
    }

    public HistogramBand getHistogramBand() {
        return this.histogramBand;
    }

    public double getMedian() {
        return this.getHistogramBand().getMedian();
    }

    public long getNoDataValuesCount() {
        return this.countNoDataValues;
    }
}

