/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.xmlpull.prov.stax.stream;

import com.bea.xml.stream.XMLWriterBase;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.gvsig.xmlpull.lib.api.stream.EventType;
import org.gvsig.xmlpull.lib.api.stream.IQName;
import org.gvsig.xmlpull.lib.api.stream.IXmlStreamWriter;
import org.gvsig.xmlpull.lib.api.stream.XmlStreamException;

public class StaxXmlStreamWriter
implements IXmlStreamWriter {
    private XMLStreamWriter writer;
    private EventType lastTagEvent;
    private EventType lastEvent;
    private long valueLength;
    private long writtenValueLength;
    private String attributeNamespace;
    private String attributeLocalName;
    private StringBuffer attributeValue = new StringBuffer();
    private StringBuffer valueBuff = new StringBuffer();

    public StaxXmlStreamWriter(OutputStream out) throws XmlStreamException {
        XMLOutputFactory staxFactory = XMLOutputFactory.newInstance();
        this.writer = new XMLWriterBase((Writer)new OutputStreamWriter(out));
        this.lastEvent = EventType.NONE;
    }

    public void close() throws XmlStreamException {
        if (this.writer != null) {
            try {
                this.writer.close();
            }
            catch (XMLStreamException e) {
                throw new XmlStreamException((Throwable)e);
            }
            this.writer = null;
        }
    }

    public boolean isOpen() {
        return this.writer != null;
    }

    public void setDefaultNamespace(String defaultNamespaceUri) throws XmlStreamException {
        try {
            this.writer.setDefaultNamespace(defaultNamespaceUri);
        }
        catch (XMLStreamException e) {
            throw new XmlStreamException((Throwable)e);
        }
    }

    public void setPrefix(String prefix, String namespaceUri) throws XmlStreamException {
        try {
            this.writer.setPrefix(prefix, namespaceUri);
        }
        catch (XMLStreamException e) {
            throw new XmlStreamException((Throwable)e);
        }
    }

    public void setSchemaLocation(String namespaceUri, String schemaLocationUri) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    public void flush() throws XmlStreamException {
        try {
            this.writer.flush();
        }
        catch (XMLStreamException e) {
            throw new XmlStreamException((Throwable)e);
        }
    }

    public EventType getLastEvent() {
        return this.lastEvent;
    }

    public EventType getLastTagEvent() {
        return this.lastTagEvent;
    }

    public int getTagDeep() {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    public long getValueLength() {
        return this.valueLength;
    }

    public long getWrittenValueCount() {
        return this.writtenValueLength;
    }

    public void startArray(EventType valueType, int arrayLength) throws XmlStreamException {
        this.valueLength = arrayLength;
        this.lastEvent = valueType;
        this.writtenValueLength = 0L;
    }

    public void endArray() throws XmlStreamException {
    }

    public void writeComment(String commentContent) throws XmlStreamException {
        try {
            this.writer.writeComment(commentContent);
        }
        catch (XMLStreamException e) {
            throw new XmlStreamException((Throwable)e);
        }
        this.lastEvent = EventType.COMMENT;
    }

    public void writeEndAttributes() throws XmlStreamException {
        this.flushAttribute();
        this.lastEvent = EventType.ATTRIBUTES_END;
    }

    public void writeEndDocument() throws XmlStreamException {
        try {
            this.writer.writeEndDocument();
        }
        catch (XMLStreamException e) {
            throw new XmlStreamException((Throwable)e);
        }
        this.lastEvent = EventType.END_DOCUMENT;
    }

    public void writeEndElement() throws XmlStreamException {
        try {
            this.writer.writeEndElement();
        }
        catch (XMLStreamException e) {
            throw new XmlStreamException((Throwable)e);
        }
        this.lastEvent = this.lastTagEvent = EventType.END_ELEMENT;
    }

    public void writeStartAttribute(String namespaceUri, String localName) throws XmlStreamException {
        this.flushAttribute();
        this.attributeNamespace = namespaceUri;
        this.attributeLocalName = localName;
        this.attributeValue.setLength(0);
        this.lastEvent = EventType.ATTRIBUTE;
    }

    private void flushAttribute() throws XmlStreamException {
        if (this.attributeLocalName != null) {
            String value = this.attributeValue.toString();
            try {
                this.writer.writeAttribute(this.attributeNamespace, this.attributeLocalName, value);
            }
            catch (XMLStreamException e) {
                throw new XmlStreamException((Throwable)e);
            }
            this.attributeNamespace = null;
            this.attributeLocalName = null;
            this.attributeValue.setLength(0);
        }
    }

    public void writeStartAttribute(IQName qname) throws XmlStreamException {
        this.writeStartAttribute(qname.getNamespaceURI(), qname.getLocalPart());
    }

    public void writeStartDocument() throws XmlStreamException {
        try {
            this.writer.writeStartDocument();
        }
        catch (XMLStreamException e) {
            throw new XmlStreamException((Throwable)e);
        }
        this.lastEvent = EventType.START_DOCUMENT;
    }

    public void writeStartElement(String namespaceUri, String localName) throws XmlStreamException {
        try {
            this.writer.writeStartElement(namespaceUri, localName);
        }
        catch (XMLStreamException e) {
            throw new XmlStreamException((Throwable)e);
        }
        this.attributeLocalName = null;
        this.attributeNamespace = null;
        this.lastEvent = this.lastTagEvent = EventType.START_ELEMENT;
    }

    public void writeStartElement(IQName qname) throws XmlStreamException {
        this.writeStartElement(qname.getNamespaceURI(), qname.getLocalPart());
    }

    private void characters(String value) throws XmlStreamException {
        if (this.attributeLocalName == null) {
            try {
                this.writer.writeCharacters(value);
            }
            catch (XMLStreamException e) {
                throw new XmlStreamException((Throwable)e);
            }
        } else {
            this.attributeValue.append(value);
        }
    }

    public void writeValue(String value) throws XmlStreamException {
        this.characters(value);
        ++this.writtenValueLength;
        this.lastEvent = EventType.VALUE_STRING;
    }

    public void writeValue(char[] chars, int offset, int length) throws XmlStreamException {
        this.characters(new String(chars, offset, length));
        ++this.writtenValueLength;
        this.lastEvent = EventType.VALUE_STRING;
    }

    public void writeValue(int value) throws XmlStreamException {
        this.characters(String.valueOf(value));
        ++this.writtenValueLength;
        this.lastEvent = EventType.VALUE_INT;
    }

    public void writeValue(long value) throws XmlStreamException {
        this.characters(String.valueOf(value));
        ++this.writtenValueLength;
        this.lastEvent = EventType.VALUE_LONG;
    }

    public void writeValue(float value) throws XmlStreamException {
        this.characters(String.valueOf(value));
        ++this.writtenValueLength;
        this.lastEvent = EventType.VALUE_FLOAT;
    }

    public void writeValue(double value) throws XmlStreamException {
        this.characters(String.valueOf(value));
        ++this.writtenValueLength;
        this.lastEvent = EventType.VALUE_DOUBLE;
    }

    public void writeValue(boolean value) throws XmlStreamException {
        this.characters(String.valueOf(value));
        ++this.writtenValueLength;
        this.lastEvent = EventType.VALUE_BOOL;
    }

    public void writeValue(boolean[] value, int offset, int length) throws XmlStreamException {
        this.valueBuff.setLength(0);
        for (int i = 0; i < length; ++i) {
            this.valueBuff.append(value[offset + i]);
            if (i >= length - 1) continue;
            this.valueBuff.append(' ');
        }
        this.characters(this.valueBuff.toString());
        this.writtenValueLength += (long)length;
        this.lastEvent = EventType.VALUE_BOOL;
    }

    public void writeValue(int[] value, int offset, int length) throws XmlStreamException {
        this.valueBuff.setLength(0);
        for (int i = 0; i < length; ++i) {
            this.valueBuff.append(value[offset + i]);
            if (i >= length - 1) continue;
            this.valueBuff.append(' ');
        }
        this.characters(this.valueBuff.toString());
        this.writtenValueLength += (long)length;
        this.lastEvent = EventType.VALUE_INT;
    }

    public void writeValue(long[] value, int offset, int length) throws XmlStreamException {
        this.valueBuff.setLength(0);
        for (int i = 0; i < length; ++i) {
            this.valueBuff.append(value[offset + i]);
            if (i >= length - 1) continue;
            this.valueBuff.append(' ');
        }
        this.characters(this.valueBuff.toString());
        this.writtenValueLength += (long)length;
        this.lastEvent = EventType.VALUE_LONG;
    }

    public void writeValue(float[] value, int offset, int length) throws XmlStreamException {
        this.valueBuff.setLength(0);
        for (int i = 0; i < length; ++i) {
            this.valueBuff.append(value[offset + i]);
            if (i >= length - 1) continue;
            this.valueBuff.append(' ');
        }
        this.characters(this.valueBuff.toString());
        this.writtenValueLength += (long)length;
        this.lastEvent = EventType.VALUE_FLOAT;
    }

    public void writeValue(double[] value, int offset, int length) throws XmlStreamException {
        this.valueBuff.setLength(0);
        for (int i = 0; i < length; ++i) {
            this.valueBuff.append(value[offset + i]);
            if (i >= length - 1) continue;
            this.valueBuff.append(',');
        }
        this.valueBuff.append(' ');
        this.characters(this.valueBuff.toString());
        this.writtenValueLength += (long)length;
        this.lastEvent = EventType.VALUE_DOUBLE;
    }
}

