/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.store.jdbc2.impl;

import java.sql.SQLException;
import java.util.NoSuchElementException;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.feature.FeatureType;
import org.gvsig.fmap.dal.feature.spi.AbstractFeatureProviderIterator;
import org.gvsig.fmap.dal.feature.spi.FeatureProvider;
import org.gvsig.fmap.dal.feature.spi.FeatureStoreProvider;
import org.gvsig.fmap.dal.store.jdbc2.JDBCStoreProvider;
import org.gvsig.fmap.dal.store.jdbc2.ResulSetControler;
import org.gvsig.fmap.dal.store.jdbc2.impl.JDBCSetProvider;
import org.gvsig.tools.exception.BaseException;

public class JDBCIterator
extends AbstractFeatureProviderIterator {
    protected ResulSetControler.ResultSetEntry resulsetEntry;
    protected Boolean hasNext = null;
    protected FeatureType featureType;
    protected JDBCSetProvider set;

    protected JDBCIterator(JDBCStoreProvider store, JDBCSetProvider set, FeatureType featureType, ResulSetControler.ResultSetEntry resulsetEntry) throws DataException {
        super((FeatureStoreProvider)store);
        this.resulsetEntry = resulsetEntry;
        this.featureType = featureType;
        this.set = set;
        this.hasNext = null;
    }

    protected JDBCStoreProvider getFeatureStoreProvider() {
        return (JDBCStoreProvider)super.getFeatureStoreProvider();
    }

    public final Object next() {
        return this.internalNext();
    }

    public final boolean hasNext() {
        return this.internalHasNext();
    }

    protected boolean internalHasNext() {
        if (this.hasNext == null) {
            try {
                if (this.resulsetEntry.next()) {
                    this.hasNext = Boolean.TRUE;
                } else {
                    this.hasNext = Boolean.FALSE;
                    this.close();
                }
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        }
        return this.hasNext;
    }

    protected Object internalNext() {
        FeatureProvider data;
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        try {
            data = this.getFeatureProvider();
        }
        catch (DataException e) {
            throw new RuntimeException(e);
        }
        this.hasNext = null;
        return data;
    }

    public void remove() {
        throw new UnsupportedOperationException();
    }

    protected FeatureProvider createFeatureProvider() throws DataException {
        return this.getFeatureStoreProvider().createFeatureProvider(this.featureType);
    }

    protected FeatureProvider getFeatureProvider() throws DataException {
        FeatureProvider data = this.createFeatureProvider();
        this.getFeatureStoreProvider().getHelper().fetchFeature(data, this.resulsetEntry);
        return data;
    }

    protected void doDispose() throws BaseException {
        if (this.resulsetEntry != null) {
            this.close();
        }
        this.featureType = null;
    }

    protected void close() {
        try {
            this.resulsetEntry.close();
            this.resulsetEntry = null;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

