/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.store.jdbc2.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.gvsig.fmap.dal.DataStoreParameters;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.feature.FeatureQuery;
import org.gvsig.fmap.dal.feature.FeatureType;
import org.gvsig.fmap.dal.feature.spi.AbstractFeatureSetProvider;
import org.gvsig.fmap.dal.feature.spi.AbstractFeatureStoreProvider;
import org.gvsig.fmap.dal.store.jdbc.JDBCStoreParameters;
import org.gvsig.fmap.dal.store.jdbc2.JDBCHelper;
import org.gvsig.fmap.dal.store.jdbc2.JDBCStoreProvider;
import org.gvsig.fmap.dal.store.jdbc2.JDBCUtils;
import org.gvsig.fmap.dal.store.jdbc2.OperationsFactory;
import org.gvsig.fmap.dal.store.jdbc2.ResulSetControler;
import org.gvsig.fmap.dal.store.jdbc2.impl.JDBCFastIterator;
import org.gvsig.fmap.dal.store.jdbc2.impl.JDBCIterator;
import org.gvsig.fmap.dal.store.jdbc2.spi.operations.CountOperation;
import org.gvsig.fmap.dal.store.jdbc2.spi.operations.ResultSetForSetProviderOperation;
import org.gvsig.fmap.dal.store.jdbc2.spi.operations.TableIsEmptyOperation;
import org.gvsig.tools.exception.BaseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JDBCSetProvider
extends AbstractFeatureSetProvider {
    protected static final Logger LOGGER = LoggerFactory.getLogger(JDBCSetProvider.class);
    protected Long size = null;
    protected Boolean isEmpty = null;
    protected List<ResulSetControler.ResultSetEntry> resultSets = new ArrayList<ResulSetControler.ResultSetEntry>();
    private int defaultFetchSize = 1000;

    public JDBCSetProvider(AbstractFeatureStoreProvider store, JDBCHelper helper, FeatureQuery query, FeatureType providerFeatureType, FeatureType storeFeatureType) throws DataException {
        super(store, query, providerFeatureType, storeFeatureType);
        try {
            DataStoreParameters params = store.getParameters();
            Object x = params.getDynValue("defaultFetchSize");
            if (x != null) {
                this.defaultFetchSize = (Integer)x;
            }
        }
        catch (Exception e) {
            LOGGER.warn("Can't get defaultFetchSize from storeParameters", (Throwable)e);
        }
    }

    public JDBCSetProvider(AbstractFeatureStoreProvider store, JDBCHelper helper, FeatureQuery query, FeatureType featureType) throws DataException {
        this(store, helper, query, featureType, null);
    }

    public int getDefaultFetchSize() {
        return this.defaultFetchSize;
    }

    public void setDefaultFetchSize(int defaultFetchSize) {
        this.defaultFetchSize = defaultFetchSize;
    }

    protected JDBCStoreProvider getJDBCStore() {
        return (JDBCStoreProvider)super.getStore();
    }

    protected JDBCHelper getHelper() {
        return this.getJDBCStore().getHelper();
    }

    protected OperationsFactory getOperations() {
        return this.getHelper().getOperations();
    }

    public boolean canIterateFromIndex() {
        return this.getHelper().supportOffsetInSelect();
    }

    public boolean canFilter() {
        return this.getHelper().supportFilter(this.getProviderFeatureType(), this.getQuery().getFilter());
    }

    public boolean canOrder() {
        return this.getHelper().supportOrder(this.getProviderFeatureType(), this.getQuery().getOrder());
    }

    public ResulSetControler getResulSetControler() {
        return this.getHelper().getResulSetControler();
    }

    protected void doDispose() throws BaseException {
        if (!CollectionUtils.isEmpty(this.resultSets)) {
            for (ResulSetControler.ResultSetEntry resulset : this.resultSets) {
                JDBCUtils.closeQuietly(resulset);
            }
        }
        this.size = null;
        this.isEmpty = null;
    }

    protected int getFetchSize() {
        long pageSize = -1L;
        if (this.getQuery() != null) {
            pageSize = this.getQuery().getPageSize();
            pageSize = pageSize > Integer.MAX_VALUE ? Integer.MAX_VALUE : pageSize;
        }
        return pageSize > 0L ? (int)pageSize : this.defaultFetchSize;
    }

    public long getSize() throws DataException {
        if (this.size == null) {
            JDBCStoreParameters params = this.getJDBCStore().getParameters();
            CountOperation selectCount = this.getOperations().createCount(this.getProviderFeatureType(), this.getOperations().createTableReference(params), params.getBaseFilter(), this.getQuery());
            this.size = (Long)selectCount.perform();
        }
        return this.size;
    }

    public boolean isEmpty() throws DataException {
        if (this.isEmpty == null) {
            if (this.size == null) {
                JDBCStoreParameters params = this.getJDBCStore().getParameters();
                TableIsEmptyOperation isEmpty_ = this.getOperations().createTableIsEmpty(this.getProviderFeatureType(), this.getOperations().createTableReference(params), params.getBaseFilter(), this.getQuery());
                this.isEmpty = (Boolean)isEmpty_.perform();
            } else {
                this.isEmpty = this.size < 1L;
            }
        }
        return this.isEmpty;
    }

    protected JDBCIterator createFastIterator(long index) throws DataException {
        return this.createFastIterator(index, 0L);
    }

    protected JDBCIterator createFastIterator(long index, long elements) throws DataException {
        if (BooleanUtils.isTrue((Boolean)this.isEmpty)) {
            return new EmptyJDBCIterator(this.getJDBCStore());
        }
        JDBCStoreParameters params = this.getJDBCStore().getParameters();
        FeatureType storeType = this.getStore().getStoreServices().getProviderFeatureType(this.getProviderFeatureType().getId());
        ResultSetForSetProviderOperation createResultSet = this.getOperations().createResultSetForSetProvider(this.getOperations().createTableReference(params), params.getBaseFilter(), params.getBaseOrder(), this.getQuery(), storeType, this.getProviderFeatureType(), elements, index, this.getFetchSize());
        ResulSetControler.ResultSetEntry resultSetEntry = (ResulSetControler.ResultSetEntry)createResultSet.perform();
        this.resultSets.add(resultSetEntry);
        return new JDBCFastIterator(this.getJDBCStore(), this, this.getProviderFeatureType(), resultSetEntry);
    }

    protected JDBCIterator createIterator(long index) throws DataException {
        return this.createIterator(index, -1L);
    }

    protected JDBCIterator createIterator(long index, long elements) throws DataException {
        if (BooleanUtils.isTrue((Boolean)this.isEmpty)) {
            return new EmptyJDBCIterator(this.getJDBCStore());
        }
        JDBCStoreParameters params = this.getJDBCStore().getParameters();
        FeatureType storeType = this.getStore().getStoreServices().getProviderFeatureType(this.getProviderFeatureType().getId());
        ResultSetForSetProviderOperation createResultSet = this.getOperations().createResultSetForSetProvider(this.getOperations().createTableReference(params), params.getBaseFilter(), params.getBaseOrder(), this.getQuery(), storeType, this.getProviderFeatureType(), elements, index, this.getDefaultFetchSize());
        ResulSetControler.ResultSetEntry resultSetEntry = (ResulSetControler.ResultSetEntry)createResultSet.perform();
        this.resultSets.add(resultSetEntry);
        return new JDBCIterator(this.getJDBCStore(), this, this.getProviderFeatureType(), resultSetEntry);
    }

    private class EmptyJDBCIterator
    extends JDBCIterator {
        protected EmptyJDBCIterator(JDBCStoreProvider store) throws DataException {
            super(store, null, null, null);
        }

        @Override
        protected boolean internalHasNext() {
            return false;
        }

        @Override
        protected Object internalNext() {
            throw new NoSuchElementException();
        }

        @Override
        protected void doDispose() throws BaseException {
        }
    }
}

