/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.store.jdbc2.spi;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.output.NullOutputStream;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.gvsig.expressionevaluator.ExpressionBuilder;
import org.gvsig.expressionevaluator.ExpressionUtils;
import org.gvsig.fmap.dal.DALLocator;
import org.gvsig.fmap.dal.DataManager;
import org.gvsig.fmap.dal.DataStoreParameters;
import org.gvsig.fmap.dal.DataTransaction;
import org.gvsig.fmap.dal.SupportTransactions;
import org.gvsig.fmap.dal.feature.EditableFeature;
import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.fmap.dal.feature.FeatureSet;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.dal.spi.DataTransactionServices;
import org.gvsig.fmap.dal.store.jdbc.JDBCStoreParameters;
import org.gvsig.fmap.dal.store.jdbc.exception.SQLRuntimeException;
import org.gvsig.fmap.dal.store.jdbc2.JDBCHelper;
import org.gvsig.fmap.dal.store.jdbc2.OperationsFactory;
import org.gvsig.fmap.dal.store.jdbc2.spi.operations.RetrieveValueOperation;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dispose.Disposable;
import org.gvsig.tools.dispose.DisposeUtils;
import org.gvsig.tools.exception.BaseException;
import org.gvsig.tools.folders.FoldersManager;
import org.gvsig.tools.resourcesstorage.AbstractResourcesStorage;
import org.gvsig.tools.resourcesstorage.ResourcesStorage;
import org.gvsig.tools.util.CachedValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JDBCResourcesStorage
extends AbstractResourcesStorage
implements SupportTransactions {
    private static final Logger LOGGER = LoggerFactory.getLogger(JDBCResourcesStorage.class);
    public static final String TABLENAME_SERVER_EXPLORER_MARK = "$ServerExplorer";
    private final JDBCHelper helper;
    private final ResourcesStorage alternativeStorage;
    private final JDBCStoreParameters resourcesStoreParameters;
    private final String tableName;
    private final boolean readonly;
    private final ExistsResourcesCache existsResourcesCache;

    public JDBCResourcesStorage(JDBCHelper helper, ResourcesStorage alternativeStorage, JDBCStoreParameters resourcesStoreParameters, String tableName) {
        this(helper, alternativeStorage, resourcesStoreParameters, tableName, false);
    }

    public JDBCResourcesStorage(JDBCHelper helper, ResourcesStorage alternativeStorage, JDBCStoreParameters resourcesStoreParameters, String tableName, boolean readonly) {
        this.helper = helper;
        DisposeUtils.bind((Object)this.helper);
        this.readonly = readonly;
        this.alternativeStorage = alternativeStorage;
        this.resourcesStoreParameters = StringUtils.equals((CharSequence)"GVSIGD_RESOURCES", (CharSequence)tableName) ? null : resourcesStoreParameters;
        this.tableName = tableName;
        this.existsResourcesCache = new ExistsResourcesCache();
        this.existsResourcesCache.setExpireTime(60000L);
    }

    public void setTransaction(DataTransaction transaction) {
        this.helper.setTransaction((DataTransactionServices)transaction);
    }

    public DataTransaction getTransaction() {
        return this.helper.getTransaction();
    }

    private boolean ResourcesStorageIsEmpty(ResourcesStorage res) {
        if (res == null) {
            return true;
        }
        return res.isEmpty();
    }

    public boolean isEmpty() {
        return this.resourcesStoreParameters == null && this.ResourcesStorageIsEmpty(this.alternativeStorage);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getResourceNames() {
        List names;
        HashSet<String> resourceNames = new HashSet<String>();
        if (this.alternativeStorage != null && !CollectionUtils.isEmpty((Collection)(names = this.alternativeStorage.getResourceNames()))) {
            resourceNames.addAll(names);
        }
        if (this.resourcesStoreParameters != null) {
            FeatureStore store = null;
            try {
                DataManager dataManager = DALLocator.getDataManager();
                store = (FeatureStore)dataManager.openStore(this.getTransaction(), this.resourcesStoreParameters.getDataStoreName(), (DataStoreParameters)this.resourcesStoreParameters);
                FeatureSet featureSet = store.getFeatureSet();
                for (Feature feature : featureSet) {
                    String resName = feature.getString("name");
                    if (StringUtils.equalsIgnoreCase((CharSequence)this.tableName, (CharSequence)TABLENAME_SERVER_EXPLORER_MARK)) {
                        resourceNames.add(resName);
                        continue;
                    }
                    String resTypeName = FilenameUtils.getExtension((String)resName);
                    resourceNames.add(resTypeName);
                }
            }
            catch (Throwable ex) {
                List<String> list;
                try {
                    LOGGER.warn("Can't get resources for '" + this.resourcesStoreParameters.getUrl() + "'.", ex);
                    list = null;
                }
                catch (Throwable throwable) {
                    DisposeUtils.disposeQuietly(store);
                    throw throwable;
                }
                DisposeUtils.disposeQuietly((Disposable)store);
                return list;
            }
            DisposeUtils.disposeQuietly((Disposable)store);
        }
        return new ArrayList<String>(resourceNames);
    }

    public ResourcesStorage.Resource getResource(String name) {
        ResourcesStorage.Resource r;
        if (this.alternativeStorage != null && (r = this.alternativeStorage.getResource(name)).exists()) {
            return r;
        }
        if (this.resourcesStoreParameters == null) {
            return null;
        }
        return new DataBaseResource(this, name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ResourcesStorage.Resource> getResources(String name) {
        ArrayList<ResourcesStorage.Resource> arrayList;
        ArrayList<ResourcesStorage.Resource> ress;
        FeatureStore store;
        block8: {
            List r;
            if (this.resourcesStoreParameters == null) {
                return null;
            }
            if (this.alternativeStorage != null && (r = this.alternativeStorage.getResources(name)) != null && !r.isEmpty()) {
                return r;
            }
            store = null;
            DataManager dataManager = DALLocator.getDataManager();
            store = (FeatureStore)dataManager.openStore(this.getTransaction(), this.resourcesStoreParameters.getDataStoreName(), (DataStoreParameters)this.resourcesStoreParameters);
            ExpressionBuilder builder = ExpressionUtils.createExpressionBuilder();
            ress = new ArrayList<ResourcesStorage.Resource>();
            int n = 0;
            while (true) {
                String multiresourceName = n == 0 ? name : String.valueOf(n) + "." + name;
                String filter = builder.eq((ExpressionBuilder.Value)builder.column("name"), (ExpressionBuilder.Value)builder.constant((Object)(this.tableName + "." + multiresourceName))).toString();
                Feature feature = store.findFirst(filter);
                if (feature == null) break;
                ress.add(new DataBaseResource(this, multiresourceName));
                ++n;
            }
            if (!ress.isEmpty()) break block8;
            arrayList = null;
            DisposeUtils.disposeQuietly((Disposable)store);
            return arrayList;
        }
        try {
            arrayList = ress;
        }
        catch (Throwable ex) {
            List<ResourcesStorage.Resource> list;
            try {
                LOGGER.warn("Can't get resources for '" + this.resourcesStoreParameters.getUrl() + "&resourceName=" + name + "'.", ex);
                list = null;
            }
            catch (Throwable throwable) {
                DisposeUtils.disposeQuietly(store);
                throw throwable;
            }
            DisposeUtils.disposeQuietly((Disposable)store);
            return list;
        }
        DisposeUtils.disposeQuietly((Disposable)store);
        return arrayList;
    }

    public boolean add(String resourceName, InputStream is) {
        DataBaseResource res = new DataBaseResource(this, resourceName);
        try {
            IOUtils.copy((InputStream)is, (OutputStream)res.asOutputStream());
            res.close();
            is.close();
            return true;
        }
        catch (IOException ex) {
            return false;
        }
    }

    public boolean remove(String resourceName) {
        if (this.alternativeStorage != null) {
            try {
                this.alternativeStorage.remove(resourceName);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.resourcesStoreParameters == null) {
            return false;
        }
        DataBaseResource resource = new DataBaseResource(this, resourceName);
        return resource.remove();
    }

    public void clearCache() {
        try {
            byte[] data = this.resourcesStoreParameters.toByteArray();
            DataManager dataManager = DALLocator.getDataManager();
            File f = FileUtils.getFile((String[])new String[]{dataManager.getCacheResourcesFolder().getAbsolutePath(), "jdbc", DigestUtils.md5Hex((byte[])data)});
            FileUtils.deleteDirectory((File)f);
        }
        catch (Exception ex) {
            LOGGER.warn("Can't remove local cache for table " + this.tableName, (Throwable)ex);
        }
    }

    protected void doDispose() throws BaseException {
        super.doDispose();
        DisposeUtils.disposeQuietly((Object)this.helper);
    }

    public String toString() {
        ToStringBuilder builder = new ToStringBuilder((Object)this);
        builder.append("tableName", (Object)this.tableName);
        builder.append("url", (Object)this.resourcesStoreParameters.getUrl());
        builder.append("readonly", this.readonly);
        return builder.toString();
    }

    private static class DataBaseResource
    implements ResourcesStorage.Resource {
        private final String name;
        private final JDBCResourcesStorage storage;
        private InputStream in;
        private OutputStream out;

        public DataBaseResource(JDBCResourcesStorage storage, String name) {
            this.storage = storage;
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        private JDBCStoreParameters getStoreParameters() {
            return this.storage.resourcesStoreParameters;
        }

        private String getTableName() {
            return this.storage.tableName;
        }

        private Map<String, Boolean> getExistsResourcesCache() {
            return (Map)this.storage.existsResourcesCache.get();
        }

        public boolean isReadOnly() {
            return this.storage.readonly;
        }

        public URL getURL() {
            try {
                String url = this.getStoreParameters().getUrl();
                return new URL(url + "&tableName=" + this.getTableName() + "&resourceName=" + this.name);
            }
            catch (Throwable ex) {
                return null;
            }
        }

        private byte[] retrieveResource() throws Exception {
            ExpressionBuilder builder = ExpressionUtils.createExpressionBuilder();
            String filter = StringUtils.equalsIgnoreCase((CharSequence)this.getTableName(), (CharSequence)JDBCResourcesStorage.TABLENAME_SERVER_EXPLORER_MARK) ? builder.eq((ExpressionBuilder.Value)builder.column("name"), (ExpressionBuilder.Value)builder.constant((Object)this.name)).toString() : builder.eq((ExpressionBuilder.Value)builder.column("name"), (ExpressionBuilder.Value)builder.constant((Object)(this.getTableName() + "." + this.name))).toString();
            OperationsFactory operations = this.storage.helper.getOperations();
            RetrieveValueOperation op = operations.createRetrieveValue(operations.createTableReference(this.getStoreParameters()), filter, null, "resource");
            return (byte[])op.perform();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private byte[] retrieveResource0() throws Exception {
            byte[] resource;
            Feature feature;
            FeatureStore store;
            block3: {
                byte[] byArray;
                store = null;
                try {
                    DataManager dataManager = DALLocator.getDataManager();
                    store = (FeatureStore)dataManager.openStore(this.storage.getTransaction(), this.getStoreParameters().getDataStoreName(), (DataStoreParameters)this.getStoreParameters());
                    ExpressionBuilder builder = ExpressionUtils.createExpressionBuilder();
                    String filter = StringUtils.equalsIgnoreCase((CharSequence)this.getTableName(), (CharSequence)JDBCResourcesStorage.TABLENAME_SERVER_EXPLORER_MARK) ? builder.eq((ExpressionBuilder.Value)builder.column("name"), (ExpressionBuilder.Value)builder.constant((Object)this.name)).toString() : builder.eq((ExpressionBuilder.Value)builder.column("name"), (ExpressionBuilder.Value)builder.constant((Object)(this.getTableName() + "." + this.name))).toString();
                    feature = store.findFirst(filter);
                    if (feature != null) break block3;
                    byArray = null;
                }
                catch (Throwable throwable) {
                    DisposeUtils.disposeQuietly(store);
                    throw throwable;
                }
                DisposeUtils.disposeQuietly((Disposable)store);
                return byArray;
            }
            byte[] byArray = resource = feature.getByteArray("resource");
            DisposeUtils.disposeQuietly((Disposable)store);
            return byArray;
        }

        public boolean exists() {
            try {
                boolean exists;
                FoldersManager fm = ToolsLocator.getFoldersManager();
                Pair<String, String> key = this.getCacheID();
                String key_s = (String)key.getLeft() + "/" + (String)key.getRight();
                Map<String, Boolean> erc = this.getExistsResourcesCache();
                if (erc.containsKey(key_s)) {
                    return this.getExistsResourcesCache().get(key_s);
                }
                File f = fm.getTemporaryFile(new String[]{"resources-storage", "jdbc", (String)key.getLeft(), (String)key.getRight()});
                if (f.exists()) {
                    return true;
                }
                byte[] resource = this.retrieveResource();
                boolean bl = exists = !ArrayUtils.isEmpty((byte[])resource);
                if (exists) {
                    this.putResourceInCache(resource);
                }
                this.getExistsResourcesCache().put(key_s, exists);
                return exists;
            }
            catch (Throwable ex) {
                LOGGER.warn("Can't access to the resoure '" + this.getURL() + "'.", ex);
                return false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean remove() {
            block8: {
                boolean bl;
                FeatureStore store;
                block7: {
                    store = null;
                    FoldersManager fm = ToolsLocator.getFoldersManager();
                    Pair<String, String> key = this.getCacheID();
                    File f = fm.getTemporaryFile(new String[]{"resources-storage", "jdbc", (String)key.getLeft(), (String)key.getRight()});
                    if (f.exists()) {
                        f.delete();
                    }
                    DataManager dataManager = DALLocator.getDataManager();
                    store = (FeatureStore)dataManager.openStore(this.storage.getTransaction(), this.getStoreParameters().getDataStoreName(), (DataStoreParameters)this.getStoreParameters());
                    ExpressionBuilder builder = ExpressionUtils.createExpressionBuilder();
                    String filter = StringUtils.equalsIgnoreCase((CharSequence)this.getTableName(), (CharSequence)JDBCResourcesStorage.TABLENAME_SERVER_EXPLORER_MARK) ? builder.eq((ExpressionBuilder.Value)builder.column("name"), (ExpressionBuilder.Value)builder.constant((Object)this.name)).toString() : builder.eq((ExpressionBuilder.Value)builder.column("name"), (ExpressionBuilder.Value)builder.constant((Object)(this.getTableName() + "." + this.name))).toString();
                    Feature feature = store.findFirst(filter);
                    if (feature == null) break block7;
                    store.edit();
                    store.delete(feature);
                    store.finishEditing();
                    boolean bl2 = true;
                    DisposeUtils.disposeQuietly((Disposable)store);
                    return bl2;
                }
                try {
                    bl = false;
                }
                catch (Throwable ex) {
                    try {
                        FeatureStore.cancelEditingQuietly(store);
                        LOGGER.warn("Can't access to the resoure '" + this.getURL() + "'.", ex);
                        break block8;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        DisposeUtils.disposeQuietly(store);
                    }
                }
                DisposeUtils.disposeQuietly((Disposable)store);
                return bl;
            }
            return false;
        }

        private Pair<String, String> getCacheID() {
            byte[] data = this.getStoreParameters().toByteArray();
            ImmutablePair r = StringUtils.equalsIgnoreCase((CharSequence)this.getTableName(), (CharSequence)JDBCResourcesStorage.TABLENAME_SERVER_EXPLORER_MARK) ? new ImmutablePair((Object)DigestUtils.md5Hex((byte[])data), (Object)this.name) : new ImmutablePair((Object)DigestUtils.md5Hex((byte[])data), (Object)(this.getTableName() + "." + this.name));
            return r;
        }

        private boolean removeCache() {
            FoldersManager fm = ToolsLocator.getFoldersManager();
            Pair<String, String> key = this.getCacheID();
            File f = fm.getTemporaryFile(new String[]{"resources-storage", "jdbc", (String)key.getLeft(), (String)key.getRight()});
            if (f.exists()) {
                try {
                    FileUtils.forceDelete((File)f);
                }
                catch (IOException ex) {
                    return false;
                }
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private InputStream getInputStreamFromCache() {
            InputStream is;
            FoldersManager fm = ToolsLocator.getFoldersManager();
            Pair<String, String> key = this.getCacheID();
            File f = fm.getTemporaryFile(new String[]{"resources-storage", "jdbc", (String)key.getLeft(), (String)key.getRight()});
            if (!f.exists()) {
                File f2;
                FileOutputStream os;
                block8: {
                    is = null;
                    os = null;
                    f2 = null;
                    is = this.getInputStream();
                    if (is != null) break block8;
                    InputStream inputStream = null;
                    IOUtils.closeQuietly((InputStream)is);
                    IOUtils.closeQuietly(os);
                    return inputStream;
                }
                try {
                    FileUtils.forceMkdir((File)f.getParentFile());
                    os = new FileOutputStream(f);
                    IOUtils.copy((InputStream)is, (OutputStream)os);
                    IOUtils.closeQuietly((OutputStream)os);
                    f2 = fm.getTemporaryFile(new String[]{"resources-storage", "jdbc", (String)key.getLeft(), "parameters"});
                    byte[] data = this.getStoreParameters().toByteArray();
                    os = new FileOutputStream(f2);
                    IOUtils.write((byte[])data, (OutputStream)os);
                }
                catch (IOException ex) {
                    InputStream inputStream;
                    try {
                        FileUtils.deleteQuietly((File)f);
                        FileUtils.deleteQuietly(f2);
                        inputStream = null;
                    }
                    catch (Throwable throwable) {
                        IOUtils.closeQuietly((InputStream)is);
                        IOUtils.closeQuietly(os);
                        throw throwable;
                    }
                    IOUtils.closeQuietly((InputStream)is);
                    IOUtils.closeQuietly((OutputStream)os);
                    return inputStream;
                }
                IOUtils.closeQuietly((InputStream)is);
                IOUtils.closeQuietly((OutputStream)os);
            }
            is = null;
            try {
                is = new FileInputStream(f);
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
            return is;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void putResourceInCache(byte[] resource) {
            FoldersManager fm = ToolsLocator.getFoldersManager();
            Pair<String, String> key = this.getCacheID();
            File f = fm.getTemporaryFile(new String[]{"resources-storage", "jdbc", (String)key.getLeft(), (String)key.getRight()});
            FileOutputStream os = null;
            File f2 = null;
            try {
                FileUtils.forceMkdir((File)f.getParentFile());
                os = new FileOutputStream(f);
                IOUtils.write((byte[])resource, (OutputStream)os);
                IOUtils.closeQuietly((OutputStream)os);
                f2 = fm.getTemporaryFile(new String[]{"resources-storage", "jdbc", (String)key.getLeft(), "parameters"});
                byte[] data = this.getStoreParameters().toByteArray();
                os = new FileOutputStream(f2);
                IOUtils.write((byte[])data, (OutputStream)os);
            }
            catch (IOException ex) {
                try {
                    FileUtils.deleteQuietly((File)f);
                    FileUtils.deleteQuietly(f2);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(os);
                    throw throwable;
                }
                IOUtils.closeQuietly((OutputStream)os);
            }
            IOUtils.closeQuietly((OutputStream)os);
        }

        private InputStream getInputStream() throws IOException {
            try {
                byte[] resource = this.retrieveResource();
                ByteArrayInputStream is = new ByteArrayInputStream(resource);
                return is;
            }
            catch (Throwable ex) {
                LOGGER.warn("Can't access to the resoure '" + this.getURL() + "'.", ex);
                return null;
            }
        }

        public InputStream asInputStream() throws IOException {
            if (this.in != null || this.out != null) {
                throw new IllegalStateException("Resource is already open (" + this.getURL() + ")");
            }
            InputStream is = this.getInputStreamFromCache();
            if (is == null && (is = this.getInputStream()) == null) {
                return null;
            }
            this.in = is;
            return new ResourceInputStream();
        }

        public OutputStream asOutputStream() throws IOException {
            if (this.in != null || this.out != null) {
                throw new IllegalStateException("Resource is already open (" + this.getURL() + ").");
            }
            this.out = this.isReadOnly() ? NullOutputStream.NULL_OUTPUT_STREAM : new ByteArrayOutputStream();
            return new ResourceOutputStream();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        public void close() {
            if (this.in != null) {
                IOUtils.closeQuietly((InputStream)this.in);
                this.in = null;
            }
            if (!this.isReadOnly() && this.out != null) {
                FeatureStore store = null;
                byte[] data = null;
                try {
                    DataManager dataManager = DALLocator.getDataManager();
                    store = (FeatureStore)dataManager.openStore(this.storage.getTransaction(), this.getStoreParameters().getDataStoreName(), (DataStoreParameters)this.getStoreParameters());
                    data = ((ByteArrayOutputStream)this.out).toByteArray();
                    store.edit();
                    ExpressionBuilder builder = ExpressionUtils.createExpressionBuilder();
                    String filter = StringUtils.equalsIgnoreCase((CharSequence)this.getTableName(), (CharSequence)JDBCResourcesStorage.TABLENAME_SERVER_EXPLORER_MARK) ? builder.eq((ExpressionBuilder.Value)builder.column("name"), (ExpressionBuilder.Value)builder.constant((Object)this.name)).toString() : builder.eq((ExpressionBuilder.Value)builder.column("name"), (ExpressionBuilder.Value)builder.constant((Object)(this.getTableName() + "." + this.name))).toString();
                    Feature feature = store.findFirst(filter);
                    if (feature == null) {
                        EditableFeature efeature = store.createNewFeature();
                        if (StringUtils.equalsIgnoreCase((CharSequence)this.getTableName(), (CharSequence)JDBCResourcesStorage.TABLENAME_SERVER_EXPLORER_MARK)) {
                            efeature.set("name", (Object)this.name);
                        } else {
                            efeature.set("name", (Object)(this.getTableName() + "." + this.name));
                        }
                        efeature.set("resource", (Object)data);
                        store.insert(efeature);
                    } else {
                        EditableFeature efeature = feature.getEditable();
                        efeature.set("resource", (Object)data);
                        store.update(efeature);
                    }
                    store.finishEditing();
                    this.removeCache();
                }
                catch (SQLRuntimeException ex) {
                    block13: {
                        FeatureStore.cancelEditingQuietly(store);
                        if (!ex.isTableOrViewNotFound()) {
                            LOGGER.warn("Can't write the resource '" + this.getURL() + "'.", (Throwable)ex);
                        }
                        if (this.storage.alternativeStorage == null) break block13;
                        this.storage.alternativeStorage.add(this.name, (InputStream)new ByteArrayInputStream(data));
                    }
                    DisposeUtils.disposeQuietly((Disposable)store);
                }
                catch (Throwable ex2) {
                    block14: {
                        FeatureStore.cancelEditingQuietly(store);
                        LOGGER.warn("Can't write the resource '" + this.getURL() + "'.", ex2);
                        if (this.storage.alternativeStorage == null) break block14;
                        this.storage.alternativeStorage.add(this.name, (InputStream)new ByteArrayInputStream(data));
                        {
                            catch (Throwable throwable) {
                                DisposeUtils.disposeQuietly(store);
                                throw throwable;
                            }
                        }
                    }
                    DisposeUtils.disposeQuietly((Disposable)store);
                }
                DisposeUtils.disposeQuietly((Disposable)store);
            }
        }

        private class ResourceOutputStream
        extends OutputStream {
            private ResourceOutputStream() {
            }

            @Override
            public void write(int b) throws IOException {
                DataBaseResource.this.out.write(b);
            }

            @Override
            public void flush() throws IOException {
                DataBaseResource.this.out.flush();
            }

            @Override
            public void close() throws IOException {
                DataBaseResource.this.close();
            }
        }

        private class ResourceInputStream
        extends InputStream {
            private ResourceInputStream() {
            }

            @Override
            public int read() throws IOException {
                return DataBaseResource.this.in.read();
            }

            @Override
            public void close() throws IOException {
                DataBaseResource.this.close();
            }
        }
    }

    private static class ExistsResourcesCache
    extends CachedValue<Map<String, Boolean>> {
        private ExistsResourcesCache() {
        }

        protected void reload() {
            this.setValue(new HashMap());
        }
    }
}

