/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.store.jdbc2.spi.operations;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Collections;
import java.util.List;
import org.gvsig.expressionevaluator.ExpressionBuilder;
import org.gvsig.expressionevaluator.GeometryExpressionBuilder;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.feature.FeatureAttributeDescriptor;
import org.gvsig.fmap.dal.feature.FeatureType;
import org.gvsig.fmap.dal.feature.exception.AlreadyEditingException;
import org.gvsig.fmap.dal.feature.spi.FeatureProvider;
import org.gvsig.fmap.dal.store.jdbc.exception.JDBCPreparingSQLException;
import org.gvsig.fmap.dal.store.jdbc2.JDBCConnection;
import org.gvsig.fmap.dal.store.jdbc2.JDBCHelper;
import org.gvsig.fmap.dal.store.jdbc2.JDBCUtils;
import org.gvsig.fmap.dal.store.jdbc2.OperationsFactory;
import org.gvsig.fmap.dal.store.jdbc2.spi.JDBCSQLBuilderBase;
import org.gvsig.tools.dispose.Disposable;
import org.gvsig.tools.dispose.DisposeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AppendOperation {
    protected static final Logger LOGGER = LoggerFactory.getLogger(AppendOperation.class);
    protected JDBCConnection connection = null;
    protected final JDBCHelper helper;
    protected final OperationsFactory.TableReference table;
    protected final FeatureType type;
    protected JDBCSQLBuilderBase sqlbuilder = null;
    protected GeometryExpressionBuilder expbuilder;
    protected PreparedStatement preparedStatement;
    protected String insertSQL;
    protected int batchCount;
    private int batchSize;
    private final Disposable[] disposableParameters;

    public AppendOperation(JDBCHelper helper, OperationsFactory.TableReference table, FeatureType type) {
        this.helper = helper;
        this.table = table;
        this.type = type;
        this.batchSize = this.helper.getConnectionParameters().getBatchSize();
        this.disposableParameters = this.batchSize > 0 ? new Disposable[this.batchSize] : null;
    }

    public void begin(int submode) throws DataException {
        if (this.sqlbuilder != null) {
            throw new AlreadyEditingException(this.helper.getSourceId());
        }
        try {
            this.connection = this.helper.getConnectionWritable();
            switch (submode) {
                case 2: {
                    this.insertSQL = this.getMergeSQL();
                    break;
                }
                default: {
                    this.insertSQL = this.getInsertSQL();
                }
            }
            if (this.connection != null) {
                this.preparedStatement = this.connection.prepareStatement(this.insertSQL);
                this.connection.begin();
                for (String sql : this.getPreviousSQLs()) {
                    this.connection.execute(sql);
                }
            }
        }
        catch (SQLException ex) {
            throw new JDBCPreparingSQLException(this.sqlbuilder.toString(), ex);
        }
    }

    protected String getInsertSQL() {
        this.sqlbuilder = this.helper.createSQLBuilder();
        this.expbuilder = this.sqlbuilder.expression();
        this.sqlbuilder.insert().table().database(this.table.getDatabase()).schema(this.table.getSchema()).name(this.table.getTable());
        for (FeatureAttributeDescriptor attr : this.type) {
            if (attr.isAutomatic() || attr.isComputed()) continue;
            if (attr.getType() == 66) {
                this.sqlbuilder.insert().column().name(attr.getName()).with_value((ExpressionBuilder.Value)this.expbuilder.parameter(attr.getName()).as_geometry_variable().srs((ExpressionBuilder.Value)this.expbuilder.parameter().value((Object)attr.getSRS())));
                continue;
            }
            this.sqlbuilder.insert().column().name(attr.getName()).with_value((ExpressionBuilder.Value)this.expbuilder.parameter(attr.getName()).as_variable());
        }
        return this.sqlbuilder.insert().toString();
    }

    protected String getMergeSQL() {
        this.sqlbuilder = this.helper.createSQLBuilder();
        this.expbuilder = this.sqlbuilder.expression();
        this.sqlbuilder.merge().table().database(this.table.getDatabase()).schema(this.table.getSchema()).name(this.table.getTable());
        for (FeatureAttributeDescriptor pk : this.type.getPrimaryKey()) {
            this.sqlbuilder.merge().key(pk.getName());
        }
        for (FeatureAttributeDescriptor attr : this.type) {
            if (attr.isAutomatic() || attr.isComputed()) continue;
            if (attr.getType() == 66) {
                this.sqlbuilder.merge().column().name(attr.getName()).with_value((ExpressionBuilder.Value)this.expbuilder.parameter(attr.getName()).as_geometry_variable().srs((ExpressionBuilder.Value)this.expbuilder.parameter().value((Object)attr.getSRS())));
                continue;
            }
            this.sqlbuilder.merge().column().name(attr.getName()).with_value((ExpressionBuilder.Value)this.expbuilder.parameter(attr.getName()).as_variable());
        }
        return this.sqlbuilder.merge().toString();
    }

    protected void clean() {
        if (this.batchCount > 0) {
            this.clearBatch();
        }
        JDBCUtils.closeQuietly(this.preparedStatement);
        if (this.connection != null) {
            this.connection.closeQuietly();
            this.connection = null;
        }
        this.preparedStatement = null;
        this.sqlbuilder = null;
        this.insertSQL = null;
    }

    public void end() {
        try {
            if (this.connection == null) {
                return;
            }
            if (this.batchCount > 0) {
                this.executeBatch();
            }
            this.connection.commit();
            for (String sql : this.getPostSQLs()) {
                this.connection.execute(sql);
            }
        }
        catch (Exception ex) {
            try {
                this.connection.rollback();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new RuntimeException("Can't commit transaction", ex);
        }
        finally {
            this.clean();
        }
    }

    public void abort() {
        try {
            if (this.connection == null) {
                return;
            }
            if (this.batchCount > 0) {
                this.clearBatch();
            }
            this.connection.rollback();
            for (String sql : this.getPostSQLs()) {
                this.connection.execute(sql);
            }
        }
        catch (Exception ex) {
            LOGGER.debug("", (Throwable)ex);
        }
        finally {
            this.clean();
        }
    }

    public String getSQL() {
        return this.insertSQL;
    }

    public List<String> getPreviousSQLs() {
        return Collections.EMPTY_LIST;
    }

    public List<String> getPostSQLs() {
        return Collections.EMPTY_LIST;
    }

    public List<Object> getSQLParameters(FeatureProvider feature) {
        return this.sqlbuilder.getParameters(feature);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void append(FeatureProvider feature) throws DataException {
        block6: {
            try {
                Disposable theParametersDisposable;
                block7: {
                    if (this.batchSize > 0) {
                        this.addBatch(feature);
                        if (this.batchCount >= this.batchSize) {
                            this.executeBatch();
                        }
                        break block6;
                    }
                    theParametersDisposable = null;
                    try {
                        theParametersDisposable = this.sqlbuilder.setParameters(this.preparedStatement, feature);
                        int n = JDBCUtils.executeUpdate(this.preparedStatement, this.insertSQL);
                        if (n >= 1) break block7;
                        throw new RuntimeException("Can't insert feature (n=" + n + ").");
                    }
                    catch (Throwable throwable) {
                        DisposeUtils.disposeQuietly(theParametersDisposable);
                        throw throwable;
                    }
                }
                DisposeUtils.disposeQuietly((Disposable)theParametersDisposable);
            }
            catch (Exception ex) {
                throw new RuntimeException("Can't insert feature.", ex);
            }
        }
    }

    private void addBatch(FeatureProvider feature) throws SQLException {
        Disposable theParametersDisposable = this.sqlbuilder.setParameters(this.preparedStatement, feature);
        JDBCUtils.addBatch(this.preparedStatement, this.insertSQL);
        this.disposableParameters[this.batchCount++] = theParametersDisposable;
    }

    private void executeBatch() throws SQLException {
        int[] status = JDBCUtils.executeBatch(this.preparedStatement, this.insertSQL);
        this.clearBatch();
        for (int n : status) {
            if (n > -3) continue;
            throw new RuntimeException("Can't insert feature (n=" + n + ").");
        }
    }

    private void clearBatch() {
        try {
            this.preparedStatement.clearParameters();
            this.preparedStatement.clearBatch();
            for (int i = 0; i < this.batchCount && i < this.disposableParameters.length; ++i) {
                DisposeUtils.dispose((Disposable)this.disposableParameters[i]);
                this.disposableParameters[i] = null;
            }
            this.batchCount = 0;
        }
        catch (SQLException ex) {
            LOGGER.warn("Can't clear batch statement", (Throwable)ex);
        }
    }
}

