/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.store.jdbc2.spi.operations;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.commons.lang3.StringUtils;
import org.cresques.cts.IProjection;
import org.gvsig.expressionevaluator.ExpressionBuilder;
import org.gvsig.expressionevaluator.GeometryExpressionBuilder;
import org.gvsig.fmap.dal.SQLBuilder;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.feature.FeatureType;
import org.gvsig.fmap.dal.store.jdbc.exception.JDBCSQLException;
import org.gvsig.fmap.dal.store.jdbc2.JDBCConnection;
import org.gvsig.fmap.dal.store.jdbc2.JDBCHelper;
import org.gvsig.fmap.dal.store.jdbc2.JDBCUtils;
import org.gvsig.fmap.dal.store.jdbc2.OperationsFactory;
import org.gvsig.fmap.dal.store.jdbc2.spi.JDBCSQLBuilderBase;
import org.gvsig.fmap.dal.store.jdbc2.spi.operations.AbstractConnectionOperation;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.GeometryUtils;
import org.gvsig.fmap.geom.primitive.Envelope;

public class CalculateEnvelopeOfColumnOperation
extends AbstractConnectionOperation {
    protected final OperationsFactory.TableReference table;
    protected final String columnName;
    protected final String baseFilter;
    protected final Envelope limit;
    protected final IProjection crs;
    protected final FeatureType featureType;

    public CalculateEnvelopeOfColumnOperation(JDBCHelper helper, FeatureType featureType, OperationsFactory.TableReference table, String columnName, String baseFilter, Envelope limit, IProjection crs) {
        super(helper);
        this.featureType = featureType;
        this.table = table;
        this.columnName = columnName;
        this.baseFilter = baseFilter;
        this.limit = limit;
        this.crs = crs;
    }

    @Override
    public final Object perform(JDBCConnection conn) throws DataException {
        Envelope env = this.calculateEnvelopeOfColumn(conn);
        return env;
    }

    public String getSQL() {
        if (this.helper.hasSpatialFunctions()) {
            return this.getSQLWithAggregate();
        }
        return this.getSQLWihoutAggregate();
    }

    public String getSQLWihoutAggregate() {
        JDBCSQLBuilderBase sqlbuilder = this.createSQLBuilder();
        GeometryExpressionBuilder expbuilder = sqlbuilder.expression();
        sqlbuilder.select().from().table().database(this.table.getDatabase()).schema(this.table.getSchema()).name(this.table.getTable());
        sqlbuilder.select().column().name(this.columnName).as_geometry();
        sqlbuilder.select().from().subquery(this.table.getSubquery());
        if (!StringUtils.isEmpty((CharSequence)this.baseFilter)) {
            sqlbuilder.select().where().set((ExpressionBuilder.Value)expbuilder.custom((Object)this.baseFilter));
        }
        sqlbuilder.select().where().and((ExpressionBuilder.Value)expbuilder.not_is_null((ExpressionBuilder.Value)expbuilder.column(this.columnName)));
        String sql = sqlbuilder.select().toString();
        return sql;
    }

    public String getSQLWithAggregate() {
        JDBCSQLBuilderBase sqlbuilder = this.createSQLBuilder();
        GeometryExpressionBuilder expbuilder = sqlbuilder.expression();
        SQLBuilder.SelectBuilder select = sqlbuilder.select();
        select.from().table().database(this.table.getDatabase()).schema(this.table.getSchema()).name(this.table.getTable());
        select.column().value(expbuilder.as_geometry((ExpressionBuilder.Value)expbuilder.ST_ExtentAggregate((ExpressionBuilder.Value)sqlbuilder.column(select.from().table(), this.columnName))));
        select.from().subquery(this.table.getSubquery());
        if (StringUtils.isEmpty((CharSequence)this.baseFilter)) {
            if (this.limit != null) {
                select.where().set((ExpressionBuilder.Value)expbuilder.ST_Intersects((ExpressionBuilder.Value)expbuilder.ST_Envelope((ExpressionBuilder.Value)sqlbuilder.column(select.from().table(), this.columnName)), (ExpressionBuilder.Value)expbuilder.ST_Envelope((ExpressionBuilder.Value)expbuilder.geometry(this.limit.getGeometry(), this.crs))));
            }
        } else {
            select.where().set((ExpressionBuilder.Value)expbuilder.custom((Object)this.baseFilter));
            if (this.limit != null) {
                select.where().and((ExpressionBuilder.Value)expbuilder.ST_Intersects((ExpressionBuilder.Value)expbuilder.ST_Envelope((ExpressionBuilder.Value)sqlbuilder.column(select.from().table(), this.columnName)), (ExpressionBuilder.Value)expbuilder.ST_Envelope((ExpressionBuilder.Value)expbuilder.geometry(this.limit.getGeometry(), this.crs))));
            }
        }
        select.where().and((ExpressionBuilder.Value)expbuilder.not_is_null((ExpressionBuilder.Value)sqlbuilder.column(select.from().table(), this.columnName)));
        this.helper.processSpecialFunctions((SQLBuilder)sqlbuilder, this.featureType, null, null);
        sqlbuilder.setProperties(ExpressionBuilder.Variable.class, new Object[]{"Table", this.table});
        String sql = sqlbuilder.select().toString();
        return sql;
    }

    public Envelope calculateEnvelopeOfColumn(JDBCConnection conn) throws DataException {
        if (this.helper.hasSpatialFunctions()) {
            return this.calculateEnvelopeOfColumnWithAggregate(conn);
        }
        return this.calculateEnvelopeOfColumnWithoutAggregate(conn);
    }

    protected Envelope calculateEnvelopeOfColumnWithAggregate(JDBCConnection conn) throws DataException {
        Envelope envelope;
        Geometry geom;
        ResultSet rs;
        Statement st;
        String sql;
        block10: {
            block9: {
                sql = this.getSQL();
                st = null;
                rs = null;
                st = conn.createStatement(sql);
                try {
                    LOGGER.debug("execute query SQL:" + sql);
                    rs = st.executeQuery(sql);
                }
                catch (SQLException ex) {
                    LOGGER.warn("Fail executing sql: " + sql, (Throwable)ex);
                    Envelope envelope2 = null;
                    JDBCUtils.closeQuietly(st);
                    JDBCUtils.closeQuietly(rs);
                    return envelope2;
                }
                if (rs.next()) break block9;
                Envelope ex = null;
                JDBCUtils.closeQuietly(st);
                JDBCUtils.closeQuietly(rs);
                return ex;
            }
            geom = this.helper.getGeometryFromColumn(rs, 1);
            if (geom != null) break block10;
            Envelope envelope3 = null;
            JDBCUtils.closeQuietly(st);
            JDBCUtils.closeQuietly(rs);
            return envelope3;
        }
        try {
            envelope = geom.getEnvelope();
        }
        catch (SQLException ex) {
            try {
                throw new JDBCSQLException(ex, sql);
            }
            catch (Throwable throwable) {
                JDBCUtils.closeQuietly(st);
                JDBCUtils.closeQuietly(rs);
                throw throwable;
            }
        }
        JDBCUtils.closeQuietly(st);
        JDBCUtils.closeQuietly(rs);
        return envelope;
    }

    protected Envelope calculateEnvelopeOfColumnWithoutAggregate(JDBCConnection conn) throws DataException {
        Envelope envelope;
        String sql = this.getSQL();
        Statement st = null;
        ResultSet rs = null;
        st = conn.createStatement(sql);
        try {
            LOGGER.debug("execute query SQL:" + sql);
            rs = st.executeQuery(sql);
        }
        catch (SQLException ex) {
            Envelope envelope2 = null;
            JDBCUtils.closeQuietly(st);
            JDBCUtils.closeQuietly(rs);
            return envelope2;
        }
        try {
            Envelope finalEnvelope = GeometryUtils.createEnvelope((int)0);
            while (rs.next()) {
                Geometry geometry = this.helper.getGeometryFromColumn(rs, 1);
                finalEnvelope.add(geometry);
            }
            envelope = finalEnvelope;
        }
        catch (SQLException ex) {
            try {
                throw new JDBCSQLException(ex, sql);
            }
            catch (Throwable throwable) {
                JDBCUtils.closeQuietly(st);
                JDBCUtils.closeQuietly(rs);
                throw throwable;
            }
        }
        JDBCUtils.closeQuietly(st);
        JDBCUtils.closeQuietly(rs);
        return envelope;
    }
}

