/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.store.jdbc2.spi.operations;

import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.cresques.cts.IProjection;
import org.gvsig.expressionevaluator.ExpressionBuilder;
import org.gvsig.expressionevaluator.GeometryExpressionBuilder;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.feature.EditableFeatureAttributeDescriptor;
import org.gvsig.fmap.dal.feature.EditableFeatureType;
import org.gvsig.fmap.dal.store.jdbc.exception.SQLRuntimeException;
import org.gvsig.fmap.dal.store.jdbc2.JDBCConnection;
import org.gvsig.fmap.dal.store.jdbc2.JDBCHelper;
import org.gvsig.fmap.dal.store.jdbc2.JDBCUtils;
import org.gvsig.fmap.dal.store.jdbc2.OperationsFactory;
import org.gvsig.fmap.dal.store.jdbc2.spi.JDBCSQLBuilderBase;
import org.gvsig.fmap.dal.store.jdbc2.spi.operations.AbstractConnectionOperation;
import org.gvsig.fmap.geom.GeometryLocator;
import org.gvsig.fmap.geom.type.GeometryType;

public class FetchFeatureTypeOperation
extends AbstractConnectionOperation {
    protected final EditableFeatureType featureType;
    protected final OperationsFactory.TableReference table;
    protected final List<String> primaryKeys;
    protected final String defaultGeometryColumn;
    protected final IProjection crs;
    protected final int geometryType;
    protected final int geometrySubtype;
    protected Map<String, IndexInformation> indexesInformation;

    public FetchFeatureTypeOperation(JDBCHelper helper) {
        this(helper, null, null, null, null, null, -1, 4);
    }

    public FetchFeatureTypeOperation(JDBCHelper helper, EditableFeatureType featureType, String defaultGeometryColumn, IProjection crs) {
        this(helper, featureType, null, null, defaultGeometryColumn, crs, -1, 4);
    }

    public FetchFeatureTypeOperation(JDBCHelper helper, EditableFeatureType featureType, OperationsFactory.TableReference table, List<String> primaryKeys, String defaultGeometryColumn, IProjection crs, int geometryType, int geometrySubtype) {
        super(helper);
        this.featureType = featureType;
        this.table = table;
        this.primaryKeys = primaryKeys;
        this.defaultGeometryColumn = defaultGeometryColumn;
        this.crs = crs;
        this.geometryType = geometryType;
        this.geometrySubtype = geometrySubtype;
    }

    @Override
    public final Object perform(JDBCConnection conn) throws DataException {
        this.fetch(conn);
        return true;
    }

    protected OperationsFactory.TableReference getTable() {
        return this.table;
    }

    public void fetch(JDBCConnection conn) throws DataException {
        List<String> pks = this.primaryKeys;
        Statement st = null;
        ResultSet rs = null;
        try {
            if (CollectionUtils.isEmpty(pks)) {
                if (this.table.hasSubquery()) {
                    // empty if block
                }
                if (CollectionUtils.isEmpty(pks = this.getPrimaryKeysFromMetadata(conn, null, this.table.getSchema(), this.table.getTable()))) {
                    pks = this.getPrimaryKeysFromInformationSchema(conn);
                }
            }
            String sql = this.getSQLToRetrieveMetadataOfTable();
            st = conn.createStatement(sql);
            st.setFetchSize(1);
            rs = JDBCUtils.executeQuery(st, sql);
            ResultSetMetaData rsMetadata = rs.getMetaData();
            this.fetchFeatureTypeFromMetadata(conn, rsMetadata, pks);
        }
        catch (SQLException ex) {
            try {
                throw new SQLRuntimeException("Can't fecth feature type.", ex);
            }
            catch (Throwable throwable) {
                JDBCUtils.closeQuietly(rs);
                JDBCUtils.closeQuietly(st);
                throw throwable;
            }
        }
        JDBCUtils.closeQuietly(rs);
        JDBCUtils.closeQuietly(st);
    }

    public String getSQLToRetrieveMetadataOfTable() {
        JDBCSQLBuilderBase sqlbuilder = this.createSQLBuilder();
        sqlbuilder.select().column().all();
        sqlbuilder.select().from().table().database(this.table.getDatabase()).schema(this.table.getSchema()).name(this.table.getTable());
        sqlbuilder.select().limit(0L);
        String sql = sqlbuilder.toString();
        return sql;
    }

    public void fetchFeatureTypeFromMetadata(JDBCConnection conn, ResultSetMetaData rsMetadata) throws SQLException {
        this.fetchFeatureTypeFromMetadata(conn, rsMetadata, new ArrayList<String>());
    }

    protected void fetchFeatureTypeFromMetadata(JDBCConnection conn, ResultSetMetaData rsMetadata, List<String> pks) throws SQLException {
        EditableFeatureAttributeDescriptor geomattr;
        int geometriesColumns = 0;
        String lastGeometry = null;
        boolean firstGeometryAttrFound = false;
        for (int i = 1; i <= rsMetadata.getColumnCount(); ++i) {
            EditableFeatureAttributeDescriptor attr = this.getAttributeFromMetadata(this.featureType, conn, rsMetadata, i);
            if (this.isInPrimaryKeys(pks, attr)) {
                attr.setIsPrimaryKey(true);
            }
            if (attr.getType() != 66) continue;
            ++geometriesColumns;
            lastGeometry = attr.getName();
            if (firstGeometryAttrFound && !StringUtils.equalsIgnoreCase((CharSequence)lastGeometry, (CharSequence)this.defaultGeometryColumn)) continue;
            firstGeometryAttrFound = true;
            this.featureType.setDefaultGeometryAttributeName(lastGeometry);
        }
        if (StringUtils.isBlank((CharSequence)this.defaultGeometryColumn)) {
            if (geometriesColumns == 1) {
                this.featureType.setDefaultGeometryAttributeName(lastGeometry);
            }
        } else if (!StringUtils.equalsIgnoreCase((CharSequence)this.defaultGeometryColumn, (CharSequence)this.featureType.getDefaultGeometryAttributeName()) && (geomattr = this.featureType.getEditableAttributeDescriptor(this.defaultGeometryColumn)).getDataType().getType() != 66) {
            geomattr.setDataType(66);
            geomattr.setGeometryType(0, 0);
        }
        if (this.featureType.getDefaultGeometryAttribute() != null) {
            EditableFeatureAttributeDescriptor attrGeom = (EditableFeatureAttributeDescriptor)this.featureType.getDefaultGeometryAttribute();
            if (this.crs != null) {
                attrGeom.setSRS(this.crs);
            }
            if (this.geometryType != -1 && this.geometrySubtype != 4) {
                attrGeom.setGeometryType(this.geometryType, this.geometrySubtype);
            } else if (this.geometryType != -1) {
                attrGeom.setGeometryType(this.geometryType, attrGeom.getGeomType().getSubType());
            } else if (this.geometrySubtype != 4) {
                attrGeom.setGeometryType(attrGeom.getGeomType().getType(), this.geometrySubtype);
            }
        }
    }

    protected boolean isInPrimaryKeys(List<String> pks, EditableFeatureAttributeDescriptor attr) {
        if (pks == null || attr == null) {
            return false;
        }
        for (String pk : pks) {
            if (!StringUtils.equalsIgnoreCase((CharSequence)pk, (CharSequence)attr.getName())) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected List<String> getPrimaryKeysFromMetadata(JDBCConnection conn, String catalog, String schema, String table) throws SQLException {
        ArrayList<String> arrayList;
        ResultSet rs;
        ResultSet rsPrimaryKeys;
        block17: {
            List<String> list;
            block16: {
                List<String> list2;
                block15: {
                    List<String> list3;
                    block14: {
                        rsPrimaryKeys = null;
                        rs = null;
                        try {
                            DatabaseMetaData metadata = conn.getMetaData();
                            rs = metadata.getTables(catalog, schema, table, null);
                            if (!rs.next()) {
                                rs.close();
                                catalog = null;
                                schema = null;
                                rs = metadata.getTables(catalog, schema, table, null);
                                if (!rs.next()) {
                                    list3 = null;
                                    JDBCUtils.closeQuietly(rs);
                                    break block14;
                                }
                                if (rs.next()) {
                                    list2 = null;
                                    JDBCUtils.closeQuietly(rs);
                                    break block15;
                                }
                            } else if (rs.next()) {
                                list = null;
                                JDBCUtils.closeQuietly(rs);
                                break block16;
                            }
                            rsPrimaryKeys = metadata.getPrimaryKeys(catalog, schema, table);
                            ArrayList<String> pks = new ArrayList<String>();
                            while (rsPrimaryKeys.next()) {
                                pks.add(rsPrimaryKeys.getString("COLUMN_NAME"));
                            }
                            arrayList = pks;
                            JDBCUtils.closeQuietly(rs);
                            break block17;
                        }
                        catch (SQLException e) {
                            List<String> list4 = null;
                            return list4;
                        }
                    }
                    JDBCUtils.closeQuietly(rsPrimaryKeys);
                    return list3;
                }
                JDBCUtils.closeQuietly(rsPrimaryKeys);
                return list2;
            }
            JDBCUtils.closeQuietly(rsPrimaryKeys);
            return list;
        }
        JDBCUtils.closeQuietly(rsPrimaryKeys);
        return arrayList;
        finally {
            JDBCUtils.closeQuietly(rs);
            JDBCUtils.closeQuietly(rsPrimaryKeys);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected List<String> getPrimaryKeysFromInformationSchema(JDBCConnection conn) throws SQLException {
        ArrayList<String> arrayList;
        ResultSet rs;
        Statement st;
        block9: {
            List<String> list;
            block8: {
                String sql = this.getSQLToRetrievePrimaryKeysFromInformationSchema();
                st = null;
                rs = null;
                ArrayList<String> pks = new ArrayList<String>();
                try {
                    st = conn.createStatement(sql);
                    rs = JDBCUtils.executeQuery(st, sql);
                    while (rs.next()) {
                        pks.add(rs.getString(1));
                    }
                    if (pks.isEmpty()) {
                        list = null;
                        JDBCUtils.closeQuietly(rs);
                        break block8;
                    }
                    arrayList = pks;
                    JDBCUtils.closeQuietly(rs);
                    break block9;
                }
                catch (Exception ex) {
                    ArrayList<String> arrayList2 = pks;
                    return arrayList2;
                }
            }
            JDBCUtils.closeQuietly(st);
            return list;
        }
        JDBCUtils.closeQuietly(st);
        return arrayList;
        finally {
            JDBCUtils.closeQuietly(rs);
            JDBCUtils.closeQuietly(st);
        }
    }

    public String getSQLToRetrievePrimaryKeysFromInformationSchema() throws SQLException {
        JDBCSQLBuilderBase sqlbuilder = this.createSQLBuilder();
        GeometryExpressionBuilder expbuilder = sqlbuilder.expression();
        sqlbuilder.select().column().name("COLUMN_NAME");
        sqlbuilder.select().column().name("CONSTRAINT_TYPE");
        sqlbuilder.select().from().custom("INFORMATION_SCHEMA.table_constraints t_cons inner join INFORMATION_SCHEMA.key_column_usage c on c.constraint_catalog = t_cons.constraint_catalog and c.table_schema = t_cons.table_schema and c.table_name = t_cons.table_name and c.constraint_name = t_cons.constraint_name ");
        sqlbuilder.select().where().set((ExpressionBuilder.Value)expbuilder.like((ExpressionBuilder.Value)expbuilder.custom((Object)"c.TABLE_NAME"), (ExpressionBuilder.Value)expbuilder.constant((Object)this.table.getTable())));
        if (this.table.hasSchema()) {
            sqlbuilder.select().where().and((ExpressionBuilder.Value)expbuilder.like((ExpressionBuilder.Value)expbuilder.custom((Object)"c.TABLE_SCHEMA"), (ExpressionBuilder.Value)expbuilder.constant((Object)this.table.getSchema())));
        }
        sqlbuilder.select().where().and((ExpressionBuilder.Value)expbuilder.eq((ExpressionBuilder.Value)expbuilder.column("CONSTRAINT_TYPE"), (ExpressionBuilder.Value)expbuilder.constant((Object)"PRIMARY KEY")));
        return sqlbuilder.toString();
    }

    protected EditableFeatureAttributeDescriptor getAttributeFromMetadata(EditableFeatureType type, JDBCConnection conn, ResultSetMetaData rsMetadata, int colIndex) throws SQLException {
        EditableFeatureAttributeDescriptor attr = type.add(rsMetadata.getColumnName(colIndex), this.getDataTypeFromMetadata(rsMetadata, colIndex));
        attr.setAllowNull(rsMetadata.isNullable(colIndex) == 1);
        attr.setIsAutomatic(rsMetadata.isAutoIncrement(colIndex));
        attr.setIsReadOnly(rsMetadata.isReadOnly(colIndex));
        switch (attr.getType()) {
            case 8: {
                attr.setSize(rsMetadata.getPrecision(colIndex));
                attr.setPrecision(-1);
                attr.setScale(-1);
                break;
            }
            case 2: {
                attr.setDisplaySize(rsMetadata.getColumnDisplaySize(colIndex));
                attr.setPrecision(3);
                attr.setScale(-1);
                break;
            }
            case 4: {
                attr.setDisplaySize(rsMetadata.getColumnDisplaySize(colIndex));
                attr.setPrecision(10);
                attr.setScale(-1);
                break;
            }
            case 5: {
                attr.setDisplaySize(rsMetadata.getColumnDisplaySize(colIndex));
                attr.setPrecision(19);
                attr.setScale(-1);
                break;
            }
            case 6: {
                attr.setDisplaySize(rsMetadata.getColumnDisplaySize(colIndex));
                attr.setPrecision(8);
                attr.setScale(-1);
                break;
            }
            case 7: {
                attr.setDisplaySize(rsMetadata.getColumnDisplaySize(colIndex));
                attr.setPrecision(16);
                attr.setScale(-1);
                break;
            }
            case 19: {
                attr.setDisplaySize(rsMetadata.getColumnDisplaySize(colIndex));
                attr.setScale(rsMetadata.getScale(colIndex));
                attr.setPrecision(rsMetadata.getPrecision(colIndex));
                break;
            }
            case 64: {
                attr.setAdditionalInfo("SQLType", String.valueOf(rsMetadata.getColumnType(colIndex)));
                attr.setAdditionalInfo("SQLTypeName", rsMetadata.getColumnTypeName(colIndex));
                break;
            }
            case 66: {
                this.fetchGeometryTypeAndSRS(attr, rsMetadata, colIndex);
            }
        }
        IndexInformation indexInformation = this.getIndexesInformation(conn).get(attr.getName());
        if (indexInformation != null) {
            attr.setIsIndexed(true);
            attr.setIsIndexAscending(indexInformation.ascending);
        }
        return attr;
    }

    protected Map<String, IndexInformation> getIndexesInformation(JDBCConnection conn) throws SQLException {
        if (this.indexesInformation == null) {
            ResultSet rsIndexes;
            this.indexesInformation = new HashMap<String, IndexInformation>();
            DatabaseMetaData metaData = conn.getMetaData();
            if (metaData != null && (rsIndexes = metaData.getIndexInfo(null, this.table.getSchema(), this.table.getTable(), false, false)) != null) {
                while (rsIndexes.next()) {
                    IndexInformation x = new IndexInformation();
                    x.column_name = rsIndexes.getString("COLUMN_NAME");
                    String asc_or_desc = rsIndexes.getString("ASC_OR_DESC");
                    if (StringUtils.isNotBlank((CharSequence)asc_or_desc)) {
                        x.ascending = asc_or_desc.equalsIgnoreCase("A");
                    }
                    x.unique = !rsIndexes.getBoolean("NON_UNIQUE");
                    this.indexesInformation.put(x.column_name, x);
                }
            }
        }
        return this.indexesInformation;
    }

    protected int getDataTypeFromMetadata(ResultSetMetaData rsMetadata, int colIndex) throws SQLException {
        switch (rsMetadata.getColumnType(colIndex)) {
            case -6: {
                return 2;
            }
            case 4: 
            case 5: {
                return 4;
            }
            case -5: {
                return 5;
            }
            case 6: {
                return 6;
            }
            case 7: 
            case 8: {
                return 7;
            }
            case 2: 
            case 3: {
                return 19;
            }
            case -1: 
            case 1: 
            case 12: 
            case 2005: {
                return 8;
            }
            case 91: {
                return 9;
            }
            case 92: {
                return 10;
            }
            case 93: {
                return 11;
            }
            case -7: 
            case 16: {
                return 1;
            }
            case -4: 
            case -2: 
            case 2004: {
                return 12;
            }
        }
        String typeName = rsMetadata.getColumnTypeName(colIndex);
        if ("geometry".equalsIgnoreCase(typeName)) {
            return 66;
        }
        return 64;
    }

    protected void fetchGeometryTypeAndSRS(EditableFeatureAttributeDescriptor attr, ResultSetMetaData rsMetadata, int colIndex) {
        if (attr.getType() != 66) {
            return;
        }
        try {
            GeometryType geomType = GeometryLocator.getGeometryManager().getGeometryType(0, 0);
            attr.setGeometryType(geomType);
            attr.setSRS((IProjection)null);
        }
        catch (Exception ex) {
            LOGGER.warn("Can't get default geometry type.", (Throwable)ex);
        }
    }

    protected static class IndexInformation {
        String column_name;
        boolean ascending;
        boolean unique;

        protected IndexInformation() {
        }
    }
}

