/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.store.jdbc2.spi.operations;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.expressionevaluator.Code;
import org.gvsig.expressionevaluator.Expression;
import org.gvsig.expressionevaluator.ExpressionBuilder;
import org.gvsig.expressionevaluator.ExpressionEvaluatorLocator;
import org.gvsig.expressionevaluator.ExpressionUtils;
import org.gvsig.expressionevaluator.GeometryExpressionBuilder;
import org.gvsig.expressionevaluator.SymbolTable;
import org.gvsig.fmap.dal.SQLBuilder;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.expressionevaluator.FeatureAttributeEmulatorExpression;
import org.gvsig.fmap.dal.feature.EditableFeatureAttributeDescriptor;
import org.gvsig.fmap.dal.feature.FeatureAttributeDescriptor;
import org.gvsig.fmap.dal.feature.FeatureAttributeEmulator;
import org.gvsig.fmap.dal.feature.FeatureQuery;
import org.gvsig.fmap.dal.feature.FeatureQueryOrder;
import org.gvsig.fmap.dal.feature.FeatureType;
import org.gvsig.fmap.dal.store.jdbc2.JDBCConnection;
import org.gvsig.fmap.dal.store.jdbc2.JDBCHelper;
import org.gvsig.fmap.dal.store.jdbc2.OperationsFactory;
import org.gvsig.fmap.dal.store.jdbc2.ResulSetControler;
import org.gvsig.fmap.dal.store.jdbc2.spi.JDBCSQLBuilderBase;
import org.gvsig.fmap.dal.store.jdbc2.spi.operations.AbstractConnectionOperation;
import org.gvsig.tools.dataTypes.DataTypeUtils;
import org.gvsig.tools.evaluator.Evaluator;
import org.gvsig.tools.util.ChainedIterable;

public class ResultSetForSetProviderOperation
extends AbstractConnectionOperation {
    private final OperationsFactory.TableReference table;
    private final String baseFilter;
    private final String baseOrder;
    private final FeatureType storeType;
    private final FeatureType setType;
    private final FeatureQuery query;
    private final long limit;
    private final long offset;
    private final int fetchSize;

    public ResultSetForSetProviderOperation(JDBCHelper helper, OperationsFactory.TableReference table, String baseFilter, String baseOrder, FeatureQuery query, FeatureType storeType, FeatureType setType, long limit, long offset, int fetchSize) {
        super(helper);
        this.table = table;
        this.baseFilter = baseFilter;
        this.baseOrder = baseOrder;
        this.storeType = storeType;
        this.setType = setType;
        this.query = query;
        this.limit = limit;
        this.offset = offset;
        this.fetchSize = fetchSize;
    }

    @Override
    protected Object perform_operation() throws Exception {
        ResulSetControler.ResultSetEntry rs = this.createResultSet();
        return rs;
    }

    @Override
    public Object perform(JDBCConnection conn) throws DataException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public String getSQL() {
        ArrayList<FeatureAttributeDescriptor> columns = new ArrayList<FeatureAttributeDescriptor>();
        JDBCSQLBuilderBase sqlbuilder = this.createSQLBuilder();
        String sql = this.getSQL(sqlbuilder, columns, null);
        return sql;
    }

    public String getSQL(JDBCSQLBuilderBase sqlbuilder, List<FeatureAttributeDescriptor> columns, List<String> extraColumnNames) {
        double tolerance = -1.0;
        GeometryExpressionBuilder expbuilder = sqlbuilder.expression();
        expbuilder.setProperty("FeatureType", (Object)this.storeType);
        expbuilder.setProperty("Table", (Object)this.table);
        expbuilder.setProperty("TableName", (Object)this.table.getTable());
        expbuilder.setProperty("SymbolTable", this.query == null ? null : this.query.getSymbolTable());
        expbuilder.setProperty("JDBCHelper", (Object)this.helper);
        expbuilder.setProperty("Query", (Object)this.query);
        SQLBuilder.SelectBuilder select = sqlbuilder.select();
        select.from().table().database(this.table.getDatabase()).schema(this.table.getSchema()).name(this.table.getTable());
        select.from().subquery(this.table.getSubquery());
        ArrayList<ExpressionBuilder.Value> valuesToRemoveFeatureType = new ArrayList<ExpressionBuilder.Value>();
        if (this.shouldUseACustomSelect()) {
            return this.processCustomSelect(select, (ExpressionBuilder)expbuilder, sqlbuilder, valuesToRemoveFeatureType, columns);
        }
        Map<String, EditableFeatureAttributeDescriptor> allExtraColumns = ResultSetForSetProviderOperation.getAllExtraColumns(this.setType, this.query);
        ArrayList<String> primaryKeys = new ArrayList<String>();
        for (FeatureAttributeDescriptor attr : this.storeType.getPrimaryKey()) {
            primaryKeys.add(attr.getName());
        }
        ResultSetForSetProviderOperation.process1_SimpleFields(this.helper, this.setType, this.query, (SQLBuilder)sqlbuilder, select, columns, primaryKeys, extraColumnNames);
        ResultSetForSetProviderOperation.process2_ComputedFields(this.helper, this.setType, this.query, (SQLBuilder)sqlbuilder, select, extraColumnNames);
        ResultSetForSetProviderOperation.process3_Where(this.helper, this.storeType, this.query, (SQLBuilder)sqlbuilder, select);
        ResultSetForSetProviderOperation.process4_Aggregates(this.table, this.setType, this.query, allExtraColumns, (SQLBuilder)sqlbuilder, select, extraColumnNames);
        ResultSetForSetProviderOperation.process5_GroupBys(this.table, this.setType, this.query, allExtraColumns, (SQLBuilder)sqlbuilder, select, extraColumnNames);
        ResultSetForSetProviderOperation.process6_OrderBy(this.storeType, this.setType, this.query, allExtraColumns, (SQLBuilder)sqlbuilder, select, primaryKeys, extraColumnNames, valuesToRemoveFeatureType);
        if (!StringUtils.isEmpty((CharSequence)this.baseFilter)) {
            select.where().and(expbuilder.toValue(this.baseFilter));
        }
        if (!StringUtils.isEmpty((CharSequence)this.baseOrder)) {
            select.order_by().custom(this.baseOrder);
        }
        if (this.limit > 0L) {
            select.limit(this.limit);
        } else {
            select.limit(this.query == null ? null : Long.valueOf(this.query.getLimit()));
        }
        if (this.offset > 0L) {
            select.offset(this.offset);
        }
        sqlbuilder.setProperties(null, new Object[]{"FeatureType", this.storeType, "Table", this.table, "SymbolTable", this.query == null ? null : this.query.getSymbolTable(), "JDBCHelper", this.helper, "Query", this.query});
        for (ExpressionBuilder.Value value : valuesToRemoveFeatureType) {
            value.setProperty("FeatureType", null);
        }
        this.helper.expandCalculedColumns(sqlbuilder);
        this.helper.processSpecialFunctions((SQLBuilder)sqlbuilder, this.storeType, extraColumnNames, this.query);
        String sql = StringUtils.trim((String)sqlbuilder.toString());
        LOGGER.debug(sql);
        return sql;
    }

    private String processCustomSelect(SQLBuilder.SelectBuilder select, ExpressionBuilder expbuilder, JDBCSQLBuilderBase sqlbuilder, List<ExpressionBuilder.Value> valuesToRemoveFeatureType, List<FeatureAttributeDescriptor> columns) {
        Object order;
        String sql = this.table.getSubquery();
        if (StringUtils.containsAny((CharSequence)sql, (CharSequence[])new CharSequence[]{"${where_filter}", "${and_filter}"})) {
            Object sqlfilter;
            Evaluator filter = this.query.getFilter();
            if (filter != null && !StringUtils.isEmpty((CharSequence)(sqlfilter = filter.getSQL())) && this.helper.supportFilter(this.storeType, filter)) {
                select.where().set(expbuilder.toValue((String)sqlfilter));
            }
            if (!StringUtils.isEmpty((CharSequence)this.baseFilter)) {
                select.where().and(expbuilder.toValue(this.baseFilter));
            }
        }
        if (StringUtils.containsAny((CharSequence)sql, (CharSequence[])new CharSequence[]{"${order_by_orderspec}", "${comma_orderspec}"}) && (order = this.query.getOrder()) != null) {
            for (FeatureQueryOrder.FeatureQueryOrderMember member : order.members()) {
                String attrName = member.getAttributeName();
                ExpressionBuilder.Variable col = expbuilder.column(attrName);
                select.order_by().value((ExpressionBuilder.Value)col).ascending(member.getAscending());
            }
        }
        if (select.has_where() || select.has_order_by()) {
            String s;
            sqlbuilder.setProperties(null, new Object[]{"FeatureType", this.storeType, "Table", this.table, "SymbolTable", this.query == null ? null : this.query.getSymbolTable(), "JDBCHelper", this.helper, "Query", this.query});
            for (ExpressionBuilder.Value value : valuesToRemoveFeatureType) {
                value.setProperty("FeatureType", null);
            }
            if (select.has_where()) {
                s = select.where().toString();
                sql = StringUtils.replace((String)sql, (String)"${where_filter}", (String)("WHERE " + s));
                sql = StringUtils.replace((String)sql, (String)"${and_filter}", (String)("AND (" + s + ")"));
            }
            if (select.has_order_by()) {
                s = select.order_by().toString();
                sql = StringUtils.replace((String)sql, (String)"${order_by_orderspec}", (String)("ORDER BY " + s));
                sql = StringUtils.replace((String)sql, (String)"${comma_orderspec}", (String)(", " + s));
            }
        }
        for (FeatureAttributeDescriptor attr : this.storeType) {
            columns.add(attr);
        }
        return sql;
    }

    public static void process1_SimpleFields(JDBCHelper helper, FeatureType setType, FeatureQuery query, SQLBuilder sqlbuilder, SQLBuilder.SelectBuilder select, List<FeatureAttributeDescriptor> columns, List<String> primaryKeys, List<String> extraColumnNames) {
        if (!select.from().table().has_name()) {
            throw new IllegalStateException("Need table in FROM.");
        }
        GeometryExpressionBuilder expbuilder = sqlbuilder.expression();
        ArrayList<String> forcedColumns = new ArrayList<String>(primaryKeys);
        Object[] constantsAttributeNames = null;
        if (query != null && query.hasConstantsAttributeNames()) {
            constantsAttributeNames = query.getConstantsAttributeNames();
        }
        for (FeatureAttributeDescriptor attr : setType) {
            if (attr.isComputed()) continue;
            if (attr.isPrimaryKey()) {
                forcedColumns.remove(attr.getName());
            }
            if (ArrayUtils.contains((Object[])constantsAttributeNames, (Object)attr.getName()) && !attr.isPrimaryKey()) {
                select.column().name(attr.getName()).value((ExpressionBuilder.Value)ExpressionBuilder.VALUE_NULL).as(attr.getName());
            } else if (attr.getType() == 66) {
                select.column().name(attr.getName()).as_geometry();
            } else {
                select.column().name(attr.getName());
            }
            columns.add(attr);
        }
        if (query == null || !query.hasGroupByColumns()) {
            for (String attrName : forcedColumns) {
                select.column().name(attrName);
                FeatureAttributeDescriptor attr = setType.getAttributeDescriptor(attrName);
                if (attr == null) continue;
                columns.add(attr);
            }
        }
    }

    public static void process2_ComputedFields(JDBCHelper helper, FeatureType setType, FeatureQuery query, SQLBuilder sqlbuilder, SQLBuilder.SelectBuilder select, List<String> extraColumnNames) {
        if (!select.from().table().has_name()) {
            throw new IllegalStateException("Need table in FROM.");
        }
        for (FeatureAttributeDescriptor attr : ResultSetForSetProviderOperation.attributeDescriptorsIterable(setType, query)) {
            ExpressionBuilder.Value value;
            FeatureAttributeEmulatorExpression x;
            Expression exp;
            FeatureAttributeEmulator attrEmulator;
            if (!attr.isComputed() || !((attrEmulator = attr.getFeatureAttributeEmulator()) instanceof FeatureAttributeEmulatorExpression) || (exp = (x = (FeatureAttributeEmulatorExpression)attrEmulator).getExpression()) == null || exp.isEmpty() || !helper.supportExpression(setType, exp.getPhrase()) || (value = ResultSetForSetProviderOperation.createValueFromAttribute(sqlbuilder, attr, select.from().table())) == ExpressionBuilder.VALUE_NULL) continue;
            select.column().name(attr.getName()).value(value).as(attr.getName());
            if (extraColumnNames != null && !extraColumnNames.contains(attr.getName())) {
                extraColumnNames.add(attr.getName());
            }
            ResultSetForSetProviderOperation.addTableNameToColumns(sqlbuilder, value, true);
        }
    }

    public static void process4_Aggregates(OperationsFactory.TableReference table, FeatureType setType, FeatureQuery query, Map<String, EditableFeatureAttributeDescriptor> allExtraColumns, SQLBuilder sqlbuilder, SQLBuilder.SelectBuilder select, List<String> extraColumnNames) throws RuntimeException {
        if (query == null) {
            return;
        }
        if (!select.from().table().has_name()) {
            throw new IllegalStateException("Need table in FROM.");
        }
        GeometryExpressionBuilder expbuilder = sqlbuilder.expression();
        if (query.hasAggregateFunctions()) {
            for (FeatureAttributeDescriptor featureAttributeDescriptor : ResultSetForSetProviderOperation.attributeDescriptorsIterable(setType, query)) {
                String name = featureAttributeDescriptor.getName();
                if (!select.has_column(name) || query.isAGroupByColumn(name) || query.isAggregate(name)) continue;
                select.column(name).value((ExpressionBuilder.Value)ExpressionBuilder.VALUE_NULL).as(name);
            }
            for (Map.Entry entry : query.getAggregateFunctions().entrySet()) {
                String aggregateFunction = (String)entry.getValue();
                String aggregateExpression = (String)entry.getKey();
                FeatureAttributeDescriptor attr = ResultSetForSetProviderOperation.getAttributeDescriptor(aggregateExpression, setType, allExtraColumns);
                if (attr == null) {
                    Expression exp = ExpressionUtils.createExpression((String)aggregateExpression);
                    Code code = exp.getCode();
                    if (!(code instanceof Code.Callable)) {
                        throw new RuntimeException("Not able to use aggregate function with this expression(1): " + aggregateExpression);
                    }
                    Code.Callable callable = (Code.Callable)code;
                    if (!callable.name().equalsIgnoreCase("LET")) {
                        throw new RuntimeException("Not able to use aggregate function with this expression(2): " + aggregateExpression);
                    }
                    String name = ((Code.Identifier)callable.parameters().get(0)).name();
                    ExpressionBuilder.Value value = ((Code)callable.parameters().get(1)).toValue();
                    ExpressionBuilder.Function aggregateExp = expbuilder.function(aggregateFunction, new ExpressionBuilder.Value[]{value});
                    select.column(name).value((ExpressionBuilder.Value)aggregateExp).as(name);
                    continue;
                }
                SQLBuilder.SelectColumnBuilder column = select.column(attr.getName());
                ExpressionBuilder.Value value = ResultSetForSetProviderOperation.createValueFromAttribute(sqlbuilder, attr, select.from().table());
                ExpressionBuilder.Function aggregateExp = expbuilder.function(aggregateFunction, new ExpressionBuilder.Value[]{value});
                ResultSetForSetProviderOperation.addTableNameToColumns(sqlbuilder, (ExpressionBuilder.Value)aggregateExp, true);
                column.value((ExpressionBuilder.Value)aggregateExp).as(attr.getName());
            }
        }
    }

    public static void process5_GroupBys(OperationsFactory.TableReference table, FeatureType setType, FeatureQuery query, Map<String, EditableFeatureAttributeDescriptor> allExtraColumns, SQLBuilder sqlbuilder, SQLBuilder.SelectBuilder select, List<String> extraColumnNames) throws RuntimeException {
        if (query == null) {
            return;
        }
        if (!select.from().table().has_name()) {
            throw new IllegalStateException("Need table in FROM.");
        }
        if (query.hasGroupByColumns()) {
            GeometryExpressionBuilder expbuilder = sqlbuilder.expression();
            for (FeatureAttributeDescriptor attr : ResultSetForSetProviderOperation.attributeDescriptorsIterable(new Iterable[]{setType, query.getExtraColumns()})) {
                String name = attr.getName();
                if (!select.has_column(name) || query.isAGroupByColumn(name) || query.isAggregate(name)) continue;
                select.column(name).value((ExpressionBuilder.Value)ExpressionBuilder.VALUE_NULL).as(name);
            }
            for (String attrName : query.getGroupByColumns()) {
                FeatureAttributeDescriptor attr = ResultSetForSetProviderOperation.getAttributeDescriptor(attrName, setType, allExtraColumns);
                if (attr == null) {
                    try {
                        Code code = ExpressionUtils.compile((String)attrName);
                        select.group_by(new ExpressionBuilder.Value[]{code.toValue()});
                        continue;
                    }
                    catch (Exception ex) {
                        throw new RuntimeException("Not able to create column by expression in groupby query", ex);
                    }
                }
                ExpressionBuilder.Value value = ResultSetForSetProviderOperation.createValueFromAttribute(sqlbuilder, attr, select.from().table());
                if (value instanceof SQLBuilder.Column && select.getColumns().isEmpty()) {
                    select.column(attr.getName());
                }
                ResultSetForSetProviderOperation.addTableNameToColumns(sqlbuilder, value, true);
                select.group_by(new ExpressionBuilder.Value[]{value});
            }
        }
    }

    public static void process3_Where(JDBCHelper helper, FeatureType storeType, FeatureQuery query, SQLBuilder sqlbuilder, SQLBuilder.SelectBuilder select) {
        String sqlfilter;
        if (query == null) {
            return;
        }
        if (!select.from().table().has_name()) {
            throw new IllegalStateException("Need table in FROM.");
        }
        GeometryExpressionBuilder expbuilder = sqlbuilder.expression();
        Evaluator filter = query.getFilter();
        if (filter != null && !StringUtils.isEmpty((CharSequence)(sqlfilter = filter.getSQL())) && helper.supportFilter(storeType, filter)) {
            ExpressionBuilder.Value value = expbuilder.toValue(sqlfilter);
            ResultSetForSetProviderOperation.addTableNameToColumns(sqlbuilder, value, true);
            select.where().set(value);
        }
    }

    public static void process6_OrderBy(FeatureType storeType, FeatureType setType, FeatureQuery query, Map<String, EditableFeatureAttributeDescriptor> allExtraColumns, SQLBuilder sqlbuilder, SQLBuilder.SelectBuilder select, List<String> primaryKeys, List<String> extraColumnNames, List<ExpressionBuilder.Value> valuesToRemoveFeatureType) {
        Object order;
        if (!select.from().table().has_name()) {
            throw new IllegalStateException("Need table in FROM.");
        }
        GeometryExpressionBuilder expbuilder = sqlbuilder.expression();
        if (query != null && (order = query.getOrder()) != null) {
            int nullsMode;
            String sqlorder;
            FeatureAttributeDescriptor attr;
            String attrName;
            if (query.hasAggregateFunctions() || query.hasGroupByColumns()) {
                for (FeatureQueryOrder.FeatureQueryOrderMember member : order.members()) {
                    ExpressionBuilder.Value value;
                    if (member == null) continue;
                    attrName = member.getAttributeName();
                    attr = ResultSetForSetProviderOperation.getAttributeDescriptor(attrName, setType, allExtraColumns);
                    if (attr == null) {
                        if (member.getEvaluator() == null) {
                            select.order_by().column(attrName).ascending(member.getAscending());
                            continue;
                        }
                        sqlorder = member.getEvaluator().getSQL();
                        select.order_by().value(expbuilder.toValue(sqlorder)).ascending(member.getAscending());
                        continue;
                    }
                    if (query.isAGroupByColumn(attrName)) {
                        value = ResultSetForSetProviderOperation.createValueFromAttribute(sqlbuilder, attr, select.from().table());
                    } else {
                        if (!query.isAggregate(attrName)) continue;
                        String fn = (String)query.getAggregateFunctions().get(attr.getName());
                        value = ResultSetForSetProviderOperation.createValueFromAttribute(sqlbuilder, attr, select.from().table());
                        value = expbuilder.function(fn, new ExpressionBuilder.Value[]{value});
                    }
                    nullsMode = 1;
                    if (!attr.allowNull() || attr.isPrimaryKey()) {
                        nullsMode = 2;
                    }
                    boolean expand = !query.isAggregate(attrName) ? select.has_aggregate_functions() : false;
                    if (select.isGroupBy(attrName)) {
                        expand = false;
                    }
                    ResultSetForSetProviderOperation.expandColumns(value, expand, valuesToRemoveFeatureType);
                    ResultSetForSetProviderOperation.addTableNameToColumns(sqlbuilder, value, !attr.isComputed());
                    select.order_by().value(value).ascending(member.getAscending()).nulls(nullsMode);
                }
            } else {
                for (FeatureQueryOrder.FeatureQueryOrderMember member : order.members()) {
                    if (member == null) continue;
                    attrName = member.getAttributeName();
                    attr = ResultSetForSetProviderOperation.getAttributeDescriptor(attrName, setType, allExtraColumns);
                    if (attr == null) {
                        if (member.getEvaluator() == null) {
                            select.order_by().column(attrName).ascending(member.getAscending());
                            continue;
                        }
                        sqlorder = member.getEvaluator().getSQL();
                        select.order_by().value(expbuilder.toValue(sqlorder)).ascending(member.getAscending());
                        continue;
                    }
                    SQLBuilder.Column column = sqlbuilder.column(attr.getName());
                    if (!attr.isComputed()) {
                        column.table(select.from().table());
                    }
                    nullsMode = 1;
                    if (!attr.allowNull() || attr.isPrimaryKey()) {
                        nullsMode = 2;
                    }
                    ResultSetForSetProviderOperation.expandColumns((ExpressionBuilder.Value)column, false, valuesToRemoveFeatureType);
                    ResultSetForSetProviderOperation.addTableNameToColumns(sqlbuilder, (ExpressionBuilder.Value)column, !attr.isComputed());
                    select.order_by().value((ExpressionBuilder.Value)column).ascending(member.getAscending()).nulls(nullsMode);
                }
            }
        }
        if (query != null && !query.hasOrder() && query.hasGroupByColumns()) {
            for (String attrName : query.getGroupByColumns()) {
                FeatureAttributeDescriptor attr = ResultSetForSetProviderOperation.getAttributeDescriptor(attrName, setType, allExtraColumns);
                if (attr == null || query.getOrder().get(attrName) != null) continue;
                ExpressionBuilder.Value value = ResultSetForSetProviderOperation.createValueFromAttribute(sqlbuilder, attr, select.from().table());
                int nullsMode = 1;
                if (!attr.allowNull() || attr.isPrimaryKey()) {
                    nullsMode = 2;
                }
                ResultSetForSetProviderOperation.expandColumns(value, true, valuesToRemoveFeatureType);
                ResultSetForSetProviderOperation.addTableNameToColumns(sqlbuilder, value, true);
                select.order_by().value(value).ascending(true).nulls(nullsMode);
            }
        }
        if (primaryKeys.isEmpty()) {
            select.disable_check_order_and_offset();
        } else if (query == null || !query.hasAggregateFunctions() && !query.hasGroupByColumns()) {
            Object x;
            Object object = x = query == null ? null : query.getQueryParameter("DONT_ADD_PRIMARY_KEY_IN_THE_ORDER");
            if (x == null || !DataTypeUtils.toBoolean((Object)x)) {
                for (String attrName : primaryKeys) {
                    if (select.getOrderBy(attrName) != null) continue;
                    SQLBuilder.Column col = sqlbuilder.column(select.from().table(), attrName);
                    select.order_by().value((ExpressionBuilder.Value)col).ascending().nulls(2);
                }
            }
        }
    }

    private boolean isPaginated() {
        return this.offset > 0L || this.offset == 0L && this.limit > 0L;
    }

    public ResulSetControler.ResultSetEntry createResultSet() throws DataException {
        ArrayList<FeatureAttributeDescriptor> columns = new ArrayList<FeatureAttributeDescriptor>();
        ArrayList<String> extraColumnNames = new ArrayList<String>();
        JDBCSQLBuilderBase sqlbuilder = this.createSQLBuilder();
        String sql = this.getSQL(sqlbuilder, columns, extraColumnNames);
        ResulSetControler.ResultSetEntry resultSetEntry = this.helper.getResulSetControler().create(sql, this.fetchSize, columns.toArray(new FeatureAttributeDescriptor[columns.size()]), extraColumnNames.toArray(new String[extraColumnNames.size()]));
        return resultSetEntry;
    }

    private boolean shouldUseACustomSelect() {
        if (!this.table.hasSubquery()) {
            return false;
        }
        if (this.query == null) {
            return false;
        }
        if (this.query.isUseSubquery()) {
            return false;
        }
        if (this.query.hasGroupByColumns()) {
            return false;
        }
        if (this.query.hasAggregateFunctions()) {
            return false;
        }
        if (!this.query.hasFilter() && !this.query.hasOrder()) {
            return true;
        }
        return true;
    }

    public static Map<String, EditableFeatureAttributeDescriptor> getAllExtraColumns(FeatureType setType, FeatureQuery query) {
        HashMap<String, EditableFeatureAttributeDescriptor> allExtraColumns = new HashMap<String, EditableFeatureAttributeDescriptor>();
        for (EditableFeatureAttributeDescriptor column : setType.getExtraColumns().getColumns()) {
            allExtraColumns.put(column.getName(), column);
        }
        if (query != null) {
            for (EditableFeatureAttributeDescriptor column : query.getExtraColumn().getColumns()) {
                allExtraColumns.put(column.getName(), column);
            }
        }
        return allExtraColumns;
    }

    private static Iterable<FeatureAttributeDescriptor> attributeDescriptorsIterable(Iterable ... iterables) {
        return new ChainedIterable(iterables);
    }

    private static Iterable<FeatureAttributeDescriptor> attributeDescriptorsIterable(FeatureType setType, FeatureQuery query) {
        if (query == null) {
            return new ChainedIterable(new Iterable[]{setType});
        }
        return ResultSetForSetProviderOperation.attributeDescriptorsIterable(new Iterable[]{setType, query.getExtraColumns()});
    }

    private static boolean existsAttributeDescriptor(String attrName, FeatureType setType, Map<String, EditableFeatureAttributeDescriptor> allExtraColumns) {
        return ResultSetForSetProviderOperation.getAttributeDescriptor(attrName, setType, allExtraColumns) != null;
    }

    private static FeatureAttributeDescriptor getAttributeDescriptor(String attrName, FeatureType setType, Map<String, EditableFeatureAttributeDescriptor> extraColumns) {
        FeatureAttributeDescriptor attr = null;
        if (setType != null) {
            attr = setType.getAttributeDescriptorFromAll(attrName);
        }
        if (attr == null && extraColumns != null) {
            attr = (FeatureAttributeDescriptor)extraColumns.get(attrName);
        }
        return attr;
    }

    private static void expandColumns(ExpressionBuilder.Value value, boolean expand, List<ExpressionBuilder.Value> valuesToRemoveFeatureType) {
        if (!expand) {
            valuesToRemoveFeatureType.add(value);
        }
    }

    private static void addTableNameToColumns(SQLBuilder sqlbuilder, ExpressionBuilder.Value expression, boolean add) {
        sqlbuilder.setProperties((ExpressionBuilder.Visitable)expression, null, new Object[]{"ADD_TABLE_NAME", add});
    }

    private static ExpressionBuilder.Value createValueFromAttribute(SQLBuilder sqlbuilder, FeatureAttributeDescriptor attr, SQLBuilder.TableNameBuilder tableBuilder) {
        switch (attr.getRelationType()) {
            case 3: 
            case 4: {
                return ExpressionBuilder.VALUE_NULL;
            }
        }
        if (attr.isComputed()) {
            FeatureAttributeEmulator attrEmulator = attr.getFeatureAttributeEmulator();
            if (!(attrEmulator instanceof FeatureAttributeEmulatorExpression)) {
                return ExpressionBuilder.VALUE_NULL;
            }
            FeatureAttributeEmulatorExpression x = (FeatureAttributeEmulatorExpression)attrEmulator;
            Expression exp = x.getExpression();
            if (exp == null || exp.isEmpty()) {
                return ExpressionBuilder.VALUE_NULL;
            }
            Code code = exp.getCode();
            SymbolTable symbolTable = ExpressionEvaluatorLocator.getExpressionEvaluatorManager().getInmutableSymbolTable();
            code.link(symbolTable);
            ExpressionBuilder.Value value = code.toValue((ExpressionBuilder)sqlbuilder.expression());
            return value;
        }
        SQLBuilder.Column column = sqlbuilder.column(tableBuilder, attr.getName());
        return column;
    }
}

