/*
 * Decompiled with CFR 0.152.
 */
package com.jeta.forms.components.colors;

import com.jeta.forms.components.colors.ColorChooserFactory;
import com.jeta.open.i18n.I18N;
import com.jeta.open.registry.JETARegistry;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Iterator;
import java.util.LinkedList;
import javax.swing.BorderFactory;
import javax.swing.JColorChooser;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;

public class JETAColorWell
extends JComponent {
    private Color m_color;
    private LinkedList m_listeners;

    public JETAColorWell() {
        this.initialize(null);
    }

    public JETAColorWell(Color color) {
        this.initialize(color);
    }

    public void addActionListener(ActionListener listener) {
        if (this.m_listeners == null) {
            this.m_listeners = new LinkedList();
        }
        if (!this.m_listeners.contains(listener)) {
            this.m_listeners.add(listener);
        }
    }

    public Color getColor() {
        return this.m_color;
    }

    protected void initialize(Color color) {
        this.m_color = color == null ? Color.black : color;
        this.setBorder(BorderFactory.createBevelBorder(1));
        Dimension d = new Dimension(16, 16);
        this.setSize(d);
        this.setPreferredSize(d);
        this.addMouseListener(new ColorWellListener());
    }

    protected void notifyListeners(ActionEvent evt) {
        if (this.m_listeners != null) {
            Iterator iter = this.m_listeners.iterator();
            while (iter.hasNext()) {
                ActionListener listener = (ActionListener)iter.next();
                listener.actionPerformed(evt);
            }
        }
    }

    public void paintComponent(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setPaint(this.getColor());
        Rectangle rect = g.getClipBounds();
        g2.fillRect(rect.x, rect.y, rect.width, rect.height);
    }

    public void removeActionListener(ActionListener listener) {
        if (this.m_listeners != null) {
            this.m_listeners.remove(listener);
        }
    }

    public void setColor(Color color) {
        this.m_color = color;
        this.repaint();
    }

    public class ColorWellListener
    extends MouseAdapter {
        public void mouseClicked(MouseEvent evt) {
            JETAColorWell comp = (JETAColorWell)evt.getSource();
            Color result = null;
            ColorChooserFactory factory = (ColorChooserFactory)JETARegistry.lookup("color.chooser.factory");
            result = factory != null ? factory.showColorChooser(comp, I18N.getLocalizedMessage("Color Chooser"), comp.getColor()) : JColorChooser.showDialog(SwingUtilities.getWindowAncestor(comp), I18N.getLocalizedMessage("Color Chooser"), comp.getColor());
            if (result != null) {
                comp.setColor(result);
                comp.notifyListeners(new ActionEvent(JETAColorWell.this, 1001, comp.getName()));
            }
        }
    }
}

