/*
 * Decompiled with CFR 0.152.
 */
package com.jeta.forms.gui.effects;

import com.jeta.forms.gui.effects.Painter;
import com.jeta.forms.store.properties.effects.RadialGradientProperty;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import org.apache.batik.ext.awt.RadialGradientPaint;

public class RadialGradientPainter
implements Painter {
    private RadialGradientProperty m_gradient_prop;
    private Paint m_cached_paint;
    private Rectangle m_last_rect = new Rectangle();
    private LookAndFeel m_look_and_feel;
    private int m_radius_type = 0;
    public static final int SQUARE_BASED = 0;
    public static final int WIDTH_BASED = 1;
    public static final int HEIGHT_BASED = 2;

    public RadialGradientPainter() {
    }

    public RadialGradientPainter(RadialGradientProperty prop) {
        this.m_gradient_prop = prop;
    }

    private double calculateRadius(double width, double height, int magnitude) {
        if (this.m_radius_type == 1) {
            return width * (double)magnitude / 100.0;
        }
        if (this.m_radius_type == 2) {
            return height * (double)magnitude / 100.0;
        }
        return Math.sqrt(Math.pow(width, 2.0) + Math.pow(height, 2.0)) * (double)magnitude / 100.0;
    }

    private Paint createPaint(Rectangle rect, RadialGradientProperty gp) {
        double w_half = rect.getWidth() / 2.0;
        double h_half = rect.getHeight() / 2.0;
        double x = rect.getX() + w_half;
        double y = rect.getY() + h_half;
        double radius = (double)gp.getMagnitude() * rect.getWidth() / 400.0;
        if (gp.getPosition() == 0) {
            x = rect.getX();
            y = rect.getY();
            radius = this.calculateRadius(w_half, h_half, gp.getMagnitude());
        } else if (gp.getPosition() == 1) {
            x = w_half;
            y = rect.getY();
            radius = w_half * (double)gp.getMagnitude() / 100.0;
        } else if (gp.getPosition() == 2) {
            x = rect.getX() + rect.getWidth();
            y = rect.getY();
            radius = this.calculateRadius(w_half, h_half, gp.getMagnitude());
        } else if (gp.getPosition() == 4) {
            x = rect.getX();
            y = rect.getY() + rect.getHeight();
            radius = this.calculateRadius(w_half, h_half, gp.getMagnitude());
        } else if (gp.getPosition() == 5) {
            x = w_half;
            y = rect.getY() + rect.getHeight();
            radius = w_half * (double)gp.getMagnitude() / 100.0;
        } else if (gp.getPosition() == 6) {
            x = rect.getX() + rect.getWidth();
            y = rect.getY() + rect.getHeight();
            radius = this.calculateRadius(w_half, h_half, gp.getMagnitude());
        } else if (gp.getPosition() == 7) {
            x = rect.getX();
            y = rect.getY() + h_half;
            radius = h_half * (double)gp.getMagnitude() / 100.0;
        } else if (gp.getPosition() == 8) {
            x = rect.getX() + rect.getWidth();
            y = rect.getY() + h_half;
            radius = h_half * (double)gp.getMagnitude() / 100.0;
        }
        float[] fractions = new float[]{0.0f, 1.0f};
        Color[] colors = new Color[]{gp.getStartColor().getColor(), gp.getEndColor().getColor()};
        RadialGradientPaint paint = new RadialGradientPaint((float)x, (float)y, (float)radius, fractions, colors);
        return paint;
    }

    public void paint(Component c, Graphics g, Rectangle rect) {
        if (rect == null || this.m_gradient_prop == null) {
            return;
        }
        Graphics2D g2 = (Graphics2D)g;
        Paint old_paint = g2.getPaint();
        LookAndFeel lf = UIManager.getLookAndFeel();
        if (this.m_look_and_feel != lf) {
            this.m_cached_paint = null;
            this.m_look_and_feel = lf;
        }
        if (this.m_cached_paint == null || !rect.equals(this.m_last_rect)) {
            this.m_last_rect.setBounds(rect.x, rect.y, rect.width, rect.height);
            this.m_cached_paint = this.createPaint(rect, this.m_gradient_prop);
        }
        g2.setPaint(this.m_cached_paint);
        Rectangle clip_rect = g.getClipBounds();
        if (rect.intersects(clip_rect)) {
            Rectangle irect = rect.intersection(clip_rect);
            g.fillRect(irect.x, irect.y, irect.width, irect.height);
            g2.setPaint(old_paint);
        }
        g2.setPaint(old_paint);
    }

    public void setGradientProperty(RadialGradientProperty prop) {
        this.m_cached_paint = null;
        this.m_gradient_prop = prop;
    }

    public void setRadiusType(int rtype) {
        this.m_radius_type = rtype;
    }
}

