/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.oracle.dal;

import java.io.InputStream;
import org.gvsig.fmap.dal.DALLibrary;
import org.gvsig.fmap.dal.DALLocator;
import org.gvsig.fmap.dal.DataServerExplorerFactory;
import org.gvsig.fmap.dal.DataStoreProviderFactory;
import org.gvsig.fmap.dal.spi.DataManagerProviderServices;
import org.gvsig.fmap.dal.store.db.DBHelper;
import org.gvsig.fmap.dal.store.jdbc2.JDBCLibrary;
import org.gvsig.fmap.dal.store.jdbc2.spi.JDBCStoreProviderBase;
import org.gvsig.json.Json;
import org.gvsig.metadata.exceptions.MetadataException;
import org.gvsig.oracle.dal.OracleExplorerFactory;
import org.gvsig.oracle.dal.OracleExplorerParameters;
import org.gvsig.oracle.dal.OracleNewStoreParameters;
import org.gvsig.oracle.dal.OracleStoreParameters;
import org.gvsig.oracle.dal.OracleStoreProviderFactory;
import org.gvsig.tools.exception.ListBaseException;
import org.gvsig.tools.library.AbstractLibrary;
import org.gvsig.tools.library.LibraryException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OracleLibrary
extends AbstractLibrary {
    private static final Logger LOGGER = LoggerFactory.getLogger(OracleLibrary.class);
    public static final String NAME = "Oracle";

    public void doRegistration() {
        this.registerAsServiceOf(DALLibrary.class);
        this.require(JDBCLibrary.class);
    }

    protected void doInitialize() throws LibraryException {
    }

    protected void doPostInitialize() throws LibraryException {
        LibraryException ex = null;
        DataManagerProviderServices dataman = (DataManagerProviderServices)DALLocator.getDataManager();
        try {
            Class.forName("oracle.jdbc.driver.OracleDriver");
        }
        catch (Throwable th) {
            LOGGER.warn("Can't load Oracle JDBC Driver.", th);
        }
        DBHelper.registerParametersDefinition((String)"OracleStoreParameters", OracleStoreParameters.class, (InputStream)dataman.getResourceAsStream((Object)this, "OracleParameters.xml"));
        DBHelper.registerParametersDefinition((String)"OracleNewStoreParameters", OracleNewStoreParameters.class, (InputStream)dataman.getResourceAsStream((Object)this, "OracleParameters.xml"));
        DBHelper.registerParametersDefinition((String)"OracleServerExplorerParameters", OracleExplorerParameters.class, (InputStream)dataman.getResourceAsStream((Object)this, "OracleParameters.xml"));
        try {
            DBHelper.registerMetadataDefinition((String)NAME, JDBCStoreProviderBase.class, (InputStream)dataman.getResourceAsStream((Object)this, "OracleMetadata.xml"));
        }
        catch (MetadataException e) {
            ex = new LibraryException(((Object)((Object)this)).getClass(), (ListBaseException)e);
        }
        if (!dataman.getStoreProviderRegister().exits(NAME)) {
            dataman.registerStoreProviderFactory((DataStoreProviderFactory)new OracleStoreProviderFactory());
        }
        if (!dataman.getServerExplorerRegister().exits(NAME)) {
            dataman.registerServerExplorerFactory((DataServerExplorerFactory)new OracleExplorerFactory());
        }
        Json.registerSerializer(OracleExplorerParameters.class);
        if (ex != null) {
            throw ex;
        }
    }
}

