/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.oracle.dal;

import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.exception.InitializeException;
import org.gvsig.fmap.dal.feature.FeatureAttributeDescriptor;
import org.gvsig.fmap.dal.feature.FeatureType;
import org.gvsig.fmap.dal.spi.DataStoreProviderServices;
import org.gvsig.fmap.dal.store.jdbc.JDBCStoreParameters;
import org.gvsig.fmap.dal.store.jdbc2.JDBCHelper;
import org.gvsig.fmap.dal.store.jdbc2.spi.JDBCStoreProviderBase;
import org.gvsig.tools.dynobject.DynObject;

public class OracleStoreProvider
extends JDBCStoreProviderBase {
    private FeatureType originalFeatureType;

    public OracleStoreProvider(JDBCStoreParameters params, DataStoreProviderServices storeServices, DynObject metadata, JDBCHelper helper) throws InitializeException {
        super(params, storeServices, metadata, helper);
    }

    public void fixFeatureTypeFromParameters() {
        try {
            super.fixFeatureTypeFromParameters();
            FeatureType dalFeatureType = this.getStoreServices().getDefaultFeatureType();
            FeatureAttributeDescriptor dalGeomAttr = dalFeatureType.getDefaultGeometryAttribute();
            FeatureAttributeDescriptor originalGeomAttr = this.originalFeatureType.getDefaultGeometryAttribute();
            if (dalGeomAttr == null || originalGeomAttr == null) {
                return;
            }
            Object v = originalGeomAttr.getTags().get("oracle_srid");
            if (v != null) {
                dalGeomAttr.getTags().set("oracle_srid", v);
            }
        }
        catch (DataException ex) {
            LOGGER.warn("Can't fix featureType from original database feature type.", (Throwable)ex);
        }
    }

    protected void initializeFeatureType() {
        super.initializeFeatureType();
        try {
            this.originalFeatureType = this.getStoreServices().getDefaultFeatureType();
        }
        catch (DataException ex) {
            throw new RuntimeException("Can't get originalFeatureType.", ex);
        }
    }
}

